/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.droptable.item;

import io.lumine.mythic.lib.api.item.NBTItem;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.droptable.item.DropItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.RandomAmount;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MMOItemDropItem
extends DropItem {
    private final Type type;
    private final String id;
    private final double unidentification;

    public MMOItemDropItem(Type type, String id, double drop, double unidentification, RandomAmount amount) {
        this(type, id, drop, unidentification, amount.getMin(), amount.getMax());
    }

    public MMOItemDropItem(Type type, String id, double drop, double unidentification, int min, int max) {
        super(drop, min, max);
        this.type = type;
        this.id = id;
        this.unidentification = unidentification;
    }

    public MMOItemDropItem(Type type, String id, String info) {
        super(info);
        this.type = type;
        this.id = id;
        String[] argSplit = info.split(",");
        this.unidentification = Double.parseDouble(argSplit[2]) / 100.0;
    }

    public Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public boolean rollIdentification() {
        return random.nextDouble() < this.unidentification;
    }

    @Override
    public ItemStack getItem(PlayerData player, int amount) {
        ItemStack item;
        if (!MMOItems.plugin.getTemplates().hasTemplate(this.type, this.id)) {
            return null;
        }
        ItemStack itemStack = item = player == null ? MMOItems.plugin.getItem(this.type, this.id) : MMOItems.plugin.getItem(this.type, this.id, player);
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        if (this.rollIdentification()) {
            item = this.type.getUnidentifiedTemplate().newBuilder(NBTItem.get((ItemStack)item)).build();
        }
        item.setAmount(amount);
        return item;
    }

    @Override
    public String getKey() {
        return this.type.getId() + "." + this.id;
    }
}

