/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.recipe;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.version.Sounds;
import java.util.Random;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.api.crafting.ConfigMMOItem;
import net.Indyuce.mmoitems.api.crafting.CraftingStation;
import net.Indyuce.mmoitems.api.crafting.ingredient.CheckedIngredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.Ingredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.MMOItemIngredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.IngredientInventory;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.PlayerIngredient;
import net.Indyuce.mmoitems.api.crafting.recipe.CheckedRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.Recipe;
import net.Indyuce.mmoitems.api.event.PlayerUseCraftingStationEvent;
import net.Indyuce.mmoitems.api.item.mmoitem.LiveMMOItem;
import net.Indyuce.mmoitems.api.item.util.ConfigItems;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.message.Message;
import net.Indyuce.mmoitems.stat.data.UpgradeData;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class UpgradingRecipe
extends Recipe {
    private final ConfigMMOItem item;
    private final Ingredient ingredient;
    private static final Random random = new Random();

    public UpgradingRecipe(ConfigurationSection config) {
        super(config);
        this.item = new ConfigMMOItem(config.getConfigurationSection("item"));
        this.ingredient = new MMOItemIngredient(this.item);
    }

    public ConfigMMOItem getItem() {
        return this.item;
    }

    @Override
    public boolean whenUsed(PlayerData data, IngredientInventory inv, CheckedRecipe castRecipe, CraftingStation station) {
        if (!data.isOnline()) {
            return false;
        }
        CheckedUpgradingRecipe recipe = (CheckedUpgradingRecipe)castRecipe;
        PlayerUseCraftingStationEvent event = new PlayerUseCraftingStationEvent(data, station, recipe);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        recipe.getUpgradeData().upgrade(recipe.getMMOItem());
        recipe.getUpgraded().setItemMeta(recipe.getMMOItem().newBuilder().build().getItemMeta());
        Message.UPGRADE_SUCCESS.format(ChatColor.YELLOW, "#item#", MMOUtils.getDisplayName(recipe.getUpgraded())).send(data.getPlayer());
        if (!this.hasOption(Recipe.RecipeOption.SILENT_CRAFT)) {
            data.getPlayer().playSound(data.getPlayer().getLocation(), station.getSound(), 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public boolean canUse(PlayerData data, IngredientInventory inv, CheckedRecipe uncastRecipe, CraftingStation station) {
        CheckedIngredient upgraded = inv.findMatching(this.ingredient);
        if (!upgraded.isHad()) {
            if (!data.isOnline()) {
                return false;
            }
            Message.NOT_HAVE_ITEM_UPGRADE.format(ChatColor.RED, new String[0]).send(data.getPlayer());
            data.getPlayer().playSound(data.getPlayer().getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
            return false;
        }
        CheckedUpgradingRecipe recipe = (CheckedUpgradingRecipe)uncastRecipe;
        NBTItem firstItem = NBTItem.get((ItemStack)((PlayerIngredient)upgraded.getFound().stream().findFirst().get()).getItem());
        if (!(recipe.mmoitem = new LiveMMOItem(firstItem)).hasData(ItemStats.UPGRADE)) {
            return false;
        }
        if (!(recipe.upgradeData = (UpgradeData)recipe.getMMOItem().getData(ItemStats.UPGRADE)).canLevelUp()) {
            if (!data.isOnline()) {
                return false;
            }
            Message.MAX_UPGRADES_HIT.format(ChatColor.RED, new String[0]).send(data.getPlayer());
            data.getPlayer().playSound(data.getPlayer().getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 2.0f);
            return false;
        }
        if (random.nextDouble() > recipe.getUpgradeData().getSuccess()) {
            if (recipe.getUpgradeData().destroysOnFail()) {
                recipe.getUpgraded().setAmount(recipe.getUpgraded().getAmount() - 1);
            }
            recipe.getIngredients().forEach(ingredient -> ingredient.takeAway());
            if (!data.isOnline()) {
                return false;
            }
            Message.UPGRADE_FAIL_STATION.format(ChatColor.RED, new String[0]).send(data.getPlayer());
            data.getPlayer().playSound(data.getPlayer().getLocation(), Sounds.ENTITY_ITEM_BREAK, 1.0f, 2.0f);
            return false;
        }
        return true;
    }

    @Override
    public ItemStack display(CheckedRecipe recipe) {
        return ConfigItems.UPGRADING_RECIPE_DISPLAY.newBuilder(recipe).build();
    }

    @Override
    public CheckedRecipe evaluateRecipe(PlayerData data, IngredientInventory inv) {
        return new CheckedUpgradingRecipe(this, data, inv);
    }

    public class CheckedUpgradingRecipe
    extends CheckedRecipe {
        private LiveMMOItem mmoitem;
        private UpgradeData upgradeData;

        public CheckedUpgradingRecipe(Recipe recipe, PlayerData data, IngredientInventory inv) {
            super(recipe, data, inv);
        }

        public UpgradeData getUpgradeData() {
            return this.upgradeData;
        }

        public LiveMMOItem getMMOItem() {
            return this.mmoitem;
        }

        public ItemStack getUpgraded() {
            return this.mmoitem.getNBT().getItem();
        }
    }
}

