/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.recipe;

import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.UIFilterManager;
import io.lumine.mythic.lib.api.util.SmartGive;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackMessage;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.version.Sounds;
import java.util.ArrayList;
import java.util.List;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.crafting.ConfigMMOItem;
import net.Indyuce.mmoitems.api.crafting.CraftingStation;
import net.Indyuce.mmoitems.api.crafting.CraftingStatus;
import net.Indyuce.mmoitems.api.crafting.MMOItemUIFilter;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.IngredientInventory;
import net.Indyuce.mmoitems.api.crafting.recipe.CheckedRecipe;
import net.Indyuce.mmoitems.api.crafting.recipe.Recipe;
import net.Indyuce.mmoitems.api.event.PlayerUseCraftingStationEvent;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.item.util.ConfigItems;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.api.util.message.Message;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingRecipe
extends Recipe {
    @NotNull
    public static final String UNSPECIFIED = "N/A";
    private final double craftingTime;
    @NotNull
    private final ProvidedUIFilter output;
    @Nullable
    ConfigMMOItem identifiedMMO;

    public CraftingRecipe(@NotNull ConfigurationSection config) throws IllegalArgumentException {
        super(config);
        ProvidedUIFilter sweetOutput;
        this.craftingTime = config.getDouble("crafting-time");
        String uiFilter = config.getString("output.item", UNSPECIFIED);
        String miType = config.getString("output.type", UNSPECIFIED).toUpperCase().replace("-", "_").replace(" ", "_");
        String miID = config.getString("output.id", UNSPECIFIED).toUpperCase().replace("-", "_").replace(" ", "_");
        FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
        if (!UNSPECIFIED.equals(miType) && !UNSPECIFIED.equals(miID)) {
            sweetOutput = UIFilterManager.getUIFilter((String)"m", (String)miType, (String)miID, (String)config.getString("output.amount", "1"), (FriendlyFeedbackProvider)ffp);
            if (sweetOutput == null) {
                throw new IllegalArgumentException(SilentNumbers.collapseList((ArrayList)SilentNumbers.transcribeList((List)ffp.getFeedbackOf(FriendlyFeedbackCategory.ERROR), message -> {
                    if (message instanceof FriendlyFeedbackMessage) {
                        return ((FriendlyFeedbackMessage)message).forConsole((FriendlyFeedbackPalette)FFPMMOItems.get());
                    }
                    return "";
                }), (String)""));
            }
            this.output = sweetOutput;
        } else if (!UNSPECIFIED.equals(uiFilter)) {
            sweetOutput = UIFilterManager.getUIFilter((String)uiFilter, (FriendlyFeedbackProvider)ffp);
            if (sweetOutput == null) {
                throw new IllegalArgumentException(SilentNumbers.collapseList((ArrayList)SilentNumbers.transcribeList((List)ffp.getFeedbackOf(FriendlyFeedbackCategory.ERROR), message -> {
                    if (message instanceof FriendlyFeedbackMessage) {
                        return ((FriendlyFeedbackMessage)message).forConsole((FriendlyFeedbackPalette)FFPMMOItems.get());
                    }
                    return "";
                }), (String)""));
            }
            this.output = sweetOutput;
        } else {
            throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Config must contain a valid Type and ID, or a valid UIFilter. ", (String[])new String[0]));
        }
        if (!this.output.isValid(ffp)) {
            throw new IllegalArgumentException(SilentNumbers.collapseList((ArrayList)SilentNumbers.transcribeList((List)ffp.getFeedbackOf(FriendlyFeedbackCategory.ERROR), message -> {
                if (message instanceof FriendlyFeedbackMessage) {
                    return ((FriendlyFeedbackMessage)message).forConsole((FriendlyFeedbackPalette)FFPMMOItems.get());
                }
                return "";
            }), (String)""));
        }
        if (this.output.getItemStack(ffp) == null) {
            throw new IllegalArgumentException(SilentNumbers.collapseList((ArrayList)SilentNumbers.transcribeList((List)ffp.getFeedbackOf(FriendlyFeedbackCategory.ERROR), message -> {
                if (message instanceof FriendlyFeedbackMessage) {
                    return ((FriendlyFeedbackMessage)message).forConsole((FriendlyFeedbackPalette)FFPMMOItems.get());
                }
                return "";
            }), (String)""));
        }
        if (this.output.getParent() instanceof MMOItemUIFilter) {
            MMOItemTemplate template = MMOItems.plugin.getTemplates().getTemplate(MMOItems.plugin.getTypes().get(this.output.getArgument()), this.output.getData());
            if (template == null) {
                throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"This should be impossible, please contact $egunging$b: $fThe ProvidedUIFilter was flagged as 'valid' but clearly is not. $enet.Indyuce.mmoitems.api.crafting.recipe$b. ", (String[])new String[0]));
            }
            this.identifiedMMO = new ConfigMMOItem(template, this.output.getAmount(1));
        }
    }

    public double getCraftingTime() {
        return this.craftingTime;
    }

    public boolean isInstant() {
        return this.craftingTime <= 0.0;
    }

    @NotNull
    public ProvidedUIFilter getOutput() {
        return this.output;
    }

    @NotNull
    public ItemStack getOutputItemStack(@Nullable RPGPlayer rpg) {
        if (this.identifiedMMO != null && rpg != null) {
            return this.identifiedMMO.generate(rpg);
        }
        return this.output.getItemStack(null);
    }

    @NotNull
    public ItemStack getPreviewItemStack() {
        if (this.identifiedMMO != null) {
            return this.identifiedMMO.getPreview();
        }
        ItemStack gen = this.output.getParent().getDisplayStack(this.output.getArgument(), this.output.getData(), null);
        gen.setAmount(this.output.getAmount(1));
        ItemMeta itemMeta = gen.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(SilentNumbers.getItemName((ItemStack)gen, (boolean)false) + "\u00a7\u02ab");
            gen.setItemMeta(itemMeta);
        }
        return gen;
    }

    public int getOutputAmount() {
        return this.output.getAmount(1);
    }

    @Override
    public boolean whenUsed(PlayerData data, IngredientInventory inv, CheckedRecipe recipe, CraftingStation station) {
        if (!data.isOnline()) {
            return false;
        }
        if (this.isInstant()) {
            ItemStack result = this.hasOption(Recipe.RecipeOption.OUTPUT_ITEM) ? this.getOutputItemStack(data.getRPG()) : null;
            PlayerUseCraftingStationEvent event = new PlayerUseCraftingStationEvent(data, station, recipe, result);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            recipe.getRecipe().whenClaimed().forEach(trigger -> trigger.whenCrafting(data));
            if (result != null) {
                new SmartGive(data.getPlayer()).give(new ItemStack[]{result});
            }
            if (!this.hasOption(Recipe.RecipeOption.SILENT_CRAFT)) {
                data.getPlayer().playSound(data.getPlayer().getLocation(), station.getSound(), 1.0f, 1.0f);
            }
            return true;
        }
        PlayerUseCraftingStationEvent called = new PlayerUseCraftingStationEvent(data, station, recipe);
        Bukkit.getPluginManager().callEvent((Event)called);
        if (called.isCancelled()) {
            return false;
        }
        if (!this.hasOption(Recipe.RecipeOption.SILENT_CRAFT)) {
            data.getPlayer().playSound(data.getPlayer().getLocation(), station.getSound(), 1.0f, 1.0f);
        }
        data.getCrafting().getQueue(station).add(this);
        return true;
    }

    @Override
    public boolean canUse(PlayerData data, IngredientInventory inv, CheckedRecipe recipe, CraftingStation station) {
        if (this.isInstant()) {
            return true;
        }
        CraftingStatus.CraftingQueue queue = data.getCrafting().getQueue(station);
        if (queue.isFull(station)) {
            if (!data.isOnline()) {
                return false;
            }
            Message.CRAFTING_QUEUE_FULL.format(ChatColor.RED, new String[0]).send(data.getPlayer());
            data.getPlayer().playSound(data.getPlayer().getLocation(), Sounds.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    @Override
    public ItemStack display(CheckedRecipe recipe) {
        return ConfigItems.CRAFTING_RECIPE_DISPLAY.newBuilder(recipe).build();
    }

    @Override
    public CheckedRecipe evaluateRecipe(PlayerData data, IngredientInventory inv) {
        return new CheckedRecipe(this, data, inv);
    }
}

