/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.ingredient;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.api.crafting.uifilters.UIFilter;
import io.lumine.mythic.lib.api.crafting.uifilters.VanillaUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.UIFilterManager;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackMessage;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.List;
import net.Indyuce.mmoitems.api.crafting.ingredient.Ingredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.VanillaPlayerIngredient;
import net.Indyuce.mmoitems.api.player.RPGPlayer;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaIngredient
extends Ingredient<VanillaPlayerIngredient> {
    @NotNull
    final ProvidedUIFilter filter;
    @NotNull
    final Material material;
    @NotNull
    final String display;
    @Nullable
    final String displayName;
    boolean vanillaBackward = true;

    @NotNull
    public ProvidedUIFilter getFilter() {
        return this.filter;
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    public VanillaIngredient(MMOLineConfig config) {
        super("vanilla", config);
        FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
        config.validate(new String[]{"type"});
        String itemFilter = config.getString("type", "");
        if (itemFilter.contains(" ")) {
            this.vanillaBackward = false;
            ProvidedUIFilter sweetFilter = UIFilterManager.getUIFilter((String)itemFilter, (FriendlyFeedbackProvider)ffp);
            if (sweetFilter == null) {
                throw new IllegalArgumentException(SilentNumbers.collapseList((ArrayList)SilentNumbers.transcribeList((List)ffp.getFeedbackOf(FriendlyFeedbackCategory.ERROR), message -> {
                    if (message instanceof FriendlyFeedbackMessage) {
                        return ((FriendlyFeedbackMessage)message).forConsole((FriendlyFeedbackPalette)FFPMMOItems.get());
                    }
                    return "";
                }), (String)""));
            }
            this.filter = sweetFilter;
            if (!this.filter.isValid(ffp)) {
                throw new IllegalArgumentException(SilentNumbers.collapseList((ArrayList)SilentNumbers.transcribeList((List)ffp.getFeedbackOf(FriendlyFeedbackCategory.ERROR), message -> {
                    if (message instanceof FriendlyFeedbackMessage) {
                        return ((FriendlyFeedbackMessage)message).forConsole((FriendlyFeedbackPalette)FFPMMOItems.get());
                    }
                    return "";
                }), (String)""));
            }
            this.setAmount(this.filter.getAmount(this.getAmount()));
            this.filter.setAmount(Integer.valueOf(this.getAmount()));
            this.display = config.getString("display", this.findName());
            this.material = Material.STONE;
        } else {
            this.material = Material.valueOf((String)itemFilter.toUpperCase().replace("-", "_").replace(" ", "_"));
            this.filter = new ProvidedUIFilter((UIFilter)VanillaUIFilter.get(), this.material.toString(), "0");
            this.filter.setAmount(Integer.valueOf(this.getAmount()));
            this.display = config.getString("display", UtilityMethods.caseOnWords((String)this.material.toString().toLowerCase().replace("_", " ")));
        }
        if (this.filter.getItemStack(null) == null) {
            throw new IllegalArgumentException(SilentNumbers.collapseList((ArrayList)SilentNumbers.transcribeList((List)ffp.getFeedbackOf(FriendlyFeedbackCategory.ERROR), message -> {
                if (message instanceof FriendlyFeedbackMessage) {
                    return ((FriendlyFeedbackMessage)message).forConsole((FriendlyFeedbackPalette)FFPMMOItems.get());
                }
                return "";
            }), (String)""));
        }
        this.displayName = config.contains("name") ? config.getString("name") : null;
    }

    @Override
    public String getKey() {
        return "vanilla:" + (this.vanillaBackward ? this.material.toString().toLowerCase() : this.filter.toString().toLowerCase().replace(" ", "__")) + "_" + this.displayName;
    }

    @Override
    public String formatDisplay(String s) {
        return s.replace("#item#", this.display).replace("#amount#", String.valueOf(this.getAmount()));
    }

    @Override
    public boolean matches(VanillaPlayerIngredient ing) {
        if (this.vanillaBackward) {
            if (ing.getType() != this.material) {
                return false;
            }
            return ing.getDisplayName() != null ? ing.getDisplayName().equals(this.displayName) : this.displayName == null;
        }
        return this.filter.matches(ing.getSourceItem(), true, null);
    }

    @Override
    @NotNull
    public ItemStack generateItemStack(@NotNull RPGPlayer player, boolean forDisplay) {
        ItemStack stack = this.filter.getItemStack(null);
        stack.setAmount(this.getAmount());
        if (this.displayName != null) {
            ItemMeta meta = stack.getItemMeta();
            meta.setDisplayName(MythicLib.plugin.parseColors(this.displayName));
            stack.setItemMeta(meta);
        }
        return stack;
    }

    @NotNull
    String findName() {
        return SilentNumbers.getItemName((ItemStack)this.filter.getParent().getDisplayStack(this.filter.getArgument(), this.filter.getData(), null), (boolean)false);
    }
}

