/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.ingredient;

import java.util.Iterator;
import java.util.List;
import net.Indyuce.mmoitems.api.crafting.ingredient.Ingredient;
import net.Indyuce.mmoitems.api.crafting.ingredient.inventory.PlayerIngredient;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckedIngredient {
    @NotNull
    private final Ingredient ingredient;
    @Nullable
    private final List<PlayerIngredient> found;
    private final boolean isHad;

    public CheckedIngredient(@NotNull Ingredient ingredient, @NotNull List<PlayerIngredient> found) {
        this.ingredient = ingredient;
        this.found = found;
        this.isHad = this.getTotalAmount() >= ingredient.getAmount();
    }

    public boolean isHad() {
        return this.isHad;
    }

    public int getTotalAmount() {
        int total = 0;
        for (PlayerIngredient ing : this.found) {
            total += ing.getAmount();
        }
        return total;
    }

    public void takeAway() {
        this.reduceItem(this.ingredient.getAmount());
    }

    public void reduceItem(int amount) {
        Iterator<PlayerIngredient> iterator = this.found.iterator();
        while (iterator.hasNext() && amount > 0) {
            ItemStack item = iterator.next().getItem();
            if (item.getAmount() <= 0) {
                iterator.remove();
                continue;
            }
            int take = Math.min(item.getAmount(), amount);
            amount -= take;
            item.setAmount(item.getAmount() - take);
        }
    }

    @NotNull
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Nullable
    public List<PlayerIngredient> getFound() {
        return this.found;
    }

    @NotNull
    public String format() {
        return this.ingredient.formatDisplay(this.ingredient.getDisplay().format(this.isHad));
    }
}

