/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.condition;

import io.lumine.mythic.lib.api.MMOLineConfig;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.crafting.condition.GenericCondition;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;

public class PlaceholderCondition
extends GenericCondition {
    private final String expression1;
    private final String comparator;
    private final String expression2;
    private static final double EQUALITY_THRESHOLD = Math.pow(10.0, -5.0);

    public PlaceholderCondition(MMOLineConfig config) {
        super("placeholder", config);
        config.validateKeys(new String[]{"placeholder"});
        String[] array = config.getString("placeholder").split("~");
        Validate.isTrue((array.length == 3 ? 1 : 0) != 0, (String)"Please use exactly twice ~");
        this.expression1 = array[0];
        this.comparator = array[1];
        this.expression2 = array[2];
    }

    @Override
    public boolean isMet(PlayerData data) {
        String unparsed1 = PlaceholderAPI.setPlaceholders((Player)data.getPlayer(), (String)this.expression1);
        String unparsed2 = PlaceholderAPI.setPlaceholders((Player)data.getPlayer(), (String)this.expression2);
        try {
            switch (this.comparator) {
                case "<": {
                    return Double.parseDouble(unparsed1) < Double.parseDouble(unparsed2);
                }
                case "<=": {
                    return Double.parseDouble(unparsed1) <= Double.parseDouble(unparsed2);
                }
                case ">": {
                    return Double.parseDouble(unparsed1) > Double.parseDouble(unparsed2);
                }
                case ">=": {
                    return Double.parseDouble(unparsed1) >= Double.parseDouble(unparsed2);
                }
                case "==": 
                case "=": {
                    return Math.abs(Double.parseDouble(unparsed1) - Double.parseDouble(unparsed2)) <= EQUALITY_THRESHOLD;
                }
                case "!=": {
                    return Math.abs(Double.parseDouble(unparsed1) - Double.parseDouble(unparsed2)) > EQUALITY_THRESHOLD;
                }
                case "equals": {
                    return unparsed1.equals(unparsed2);
                }
            }
            throw new RuntimeException("Comparator not recognized");
        }
        catch (RuntimeException exception) {
            MMOItems.plugin.getLogger().log(Level.SEVERE, "Could not evaluate placeholder condition expression: " + exception.getMessage());
            return false;
        }
    }

    @Override
    public void whenCrafting(PlayerData data) {
    }
}

