/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.condition;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmoitems.api.crafting.condition.Condition;
import net.Indyuce.mmoitems.api.player.PlayerData;

public class LevelCondition
extends Condition {
    private final int level;
    private final boolean consume;

    public LevelCondition(MMOLineConfig config) {
        super("level");
        config.validate(new String[]{"level"});
        this.level = config.getInt("level");
        this.consume = config.getBoolean("consume", false);
    }

    @Override
    public boolean isMet(PlayerData data) {
        return data.getRPG().getLevel() >= this.level;
    }

    @Override
    public String formatDisplay(String string) {
        return string.replace("#level#", "" + this.level);
    }

    @Override
    public void whenCrafting(PlayerData data) {
        if (this.consume) {
            data.getPlayer().setLevel(Math.max(0, data.getPlayer().getLevel() - this.level));
        }
    }
}

