/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting.condition;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmoitems.api.crafting.condition.Condition;
import net.Indyuce.mmoitems.api.player.PlayerData;

public class FoodCondition
extends Condition {
    private final int amount;

    public FoodCondition(MMOLineConfig config) {
        super("food");
        config.validate(new String[]{"amount"});
        this.amount = config.getInt("amount");
    }

    @Override
    public boolean isMet(PlayerData data) {
        if (!data.isOnline()) {
            return false;
        }
        return data.getPlayer().getFoodLevel() >= this.amount;
    }

    @Override
    public String formatDisplay(String string) {
        return string.replace("#food#", "" + this.amount);
    }

    @Override
    public void whenCrafting(PlayerData data) {
        if (!data.isOnline()) {
            return;
        }
        data.getPlayer().setFoodLevel(Math.max(0, data.getPlayer().getFoodLevel() - this.amount));
    }
}

