/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.crafting;

import io.lumine.mythic.lib.api.crafting.uifilters.UIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.UIFilterManager;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.QuickNumberRange;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.crafting.VanillaMMOItemCountermatch;
import net.Indyuce.mmoitems.api.item.build.MMOItemBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.mmoitem.VolatileMMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.stat.data.UpgradeData;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMOItemUIFilter
implements UIFilter {
    ArrayList<String> validDataments;
    private static boolean reg = true;
    static MMOItemUIFilter global;

    @NotNull
    public String getIdentifier() {
        return "m";
    }

    public boolean matches(@NotNull ItemStack item, @NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        if (!this.isValid(argument = argument.replace(" ", "_").replace("-", "_").toUpperCase(), data = data.replace(" ", "_").replace("-", "_").toUpperCase(), ffp)) {
            return false;
        }
        if (this.cancelMatch(item, ffp)) {
            return false;
        }
        NBTItem asNBT = NBTItem.get((ItemStack)item);
        MMOItemTemplate mmo = MMOItems.plugin.getTemplates().getTemplate(asNBT);
        if (mmo == null) {
            FriendlyFeedbackProvider.log((FriendlyFeedbackProvider)ffp, (FriendlyFeedbackCategory)FriendlyFeedbackCategory.FAILURE, (String)"Item $r{0}$b is $fnot a MMOItem$b. ", (String[])new String[]{SilentNumbers.getItemName((ItemStack)item)});
            return false;
        }
        String dataments = "";
        if (data.contains("{")) {
            dataments = data.substring(data.indexOf(123) + 1);
            data = data.substring(0, data.indexOf(123));
            if (dataments.endsWith("}")) {
                dataments = dataments.substring(0, dataments.length() - 1);
            }
        }
        if (!mmo.getType().getId().equals(argument) || !mmo.getId().equals(data)) {
            FriendlyFeedbackProvider.log((FriendlyFeedbackProvider)ffp, (FriendlyFeedbackCategory)FriendlyFeedbackCategory.FAILURE, (String)"MMOItem $r{0} {1}$b is not the expected $r{2} {3}$b. $fNo Match. ", (String[])new String[]{mmo.getType().getId(), mmo.getId(), argument, data});
            return false;
        }
        if (!dataments.isEmpty()) {
            int identifiedLvl;
            VolatileMMOItem vmmo = new VolatileMMOItem(asNBT);
            QuickNumberRange upgradeReq = SilentNumbers.rangeFromBracketsTab((String)dataments, (String)"LEVEL");
            if (upgradeReq != null && !upgradeReq.inRange((double)(identifiedLvl = vmmo.getUpgradeLevel()))) {
                FriendlyFeedbackProvider.log((FriendlyFeedbackProvider)ffp, (FriendlyFeedbackCategory)FriendlyFeedbackCategory.FAILURE, (String)"MMOItem $r{0} {1}$b is of level $u{2}$b though $r{3}$b was expected. $fNo Match. ", (String[])new String[]{mmo.getType().getId(), mmo.getId(), String.valueOf(identifiedLvl), upgradeReq.toString()});
                return false;
            }
        }
        FriendlyFeedbackProvider.log((FriendlyFeedbackProvider)ffp, (FriendlyFeedbackCategory)FriendlyFeedbackCategory.SUCCESS, (String)"Detected $r{0} {1} $sSuccessfully. ", (String[])new String[]{mmo.getType().getId(), mmo.getId()});
        return true;
    }

    public boolean isValid(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        if (reg) {
            return true;
        }
        argument = argument.replace(" ", "_").replace("-", "_").toUpperCase();
        data = data.replace(" ", "_").replace("-", "_").toUpperCase();
        Type t = MMOItems.plugin.getTypes().get(argument);
        if (t == null) {
            FriendlyFeedbackProvider.log((FriendlyFeedbackProvider)ffp, (FriendlyFeedbackCategory)FriendlyFeedbackCategory.ERROR, (String)"$fInvalid MMOItem Type $r{0}$f. ", (String[])new String[]{argument});
            return false;
        }
        if (data.contains("{") && data.contains("}")) {
            data = data.substring(0, data.indexOf(123));
        }
        if (MMOItems.plugin.getMMOItem(t, data) == null) {
            FriendlyFeedbackProvider.log((FriendlyFeedbackProvider)ffp, (FriendlyFeedbackCategory)FriendlyFeedbackCategory.ERROR, (String)"$fInvalid MMOItem $r{0} {1}$f: $bNo such MMOItem for Type $e{0}$b. ", (String[])new String[]{argument, data});
            return false;
        }
        FriendlyFeedbackProvider.log((FriendlyFeedbackProvider)ffp, (FriendlyFeedbackCategory)FriendlyFeedbackCategory.SUCCESS, (String)"Valid MMOItem $r{0} {1}$b. $snice. ", (String[])new String[]{argument, data});
        return true;
    }

    @NotNull
    public ArrayList<String> tabCompleteArgument(@NotNull String argument) {
        return SilentNumbers.smartFilter(MMOItems.plugin.getTypes().getAllTypeNames(), (String)argument, (boolean)true);
    }

    @NotNull
    public ArrayList<String> tabCompleteData(@NotNull String argument, @NotNull String data) {
        Type t = MMOItems.plugin.getTypes().get(argument);
        if (t != null) {
            ArrayList suggestions;
            String dataments = "";
            String datamentsTab = "";
            if (data.contains("{")) {
                dataments = data.substring(data.indexOf(123) + 1);
                data = data.substring(0, data.indexOf(123));
                int datashort = 0;
                if (dataments.contains(",")) {
                    datashort = dataments.lastIndexOf(44) + 1;
                }
                datamentsTab = dataments.substring(datashort);
                dataments = dataments.substring(0, datashort);
            }
            ArrayList trueSuggestions = suggestions = SilentNumbers.smartFilter(MMOItems.plugin.getTemplates().getTemplateNames(t), (String)data, (boolean)true);
            if (!datamentsTab.isEmpty()) {
                ArrayList datamentsSug = new ArrayList();
                if (datamentsTab.contains("=")) {
                    String datamentsUsed = datamentsTab.substring(0, datamentsTab.indexOf(61));
                    switch (datamentsUsed.toLowerCase()) {
                        case "level": {
                            SilentNumbers.addAll((ArrayList)datamentsSug, (Object[])new String[]{"level=1..", "level=2..4", "level=..6"});
                            break;
                        }
                        default: {
                            datamentsSug.add(datamentsTab);
                            break;
                        }
                    }
                } else {
                    datamentsSug = SilentNumbers.smartFilter(this.getValidDataments(), (String)datamentsTab, (boolean)true);
                }
                for (String sug : suggestions) {
                    for (String comp : datamentsSug) {
                        trueSuggestions.add(sug + "{" + dataments + comp);
                    }
                }
            }
            return trueSuggestions;
        }
        return SilentNumbers.toArrayList((Object[])new String[]{"Type_not_found,_check_your_spelling"});
    }

    @NotNull
    public ArrayList<String> getValidDataments() {
        if (this.validDataments != null) {
            return this.validDataments;
        }
        this.validDataments = SilentNumbers.toArrayList((Object[])new String[]{"level"});
        return this.validDataments;
    }

    public boolean fullyDefinesItem() {
        return true;
    }

    @Nullable
    public ItemStack getItemStack(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        if (!this.isValid(argument, data, ffp)) {
            return null;
        }
        argument = argument.replace(" ", "_").replace("-", "_").toUpperCase();
        data = data.replace(" ", "_").replace("-", "_").toUpperCase();
        return MMOItems.plugin.getItem(argument, data);
    }

    @NotNull
    public ItemStack getDisplayStack(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        QuickNumberRange upgradeReq;
        if (!this.isValid(argument, data, ffp)) {
            return ItemFactory.of((Material)Material.STRUCTURE_VOID).name("\u00a7cInvalid MMOItem \u00a7e" + argument + " " + data).build();
        }
        argument = argument.replace(" ", "_").replace("-", "_").toUpperCase();
        String dataments = "";
        if (data.contains("{")) {
            dataments = data.substring(data.indexOf(123) + 1);
            data = data.substring(0, data.indexOf(123));
            if (dataments.endsWith("}")) {
                dataments = dataments.substring(0, dataments.length() - 1);
            }
        }
        data = data.replace(" ", "_").replace("-", "_").toUpperCase();
        MMOItem m = new MMOItemBuilder(MMOItems.plugin.getTemplates().getTemplate(MMOItems.plugin.getTypes().get(argument), data), 0, null, true).build();
        if (!dataments.isEmpty() && m.hasUpgradeTemplate() && (upgradeReq = SilentNumbers.rangeFromBracketsTab((String)dataments, (String)"level")) != null) {
            UpgradeData ud = ((UpgradeData)m.getData(ItemStats.UPGRADE)).clone();
            ud.setLevel(SilentNumbers.floor((double)upgradeReq.getAsDouble(0.0)));
            m.setData(ItemStats.UPGRADE, ud);
        }
        return m.newBuilder().buildNBT(true).toItem();
    }

    @NotNull
    public ArrayList<String> getDescription(@NotNull String argument, @NotNull String data) {
        if (!this.isValid(argument, data, null)) {
            return SilentNumbers.toArrayList((Object[])new String[]{"This MMOItem is $finvalid$b."});
        }
        argument = argument.replace(" ", "_").replace("-", "_").toUpperCase();
        data = data.replace(" ", "_").replace("-", "_").toUpperCase();
        return SilentNumbers.toArrayList((Object[])new String[]{SilentNumbers.getItemName((ItemStack)MMOItems.plugin.getItem(argument, data))});
    }

    public boolean determinateGeneration() {
        return false;
    }

    public boolean partialDeterminateGeneration(@NotNull String argument, @NotNull String data) {
        return !this.isValid(argument, data, null);
    }

    @NotNull
    public String getSourcePlugin() {
        return "MMOItems";
    }

    @NotNull
    public String getFilterName() {
        return "MMOItem";
    }

    @NotNull
    public String exampleArgument() {
        return "CONSUMABLE";
    }

    @NotNull
    public String exampleData() {
        return "MANGO";
    }

    public static void register() {
        global = new MMOItemUIFilter();
        UIFilterManager.registerUIFilter((UIFilter)global);
        VanillaMMOItemCountermatch.enable();
        reg = false;
    }

    @NotNull
    public static MMOItemUIFilter get() {
        return global;
    }
}

