/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api.block;

import io.lumine.mythic.lib.version.VersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class WorldGenTemplate {
    private final String id;
    private final double chunkChance;
    private final int minDepth;
    private final int maxDepth;
    private final int veinSize;
    private final int veinCount;
    private final List<Material> replaceable = new ArrayList<Material>();
    private final List<Material> bordering = new ArrayList<Material>();
    private final List<Material> notBordering = new ArrayList<Material>();
    private final List<String> worldWhitelist = new ArrayList<String>();
    private final List<String> worldBlacklist = new ArrayList<String>();
    private final List<String> biomeWhitelist = new ArrayList<String>();
    private final List<String> biomeBlacklist = new ArrayList<String>();
    private final boolean slimeChunk;

    public WorldGenTemplate(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Could not read gen template config");
        this.id = config.getName().toLowerCase().replace(" ", "-").replace("_", "-");
        config.getStringList("replace").forEach(str -> this.replaceable.add(Material.valueOf((String)str.toUpperCase().replace("-", "_").replace(" ", "_"))));
        config.getStringList("bordering").forEach(str -> this.bordering.add(Material.valueOf((String)str.toUpperCase().replace("-", "_").replace(" ", "_"))));
        config.getStringList("not-bordering").forEach(str -> this.notBordering.add(Material.valueOf((String)str.toUpperCase().replace("-", "_").replace(" ", "_"))));
        for (String world : config.getStringList("worlds")) {
            (world.startsWith("!") ? this.worldBlacklist : this.worldWhitelist).add(world.toLowerCase().replace("_", "-"));
        }
        for (String biome : config.getStringList("biomes")) {
            (biome.startsWith("!") ? this.biomeBlacklist : this.biomeWhitelist).add(biome.toUpperCase().replace("-", "_").replace(" ", "_"));
        }
        this.chunkChance = config.getDouble("chunk-chance");
        this.slimeChunk = config.getBoolean("slime-chunk", false);
        String[] depth = config.getString("depth").split("=");
        this.minDepth = Integer.parseInt(depth[0]);
        this.maxDepth = Integer.parseInt(depth[1]);
        this.veinSize = config.getInt("vein-size");
        this.veinCount = config.getInt("vein-count");
        Validate.isTrue((this.veinSize > 0 && this.veinCount > 0 ? 1 : 0) != 0, (String)"Vein size and count must be at least 1");
    }

    public String getId() {
        return this.id;
    }

    public double getChunkChance() {
        return this.chunkChance;
    }

    public int getVeinSize() {
        return this.veinSize;
    }

    public int getVeinCount() {
        return this.veinCount;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public boolean canGenerateInWorld(String worldName) {
        String world = worldName.toLowerCase().replace("_", "-");
        if (!this.worldWhitelist.isEmpty() && !this.worldWhitelist.contains(world)) {
            return false;
        }
        return this.worldBlacklist.isEmpty() || !this.worldBlacklist.contains(world);
    }

    public boolean canGenerate(Location pos) {
        Biome biome = pos.getWorld().getBiome(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
        if (!this.biomeWhitelist.isEmpty() && !this.biomeWhitelist.contains(VersionUtils.name((Biome)biome)) || !this.biomeBlacklist.isEmpty() && this.biomeBlacklist.contains(VersionUtils.name((Biome)biome))) {
            return false;
        }
        if (this.slimeChunk && !pos.getChunk().isSlimeChunk()) {
            return false;
        }
        if (!this.bordering.isEmpty() && !this.checkIfBorderingBlocks(pos)) {
            return false;
        }
        if (!this.notBordering.isEmpty()) {
            return this.checkIfNotBorderingBlocks(pos);
        }
        return true;
    }

    public boolean canReplace(Material type) {
        return this.replaceable.isEmpty() || this.replaceable.contains(type);
    }

    public boolean canBorder(Material type) {
        return this.bordering.isEmpty() || this.bordering.contains(type);
    }

    public boolean checkIfBorderingBlocks(Location pos) {
        return Arrays.stream(BlockFace.values()).map(arg_0 -> ((Block)pos.getBlock()).getRelative(arg_0)).map(Block::getType).allMatch(this::canBorder);
    }

    public boolean canNotBorder(Material type) {
        return !this.notBordering.isEmpty() && this.notBordering.contains(type);
    }

    public boolean checkIfNotBorderingBlocks(Location pos) {
        return Arrays.stream(BlockFace.values()).map(arg_0 -> ((Block)pos.getBlock()).getRelative(arg_0)).map(Block::getType).allMatch(this::canNotBorder);
    }
}

