/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api;

import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.stat.Enchants;
import net.Indyuce.mmoitems.stat.data.UpgradeData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.UpgradeInfo;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import net.Indyuce.mmoitems.stat.type.Upgradable;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeTemplate {
    @NotNull
    private final String id;
    @NotNull
    private final Map<ItemStat, UpgradeInfo> perStatUpgradeInfos = new HashMap<ItemStat, UpgradeInfo>();

    public UpgradeTemplate(@NotNull ConfigurationSection config) {
        Validate.notNull((Object)config, (String)FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"You must specify a config section.", (String[])new String[0]));
        this.id = config.getName().toLowerCase().replace("_", "-").replace(" ", "-");
        FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
        ffp.activatePrefix(true, "Upgrade Template $i&o" + config.getName());
        for (String key : config.getKeys(false)) {
            String statFormat = key.toUpperCase().replace("-", "_");
            ItemStat<?, ?> stat = MMOItems.plugin.getStats().get(statFormat);
            if (stat == null) {
                ffp.log(FriendlyFeedbackCategory.ERROR, "Stat '$r{0}$b' $fnot found$b.", new String[]{statFormat});
                continue;
            }
            if (!(stat instanceof Upgradable)) {
                ffp.log(FriendlyFeedbackCategory.ERROR, "Stat $r{0}$b is $fnot upgradeable$b.", new String[]{stat.getId()});
                continue;
            }
            if (!(stat.getClearStatData() instanceof Mergeable)) {
                ffp.log(FriendlyFeedbackCategory.ERROR, "Stat Data used by $r{0}$b is $fnot mergeable$b, and thus it cannot be upgradeable. Contact the dev of this ItemStat.", new String[]{stat.getId()});
                continue;
            }
            try {
                this.perStatUpgradeInfos.put(stat, ((Upgradable)((Object)stat)).loadUpgradeInfo(config.get(key)));
            }
            catch (IllegalArgumentException exception) {
                ffp.log(FriendlyFeedbackCategory.ERROR, exception.getMessage(), new String[0]);
            }
        }
        ffp.sendTo(FriendlyFeedbackCategory.ERROR, MMOItems.getConsole());
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Set<ItemStat> getKeys() {
        return this.perStatUpgradeInfos.keySet();
    }

    @Nullable
    public UpgradeInfo getUpgradeInfo(@NotNull ItemStat stat) {
        return this.perStatUpgradeInfos.get(stat);
    }

    public void upgrade(@NotNull MMOItem mmoitem) {
        this.upgradeTo(mmoitem, mmoitem.getUpgradeLevel() + 1);
    }

    public void upgradeTo(@NotNull MMOItem mmoitem, int level) {
        Enchants.separateEnchantments(mmoitem);
        UpgradeData dat = mmoitem.hasData(ItemStats.UPGRADE) ? (UpgradeData)mmoitem.getData(ItemStats.UPGRADE) : new UpgradeData(null, null, false, false, 0, 0, 100.0);
        dat.setLevel(level);
        mmoitem.setData(ItemStats.UPGRADE, dat);
        for (ItemStat stat : this.perStatUpgradeInfos.keySet()) {
            ((Upgradable)((Object)stat)).preprocess(mmoitem);
            StatHistory hist = mmoitem.computeStatHistory(stat);
            ((Upgradable)((Object)stat)).midprocess(mmoitem);
            mmoitem.setData(stat, hist.recalculate(level));
            ((Upgradable)((Object)stat)).postprocess(mmoitem);
        }
    }

    public static boolean isDisplayingUpgrades() {
        return MMOItems.plugin.getConfig().getBoolean("item-upgrading.display-stat-changes", false);
    }

    @NotNull
    public static String getUpgradeChangeSuffix(@NotNull String value, boolean isNegative) {
        String base = Objects.requireNonNull(MMOItems.plugin.getConfig().getString("item-upgrading.stat-change-suffix", " &8(<p>#stat#&8)"));
        String succ = Objects.requireNonNull(MMOItems.plugin.getConfig().getString("item-upgrading.stat-change-positive", "&a"));
        String fauc = Objects.requireNonNull(MMOItems.plugin.getConfig().getString("item-upgrading.stat-change-negative", "&c"));
        if (isNegative) {
            return base.replace("<p>", fauc).replace("#stat#", value);
        }
        return base.replace("<p>", succ).replace("#stat#", value);
    }
}

