/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.NBTItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.droptable.DropTable;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.tooltip.TooltipTexture;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemTier {
    private final String id;
    private final String name;
    private final String unparsedName;
    private final UnidentificationInfo unidentificationInfo;
    @Nullable
    private final TooltipTexture tooltip;
    @Nullable
    private final DropTable deconstructTable;
    @Nullable
    private final ChatColor glowColor;
    private final boolean itemHint;
    @Nullable
    private final NumericStatFormula capacity;
    private final double chance;
    @NotNull
    private static final Random RANDOM = new Random();

    public ItemTier(@NotNull ConfigurationSection config) {
        this.id = config.getName().toUpperCase().replace("-", "_");
        this.unparsedName = config.getString("name");
        this.name = MythicLib.plugin.parseColors(this.unparsedName);
        this.deconstructTable = config.contains("deconstruct-item") ? new DropTable(config.getConfigurationSection("deconstruct-item")) : null;
        ConfigurationSection unidentificationSection = config.getConfigurationSection("unidentification");
        UnidentificationInfo unidentificationInfo = this.unidentificationInfo = unidentificationSection == null ? UnidentificationInfo.DEFAULT : new UnidentificationInfo(unidentificationSection);
        if (config.contains("item-glow")) {
            this.itemHint = config.getBoolean("item-glow.hint");
            this.glowColor = ChatColor.valueOf((String)UtilityMethods.enumName((String)config.getString("item-glow.color", "WHITE")));
        } else {
            this.itemHint = false;
            this.glowColor = null;
        }
        this.tooltip = config.isConfigurationSection("tooltip") ? new TooltipTexture(config.getConfigurationSection("tooltip")) : null;
        this.chance = config.getDouble("generation.chance");
        this.capacity = config.contains("generation.capacity") ? new NumericStatFormula(config.get("generation.capacity")) : null;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean hasDropTable() {
        return this.deconstructTable != null;
    }

    @Nullable
    public DropTable getDropTable() {
        return this.deconstructTable;
    }

    @Nullable
    public TooltipTexture getTooltip() {
        return this.tooltip;
    }

    public List<ItemStack> getDeconstructedLoot(@NotNull PlayerData player) {
        return this.hasDropTable() ? this.deconstructTable.read(player, false) : new ArrayList<ItemStack>();
    }

    public boolean hasColor() {
        return this.glowColor != null;
    }

    @Nullable
    public ChatColor getColor() {
        return this.glowColor;
    }

    public boolean isHintEnabled() {
        return this.itemHint;
    }

    public double getGenerationChance() {
        return this.chance;
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    @Nullable
    public NumericStatFormula getModifierCapacity() {
        return this.capacity;
    }

    @NotNull
    public UnidentificationInfo getUnidentificationInfo() {
        return this.unidentificationInfo;
    }

    @NotNull
    public String getUnparsedName() {
        return this.unparsedName;
    }

    @Nullable
    public static ItemTier ofItem(NBTItem item) {
        String format = item.getString("MMOITEMS_TIER");
        return format == null ? null : MMOItems.plugin.getTiers().get(format);
    }

    public static class UnidentificationInfo {
        @NotNull
        private final String name;
        @NotNull
        private final String prefix;
        private final int range;
        public static final String DEFAULT_NAME = "Unidentified Item";
        public static final String DEFAULT_PREFIX = "Unknown";
        public static final UnidentificationInfo DEFAULT = new UnidentificationInfo("Unidentified Item", "Unknown", 0);

        public UnidentificationInfo(@NotNull ConfigurationSection config) {
            this(config.getString("name", DEFAULT_NAME), config.getString("prefix", DEFAULT_PREFIX), config.getInt("range"));
        }

        public UnidentificationInfo(@NotNull String name, @NotNull String prefix, int range) {
            this.name = name;
            this.prefix = prefix;
            this.range = range;
        }

        @NotNull
        public String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public String getDisplayName() {
            return this.name;
        }

        public int[] calculateRange(int level) {
            int min = (int)Math.max(1.0, (double)level - (double)this.range * RANDOM.nextDouble());
            return new int[]{min, min + this.range};
        }
    }
}

