/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.Indyuce.mmoitems.MMOItems;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DeathItemsHandler {
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private final Location lastLocation;
    private final UUID playerId;
    private static final Map<UUID, DeathItemsHandler> PLAYER_INFO = new WeakHashMap<UUID, DeathItemsHandler>();

    public DeathItemsHandler(@NotNull Player player) {
        this.playerId = player.getUniqueId();
        this.lastLocation = player.getLocation();
    }

    public void registerItem(@NotNull ItemStack item) {
        this.items.add(item);
    }

    public void registerIfNecessary() {
        if (!this.items.isEmpty()) {
            PLAYER_INFO.put(this.playerId, this);
        }
    }

    public void dropItems() {
        for (ItemStack drop : this.items) {
            this.lastLocation.getWorld().dropItem(this.lastLocation, drop);
        }
    }

    public void giveItems(@NotNull Player player) {
        ItemStack[] toArray = this.items.toArray(new ItemStack[0]);
        for (ItemStack drop : player.getInventory().addItem(toArray).values()) {
            player.getWorld().dropItem(player.getLocation(), drop);
        }
    }

    public static void readAndRemove(@NotNull Player player) {
        DeathItemsHandler handler = PLAYER_INFO.remove(player.getUniqueId());
        if (handler != null) {
            Bukkit.getScheduler().runTaskLater((Plugin)MMOItems.plugin, () -> handler.giveItems(player), 10L);
        }
    }

    @NotNull
    public static Collection<DeathItemsHandler> getActive() {
        return PLAYER_INFO.values();
    }
}

