/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackMessage;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.util.MMOPlugin;
import io.lumine.mythic.lib.version.SpigotPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.Indyuce.mmoitems.api.DeathItemsHandler;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.crafting.MMOItemUIFilter;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.MMOItemReforger;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.command.MMOItemsCommandTreeRoot;
import net.Indyuce.mmoitems.comp.MMOItemsMetrics;
import net.Indyuce.mmoitems.comp.MMOItemsRewardTypes;
import net.Indyuce.mmoitems.comp.McMMONonRPGHook;
import net.Indyuce.mmoitems.comp.WorldEditSupport;
import net.Indyuce.mmoitems.comp.eco.VaultSupport;
import net.Indyuce.mmoitems.comp.enchants.CrazyEnchantsStat;
import net.Indyuce.mmoitems.comp.enchants.EnchantPlugin;
import net.Indyuce.mmoitems.comp.enchants.MythicEnchantsSupport;
import net.Indyuce.mmoitems.comp.enchants.advanced_enchants.AdvancedEnchantmentsHook;
import net.Indyuce.mmoitems.comp.inventory.DefaultPlayerInventory;
import net.Indyuce.mmoitems.comp.inventory.OrnamentPlayerInventory;
import net.Indyuce.mmoitems.comp.inventory.PlayerInventory;
import net.Indyuce.mmoitems.comp.inventory.PlayerInventoryHandler;
import net.Indyuce.mmoitems.comp.inventory.RPGInventoryHook;
import net.Indyuce.mmoitems.comp.mmocore.MMOCoreMMOLoader;
import net.Indyuce.mmoitems.comp.mmoinventory.MMOInventorySupport;
import net.Indyuce.mmoitems.comp.mythicmobs.LootsplosionListener;
import net.Indyuce.mmoitems.comp.mythicmobs.MythicMobsCompatibility;
import net.Indyuce.mmoitems.comp.placeholders.MMOItemsPlaceholders;
import net.Indyuce.mmoitems.comp.rpg.DefaultHook;
import net.Indyuce.mmoitems.comp.rpg.HeroesHook;
import net.Indyuce.mmoitems.comp.rpg.McMMOHook;
import net.Indyuce.mmoitems.comp.rpg.RPGHandler;
import net.Indyuce.mmoitems.gui.PluginInventory;
import net.Indyuce.mmoitems.gui.edition.recipe.RecipeTypeListGUI;
import net.Indyuce.mmoitems.manager.BlockManager;
import net.Indyuce.mmoitems.manager.ConfigManager;
import net.Indyuce.mmoitems.manager.CraftingManager;
import net.Indyuce.mmoitems.manager.DropTableManager;
import net.Indyuce.mmoitems.manager.ItemManager;
import net.Indyuce.mmoitems.manager.LayoutManager;
import net.Indyuce.mmoitems.manager.LoreFormatManager;
import net.Indyuce.mmoitems.manager.PluginUpdateManager;
import net.Indyuce.mmoitems.manager.RecipeManager;
import net.Indyuce.mmoitems.manager.SetManager;
import net.Indyuce.mmoitems.manager.SkillManager;
import net.Indyuce.mmoitems.manager.StatManager;
import net.Indyuce.mmoitems.manager.TemplateManager;
import net.Indyuce.mmoitems.manager.TierManager;
import net.Indyuce.mmoitems.manager.TypeManager;
import net.Indyuce.mmoitems.manager.UpgradeManager;
import net.Indyuce.mmoitems.manager.WorldGenManager;
import net.Indyuce.mmoitems.manager.data.PlayerDataManager;
import net.Indyuce.mmoitems.util.PluginUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class MMOItems
extends MMOPlugin {
    public static MMOItems plugin;
    private final PluginUpdateManager pluginUpdateManager = new PluginUpdateManager();
    private final CraftingManager stationRecipeManager = new CraftingManager();
    private final LoreFormatManager loreManager = new LoreFormatManager();
    private final TemplateManager templateManager = new TemplateManager();
    private final SkillManager skillManager = new SkillManager();
    private final RecipeManager recipeManager = new RecipeManager();
    private final LayoutManager layoutManager = new LayoutManager();
    private final TypeManager typeManager = new TypeManager();
    private final ItemManager itemManager = new ItemManager();
    private final PlayerInventoryHandler inventory = new PlayerInventoryHandler();
    private final List<EnchantPlugin<?>> enchantPlugins = new ArrayList();
    private final StatManager statManager = new StatManager();
    private PlayerDataManager playerDataManager;
    private DropTableManager dropTableManager;
    private WorldGenManager worldGenManager;
    private UpgradeManager upgradeManager;
    private ConfigManager configManager;
    private BlockManager blockManager;
    private TierManager tierManager;
    private SetManager setManager;
    private VaultSupport vaultSupport;
    private final List<RPGHandler> rpgPlugins = new ArrayList<RPGHandler>();
    private boolean hasLoadedSuccessfully;

    public MMOItems() {
        plugin = this;
    }

    public void onLoad() {
        this.getLogger().log(Level.INFO, "Plugin file is called '" + this.getFile().getName() + "'");
        PluginUtils.isDependencyPresent("WorldEdit", u -> {
            try {
                new WorldEditSupport();
                this.getLogger().log(Level.INFO, "Hooked onto WorldEdit");
            }
            catch (Exception exception) {
                this.getLogger().log(Level.SEVERE, "Could not initialize support with WorldEdit 7: ", exception);
            }
        });
        this.saveDefaultConfig();
        this.configManager = new ConfigManager();
        this.statManager.loadBuiltins();
        this.typeManager.reload(false);
        this.templateManager.preloadObjects();
        PluginUtils.isDependencyPresent("MMOCore", u -> new MMOCoreMMOLoader());
        PluginUtils.isDependencyPresent("mcMMO", u -> this.statManager.register(McMMOHook.disableMcMMORepair));
        PluginUtils.hookDependencyIfPresent("AdvancedEnchantments", true, u -> {
            this.statManager.register(AdvancedEnchantmentsHook.ADVANCED_ENCHANTMENTS);
            this.statManager.register(AdvancedEnchantmentsHook.DISABLE_ADVANCED_ENCHANTMENTS);
        });
        PluginUtils.hookDependencyIfPresent("MythicEnchants", true, plugin -> this.enchantPlugins.add(new MythicEnchantsSupport((Plugin)plugin)));
        PluginUtils.isDependencyPresent("Heroes", u -> {
            this.statManager.register(HeroesHook.MAX_STAMINA);
            this.statManager.register(HeroesHook.REQUIRED_SECONDARY_HERO_LEVEL);
        });
    }

    public void onEnable() {
        new SpigotPlugin(39267, (JavaPlugin)this).checkForUpdate();
        new MMOItemsMetrics();
        MMOItemUIFilter.register();
        RecipeTypeListGUI.registerNativeRecipes();
        this.typeManager.postload();
        this.skillManager.initialize(false);
        int configVersion = this.getConfig().contains("config-version", true) ? this.getConfig().getInt("config-version") : -1;
        int defConfigVersion = this.getConfig().getDefaults().getInt("config-version");
        if (configVersion != defConfigVersion) {
            this.getLogger().warning("You may be using an outdated config.yml!");
            this.getLogger().warning("(Your config version: '" + configVersion + "' | Expected config version: '" + defConfigVersion + "')");
        }
        PluginUtils.hookDependencyIfPresent("MythicMobs", true, unused -> {
            new MythicMobsCompatibility();
            if (this.getConfig().getBoolean("lootsplosion.enabled")) {
                Bukkit.getPluginManager().registerEvents((Listener)new LootsplosionListener(), (Plugin)this);
            }
        });
        PluginUtils.hookDependencyIfPresent("MMOInventory", true, unused -> new MMOInventorySupport());
        this.findRpgPlugins();
        this.statManager.loadElements();
        this.loreManager.reload();
        this.tierManager = new TierManager();
        this.setManager = new SetManager();
        this.upgradeManager = new UpgradeManager();
        this.templateManager.postloadObjects();
        this.dropTableManager = new DropTableManager();
        this.worldGenManager = new WorldGenManager();
        this.blockManager = new BlockManager();
        this.statManager.reload(false);
        PluginUtils.hookDependencyIfPresent("Vault", true, u -> {
            this.vaultSupport = new VaultSupport();
        });
        this.getLogger().log(Level.INFO, "Loading crafting stations, please wait..");
        this.layoutManager.reload();
        this.stationRecipeManager.reload();
        MMOItemReforger.reload();
        Bukkit.getPluginManager().registerEvents((Listener)this.dropTableManager, (Plugin)this);
        try {
            Class.forName("net.Indyuce.mmoitems.MMOItemsBukkit").getConstructor(MMOItems.class).newInstance(new Object[]{this});
        }
        catch (Throwable exception) {
            throw new RuntimeException("Cannot run an API build on Spigot!");
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                PlayerData.get((OfflinePlayer)player).getInventory().updateCheck();
            }
        }, 100L, (long)this.getConfig().getInt("inventory-update-delay"));
        PluginUtils.isDependencyPresent("mcMMO", unused -> Bukkit.getPluginManager().registerEvents((Listener)new McMMONonRPGHook(), (Plugin)this));
        this.getInventory().register(new DefaultPlayerInventory());
        PluginUtils.hookDependencyIfPresent("RPGInventory", true, unused -> this.getInventory().register(new RPGInventoryHook()));
        if (MMOItems.plugin.getConfig().getBoolean("iterate-whole-inventory")) {
            this.getInventory().register(new OrnamentPlayerInventory());
        }
        PluginUtils.hookDependencyIfPresent("CrazyEnchantments", true, unused -> this.getStats().register(new CrazyEnchantsStat()));
        PluginUtils.hookDependencyIfPresent("AdvancedEnchantments", true, plugin -> Bukkit.getPluginManager().registerEvents((Listener)new AdvancedEnchantmentsHook(), (Plugin)this));
        PluginUtils.hookDependencyIfPresent("PlaceholderAPI", true, unused -> new MMOItemsPlaceholders().register());
        PluginUtils.hookDependencyIfPresent("BossShopPro", true, plugin -> new BukkitRunnable(){

            public void run() {
                try {
                    new MMOItemsRewardTypes().register();
                }
                catch (NullPointerException ignored) {
                    MMOItems.this.getLogger().log(Level.SEVERE, "Could not Hook onto BossShopPro");
                }
            }
        }.runTaskLater((Plugin)this, 1L));
        this.playerDataManager = new PlayerDataManager();
        this.playerDataManager.initialize(EventPriority.NORMAL, EventPriority.HIGHEST);
        this.getLogger().log(Level.INFO, "Loading recipes, please wait...");
        this.recipeManager.loadRecipes();
        MMOItemsCommandTreeRoot mmoitemsCommand = new MMOItemsCommandTreeRoot();
        this.getCommand("mmoitems").setExecutor((CommandExecutor)mmoitemsCommand);
        this.getCommand("mmoitems").setTabCompleter((TabCompleter)mmoitemsCommand);
        this.hasLoadedSuccessfully = true;
    }

    public void onDisable() {
        if (!this.hasLoadedSuccessfully) {
            return;
        }
        this.playerDataManager.close();
        DeathItemsHandler.getActive().forEach(DeathItemsHandler::dropItems);
        UtilityMethods.closeOpenViewsOfType(PluginInventory.class);
        this.worldGenManager.unload();
    }

    public String getPrefix() {
        return ChatColor.DARK_GRAY + "[" + ChatColor.YELLOW + "MMOItems" + ChatColor.DARK_GRAY + "] " + ChatColor.GRAY;
    }

    public File getJarFile() {
        return plugin.getFile();
    }

    public CraftingManager getCrafting() {
        return this.stationRecipeManager;
    }

    public LayoutManager getLayouts() {
        return this.layoutManager;
    }

    public SetManager getSets() {
        return this.setManager;
    }

    @Deprecated
    public RPGHandler getRPG() {
        return this.getMainRPG();
    }

    @Nullable
    public RPGHandler getMainRPG() {
        Validate.isTrue((!this.rpgPlugins.isEmpty() ? 1 : 0) != 0, (String)"No RPG plugin was found");
        return this.rpgPlugins.get(0);
    }

    public List<RPGHandler> getRPGs() {
        return this.rpgPlugins;
    }

    public void findRpgPlugins() {
        Validate.isTrue((boolean)this.rpgPlugins.isEmpty(), (String)"RPG hooks have already been computed");
        this.rpgPlugins.add(new DefaultHook());
        String preferredName = plugin.getConfig().getString("preferred-rpg-provider");
        for (RPGHandler.PluginEnum enumPlugin : RPGHandler.PluginEnum.values()) {
            if (Bukkit.getPluginManager().getPlugin(enumPlugin.getName()) == null) continue;
            try {
                RPGHandler handler = enumPlugin.load();
                this.rpgPlugins.add(handler);
                this.getLogger().log(Level.INFO, "Hooked onto " + enumPlugin.getName());
                if (!preferredName.equalsIgnoreCase(enumPlugin.name())) continue;
                Collections.swap(this.rpgPlugins, 0, this.rpgPlugins.size() - 1);
                this.getLogger().log(Level.INFO, "Now using " + enumPlugin.getName() + " as RPG core plugin");
            }
            catch (Exception exception) {
                plugin.getLogger().log(Level.SEVERE, "Could not initialize RPG plugin compatibility with " + enumPlugin.getName() + ":");
                exception.printStackTrace();
            }
        }
        RPGHandler preferred = this.rpgPlugins.get(0);
        if (this.rpgPlugins.get(0) instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)preferred, (Plugin)this);
        }
    }

    public void setRPG(@NotNull RPGHandler handler) {
        Validate.notNull((Object)handler, (String)"RPGHandler cannot be null");
        if (this.getMainRPG() instanceof Listener && this.isEnabled()) {
            HandlerList.unregisterAll((Plugin)((Plugin)this.getMainRPG()));
        }
        this.rpgPlugins.add(0, handler);
        this.getLogger().log(Level.INFO, "Now using " + handler.getClass().getSimpleName() + " as RPG provider");
        if (handler instanceof Listener && this.isEnabled()) {
            Bukkit.getPluginManager().registerEvents((Listener)handler, (Plugin)this);
        }
    }

    public PluginUpdateManager getUpdates() {
        return this.pluginUpdateManager;
    }

    public PlayerInventoryHandler getInventory() {
        return this.inventory;
    }

    public void registerPlayerInventory(PlayerInventory value) {
        this.getInventory().register(value);
    }

    @Deprecated
    public void setPlayerInventory(PlayerInventory value) {
        this.getInventory().unregisterAll();
        this.getInventory().register(value);
    }

    public void registerEnchantPlugin(EnchantPlugin enchantPlugin) {
        Validate.notNull((Object)enchantPlugin, (String)"Enchant plugin cannot be null");
        this.enchantPlugins.add(enchantPlugin);
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public StatManager getStats() {
        return this.statManager;
    }

    public TierManager getTiers() {
        return this.tierManager;
    }

    public DropTableManager getDropTables() {
        return this.dropTableManager;
    }

    public SkillManager getSkills() {
        return this.skillManager;
    }

    public BlockManager getCustomBlocks() {
        return this.blockManager;
    }

    public WorldGenManager getWorldGen() {
        return this.worldGenManager;
    }

    public RecipeManager getRecipes() {
        return this.recipeManager;
    }

    public ConfigManager getLanguage() {
        return this.configManager;
    }

    public TypeManager getTypes() {
        return this.typeManager;
    }

    public UpgradeManager getUpgrades() {
        return this.upgradeManager;
    }

    public TemplateManager getTemplates() {
        return this.templateManager;
    }

    public LoreFormatManager getLore() {
        return this.loreManager;
    }

    @Deprecated
    public LoreFormatManager getFormats() {
        return this.getLore();
    }

    @Deprecated
    public ItemManager getItems() {
        return this.itemManager;
    }

    public boolean hasPermissions() {
        return this.vaultSupport != null && this.vaultSupport.getPermissions() != null;
    }

    public List<EnchantPlugin<?>> getEnchantPlugins() {
        return this.enchantPlugins;
    }

    public boolean hasEconomy() {
        return this.vaultSupport != null && this.vaultSupport.getEconomy() != null;
    }

    public VaultSupport getVault() {
        return this.vaultSupport;
    }

    @Nullable
    public MMOItem getMMOItem(@Nullable Type type, @Nullable String id, @Nullable PlayerData player) {
        if (type == null || id == null) {
            return null;
        }
        MMOItemTemplate found = this.getTemplates().getTemplate(type, id);
        if (found == null) {
            return null;
        }
        return found.newBuilder(player).build();
    }

    @Nullable
    public ItemStack getItem(@Nullable Type type, @Nullable String id, @NotNull PlayerData player) {
        MMOItem m = this.getMMOItem(type, id, player);
        if (m == null) {
            return null;
        }
        return m.newBuilder().build();
    }

    @Nullable
    public MMOItem getMMOItem(@Nullable Type type, @Nullable String id, int itemLevel, @Nullable ItemTier itemTier) {
        if (type == null || id == null) {
            return null;
        }
        MMOItemTemplate found = this.getTemplates().getTemplate(type, id);
        if (found == null) {
            return null;
        }
        return found.newBuilder(itemLevel, itemTier).build();
    }

    @Nullable
    public ItemStack getItem(@Nullable Type type, @Nullable String id, int itemLevel, @Nullable ItemTier itemTier) {
        MMOItem m = this.getMMOItem(type, id, itemLevel, itemTier);
        if (m == null) {
            return null;
        }
        return m.newBuilder().build();
    }

    @Nullable
    public MMOItem getMMOItem(@Nullable Type type, @Nullable String id) {
        return this.getMMOItem(type, id, 0, null);
    }

    @Nullable
    public ItemStack getItem(@Nullable String type, @Nullable String id) {
        if (type == null || id == null) {
            return null;
        }
        return this.getItem(this.getTypes().get(type), id);
    }

    @Nullable
    public ItemStack getItem(@Nullable Type type, @Nullable String id) {
        if (type == null || id == null) {
            return null;
        }
        MMOItem m = this.getMMOItem(type, id);
        if (m == null) {
            return null;
        }
        return m.newBuilder().build();
    }

    @Nullable
    public static Type getType(@Nullable ItemStack stack) {
        return MMOItems.getType(NBTItem.get((ItemStack)stack));
    }

    @Nullable
    public static Type getType(@Nullable NBTItem nbt) {
        return plugin.getTypes().get(MMOItems.getTypeName(nbt));
    }

    @Nullable
    public static String getTypeName(@Nullable ItemStack stack) {
        return MMOItems.getTypeName(NBTItem.get((ItemStack)stack));
    }

    @Nullable
    public static String getTypeName(@Nullable NBTItem nbt) {
        if (nbt == null) {
            return null;
        }
        if (!nbt.hasType()) {
            return null;
        }
        return nbt.getType();
    }

    @Nullable
    public static String getID(@Nullable ItemStack nbt) {
        return MMOItems.getID(NBTItem.get((ItemStack)nbt));
    }

    @Nullable
    public static String getID(@Nullable NBTItem nbt) {
        if (nbt == null) {
            return null;
        }
        return nbt.getString("MMOITEMS_ITEM_ID");
    }

    public static void print(@Nullable Level level, @Nullable String message, @Nullable String prefix, String ... replaces) {
        if (message == null) {
            message = "< null >";
        }
        if (level != null) {
            plugin.getLogger().log(level, FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)message, (String[])replaces));
        } else {
            FriendlyFeedbackMessage p = new FriendlyFeedbackMessage("", prefix);
            FriendlyFeedbackMessage r = FriendlyFeedbackProvider.generateMessage((FriendlyFeedbackMessage)p, (String)message, (String[])replaces);
            MMOItems.getConsole().sendMessage(r.forConsole((FriendlyFeedbackPalette)FFPMMOItems.get()));
        }
    }

    public static void log(@Nullable String message, String ... replaces) {
        MMOItems.print(null, message, null, replaces);
    }

    @NotNull
    public static ConsoleCommandSender getConsole() {
        return plugin.getServer().getConsoleSender();
    }
}

