/*
 * Decompiled with CFR 0.152.
 */
package me.robin.battlelevels.api;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.robin.battlelevels.core.BattleLevels;
import me.robin.battlelevels.objects.BattlePlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class BattleLevelsAPI {
    private static BattleLevels a;

    public BattleLevelsAPI(BattleLevels plugin) {
        a = plugin;
    }

    public static boolean isGlobalBoosterEnabled() {
        return a.getBoosters().d() > 0;
    }

    public static int getGlobalBoosterInMinutes() {
        return a.getBoosters().d();
    }

    public static double getBoosterInMinutes(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getBooster();
        }
        return 0.0;
    }

    public static boolean hasBooster(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getBooster() > 0;
        }
        return false;
    }

    public static int getProgress(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getProgress();
        }
        return 0;
    }

    public static double getNeededFor(int level) {
        return a.getTools().round(a.getTools().getNeededFor(level), 1);
    }

    public static double getNeededForNext(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return a.getTools().round(BattleLevelsAPI.getNeededFor(bp.getLevel() + 1), 1);
        }
        return 0.0;
    }

    public static double getDifferenceBetweenCurrentLevelAndNext(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return a.getTools().round(BattleLevelsAPI.getNeededForNext(uuid) - BattleLevelsAPI.getNeededFor(bp.getLevel()), 1);
        }
        return 0.0;
    }

    public static double getNeededForNextRemaining(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return a.getTools().round(BattleLevelsAPI.getNeededForNext(uuid) - bp.getScore(), 1);
        }
        return 0.0;
    }

    public static String getProgressBar(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getBar();
        }
        return "";
    }

    public static double getKdr(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getKdr();
        }
        return 0.0;
    }

    public static String getBar(UUID uuid) {
        return BattleLevelsAPI.getProgressBar(uuid);
    }

    public static int getKills(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getKills();
        }
        return 0;
    }

    public static int getDeaths(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getDeaths();
        }
        return 0;
    }

    public static int getLevel(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getLevel();
        }
        return 0;
    }

    public static double getScore(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getScore();
        }
        return 0.0;
    }

    public static void addLevel(UUID uuid, int amount) {
        if (amount <= 0) {
            return;
        }
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            int get = bp.getLevel() + amount;
            if (get > a.getSettings().getMaxLevel()) {
                get = a.getSettings().getMaxLevel();
            }
            if (get == bp.getLevel()) {
                return;
            }
            bp.setLevel(get);
            bp.setScore(a.getTools().getNeededFor(get));
            bp.saveAsync();
        }
    }

    public static void removeLevel(UUID uuid, int amount) {
        if (amount <= 0) {
            return;
        }
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            int get = bp.getLevel() - amount;
            if (get < 0) {
                get = 0;
            }
            if (get == bp.getLevel()) {
                return;
            }
            bp.setLevel(get);
            bp.setScore(a.getTools().getNeededFor(get));
            bp.saveAsync();
        }
    }

    public static void addScore(UUID uuid, double amount, boolean checkforlevelup) {
        if (amount <= 0.0) {
            return;
        }
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            bp.setScore(bp.getScore() + amount);
            if (checkforlevelup && bp.getPlayer() != null) {
                int levelup = bp.getLevel();
                if (bp.getLevel() != a.getSettings().getMaxLevel()) {
                    int i = 1;
                    while (i <= a.getSettings().ar()) {
                        if (bp.getScore() >= a.getTools().getNeededFor(bp.getLevel() + i) && bp.getLevel() + i <= a.getSettings().getMaxLevel()) {
                            levelup = bp.getLevel() + i;
                        }
                        ++i;
                    }
                }
                if (levelup > bp.getLevel()) {
                    int p = bp.getLevel() + 1;
                    while (p <= levelup) {
                        a.getPlayerListener().a(bp, p);
                        ++p;
                    }
                    bp.setLevel(levelup);
                }
            }
            bp.saveAsync();
        }
    }

    public static void removeScore(UUID uuid, double amount) {
        if (amount <= 0.0) {
            return;
        }
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            double score = bp.getScore() - amount;
            if (score < 0.0 && !a.getSettings().af()) {
                score = 0.0;
            }
            if (score == bp.getScore()) {
                return;
            }
            bp.setScore(score);
            bp.saveAsync();
        }
    }

    public static int getKillstreak(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getKillstreak();
        }
        return 0;
    }

    public static int getTopKillstreak(UUID uuid) {
        BattlePlayer bp = BattleLevelsAPI.findPlayer(uuid);
        if (bp != null) {
            return bp.getTopStreak();
        }
        return 0;
    }

    public static List<Map.Entry<String, Integer>> getTopKills() {
        return a.getTools().topKills();
    }

    public static List<Map.Entry<String, Integer>> getTopDeaths() {
        return a.getTools().topDeaths();
    }

    public static List<Map.Entry<String, Integer>> getTopLevels() {
        return a.getTools().topLevels();
    }

    public static List<Map.Entry<String, Integer>> getTopKillstreaks() {
        return a.getTools().topKillstreaks();
    }

    public static List<Map.Entry<String, Integer>> getTopHighestKillstreaks() {
        return a.getTools().topTopKillstreaks();
    }

    public static List<Map.Entry<String, Double>> getTopScores() {
        return a.getTools().topScores();
    }

    public static BattlePlayer findPlayer(String name) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.getName().equalsIgnoreCase(name) || !a.getPlayerController().contains(p.getUniqueId())) continue;
            return a.getPlayerController().a(p.getUniqueId());
        }
        return a.getTools().getData(name);
    }

    public static BattlePlayer findPlayer(UUID uuid) {
        BattlePlayer p = a.getPlayerController().a(uuid);
        if (p != null) {
            return p;
        }
        return a.getTools().getData(uuid);
    }
}

