/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.loot;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsConfig;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import com.codisimus.plugins.phatloots.gui.Tool;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootBundle;
import com.tealcube.minecraft.bukkit.mythicdrops.api.tiers.Tier;
import com.tealcube.minecraft.bukkit.mythicdrops.tiers.TierMap;
import com.tealcube.minecraft.bukkit.mythicdrops.utils.ItemStackUtil;
import com.tealcube.minecraft.bukkit.mythicdrops.utils.ItemUtil;
import com.tealcube.minecraft.bukkit.mythicdrops.utils.TierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@SerializableAs(value="UnidentifiedItem")
public class UnidentifiedItem
extends Loot {
    private static final String RANDOM_TIER = "RANDOM";
    private static ArrayList<String> tierList = null;
    public String tierName;
    public int amountLower = 1;
    public int amountUpper = 1;
    public int durabilityLower = 0;
    public int durabilityUpper = 0;

    public UnidentifiedItem() {
        this.tierName = RANDOM_TIER;
    }

    public UnidentifiedItem(String string) {
        this.tierName = string;
    }

    public UnidentifiedItem(String string, int n, int n2, int n3, int n4) {
        this.tierName = string;
        this.amountLower = n;
        this.amountUpper = n2;
        this.durabilityLower = n3;
        this.durabilityUpper = n4;
    }

    public UnidentifiedItem(Map<String, Object> map) {
        String string = null;
        try {
            string = "Probability";
            Object object = map.get("Probability");
            this.setProbability(object instanceof Double ? (Double)object : (double)((Integer)object).intValue());
            string = "Tier";
            this.tierName = (String)map.get("Tier");
            string = "Amount";
            if (map.containsKey("Amount")) {
                this.amountLower = this.amountUpper = ((Integer)map.get(string)).intValue();
            } else {
                string = "AmountLower";
                if (map.containsKey("AmountLower")) {
                    this.amountLower = (Integer)map.get(string);
                    string = "AmountUpper";
                    this.amountUpper = (Integer)map.get("AmountUpper");
                }
            }
            string = "Durability";
            if (map.containsKey("Durability")) {
                this.durabilityLower = this.durabilityUpper = ((Integer)map.get(string)).intValue();
            } else {
                string = "DurabilityLower";
                if (map.containsKey("DurabilityLower")) {
                    this.durabilityLower = (Integer)map.get(string);
                    string = "DurabilityUpper";
                    this.durabilityUpper = (Integer)map.get("DurabilityUpper");
                }
            }
        }
        catch (Exception exception) {
            PhatLoots.logger.severe("Failed to load UnidentifiedItem line: " + string);
            PhatLoots.logger.severe("of PhatLoot: " + (PhatLoot.current == null ? "unknown" : PhatLoot.current));
            PhatLoots.logger.severe("Last successfull load was...");
            PhatLoots.logger.severe("PhatLoot: " + (PhatLoot.last == null ? "unknown" : PhatLoot.last));
            PhatLoots.logger.severe("Loot: " + (Loot.last == null ? "unknown" : Loot.last.toString()));
        }
    }

    @Override
    public void getLoot(LootBundle lootBundle, double d) {
        for (int i = PhatLootsUtil.rollForInt(this.amountLower, this.amountUpper); i > 0; --i) {
            Tier tier;
            Tier tier2 = tier = this.tierName.equalsIgnoreCase(RANDOM_TIER) ? TierMap.getInstance().getRandomWithChance() : TierUtil.getTier((String)this.tierName);
            if (tier == null) continue;
            Collection collection = ItemUtil.getMaterialsFromTier((Tier)tier);
            Material material = ItemUtil.getRandomMaterialFromCollection((Collection)collection);
            com.tealcube.minecraft.bukkit.mythicdrops.identification.UnidentifiedItem unidentifiedItem = new com.tealcube.minecraft.bukkit.mythicdrops.identification.UnidentifiedItem(material);
            if (this.durabilityLower > 0 || this.durabilityUpper > 0) {
                unidentifiedItem.setDurability(ItemStackUtil.getDurabilityForMaterial((Material)unidentifiedItem.getType(), (double)this.durabilityLower, (double)this.durabilityUpper));
            }
            ItemMeta itemMeta = unidentifiedItem.hasItemMeta() ? unidentifiedItem.getItemMeta() : Bukkit.getItemFactory().getItemMeta(material);
            List list = itemMeta.hasLore() ? itemMeta.getLore() : new ArrayList();
            list.add(PhatLootsConfig.tierPrefix + this.tierName);
            itemMeta.setLore(list);
            unidentifiedItem.setItemMeta(itemMeta);
            lootBundle.addItem((ItemStack)unidentifiedItem);
        }
    }

    @Override
    public ItemStack getInfoStack() {
        ItemStack itemStack = new ItemStack(Material.ITEM_FRAME);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72Unidentified Item");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u00a71Tier: \u00a76" + this.tierName);
        arrayList.add("\u00a71Probability: \u00a76" + this.getProbability());
        if (this.amountLower == this.amountUpper) {
            arrayList.add("\u00a71Amount: \u00a76" + this.amountLower);
        } else {
            arrayList.add("\u00a71Amount: \u00a76" + this.amountLower + '-' + this.amountUpper);
        }
        if (this.durabilityLower == this.durabilityUpper) {
            arrayList.add("\u00a71Durability: \u00a76" + this.durabilityLower);
        } else {
            arrayList.add("\u00a71Durability: \u00a76" + this.durabilityLower + '-' + this.durabilityUpper);
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public boolean onToggle(ClickType clickType) {
        return false;
    }

    @Override
    public boolean onToolClick(Tool tool, ClickType clickType) {
        if (!tool.getName().equals("MYTHICDROPS")) {
            return false;
        }
        UnidentifiedItem.instantiateTierList();
        int n = tierList.indexOf(this.tierName);
        switch (clickType) {
            case LEFT: {
                ++n;
                break;
            }
            case DOUBLE_CLICK: {
                n += 9;
                break;
            }
            case RIGHT: {
                --n;
                break;
            }
            case SHIFT_LEFT: {
                n += 100;
                break;
            }
            case SHIFT_RIGHT: {
                n -= 100;
                break;
            }
            case MIDDLE: {
                n = 0;
                break;
            }
            default: {
                return false;
            }
        }
        while (n >= tierList.size()) {
            n -= tierList.size();
        }
        while (n < 0) {
            n += tierList.size();
        }
        this.tierName = tierList.get(n);
        return true;
    }

    private static void instantiateTierList() {
        if (tierList == null) {
            tierList = new ArrayList();
            for (Tier tier : TierMap.getInstance().values()) {
                tierList.add(tier.getName());
            }
            Collections.sort(tierList);
            tierList.add(0, RANDOM_TIER);
        }
    }

    @Override
    public boolean modifyAmount(int n, boolean bl) {
        if (bl) {
            this.amountLower += n;
            if (this.amountLower < 0) {
                this.amountLower = 0;
            }
        }
        this.amountUpper += n;
        if (this.amountUpper < this.amountLower) {
            this.amountUpper = this.amountLower;
        }
        return true;
    }

    @Override
    public boolean resetAmount() {
        this.amountLower = 1;
        this.amountUpper = 1;
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.amountLower);
        if (this.amountLower != this.amountUpper) {
            stringBuilder.append('-');
            stringBuilder.append(this.amountUpper);
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.tierName);
        stringBuilder.append(" tiered Unidentified item ");
        stringBuilder.append(" @ ");
        stringBuilder.append(Math.floor(this.getProbability()) == this.getProbability() ? String.valueOf((int)this.getProbability()) : String.valueOf(this.getProbability()));
        stringBuilder.append("%");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnidentifiedItem)) {
            return false;
        }
        UnidentifiedItem unidentifiedItem = (UnidentifiedItem)object;
        return unidentifiedItem.tierName.equals(this.tierName) && unidentifiedItem.amountLower == this.amountLower && unidentifiedItem.amountUpper == this.amountUpper && unidentifiedItem.durabilityLower == this.durabilityLower && unidentifiedItem.durabilityUpper == this.durabilityUpper;
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + Objects.hashCode(this.tierName);
        n = 31 * n + this.amountLower;
        n = 31 * n + this.amountUpper;
        n = 31 * n + this.durabilityLower;
        n = 31 * n + this.durabilityUpper;
        return n;
    }

    public Map<String, Object> serialize() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Probability", this.getProbability());
        treeMap.put("Tier", this.tierName);
        if (this.amountLower == this.amountUpper) {
            if (this.amountLower != 1) {
                treeMap.put("Amount", this.amountLower);
            }
        } else {
            treeMap.put("AmountLower", this.amountLower);
            treeMap.put("AmountUpper", this.amountUpper);
        }
        if (this.durabilityLower == this.durabilityUpper) {
            if (this.durabilityLower != 1) {
                treeMap.put("Durability", this.durabilityLower);
            }
        } else {
            treeMap.put("DurabilityLower", this.durabilityLower);
            treeMap.put("DurabilityUpper", this.durabilityUpper);
        }
        return treeMap;
    }

    static {
        UnidentifiedItem.instantiateTierList();
    }
}

