/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.loot;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import com.codisimus.plugins.phatloots.gui.Button;
import com.codisimus.plugins.phatloots.gui.InventoryListener;
import com.codisimus.plugins.phatloots.gui.Tool;
import com.codisimus.plugins.phatloots.loot.Gem;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootBundle;
import com.codisimus.plugins.phatloots.loot.UnidentifiedItem;
import com.tealcube.minecraft.bukkit.mythicdrops.MythicDropsPlugin;
import com.tealcube.minecraft.bukkit.mythicdrops.api.items.ItemGenerationReason;
import com.tealcube.minecraft.bukkit.mythicdrops.api.tiers.Tier;
import com.tealcube.minecraft.bukkit.mythicdrops.tiers.TierMap;
import com.tealcube.minecraft.bukkit.mythicdrops.utils.ItemStackUtil;
import com.tealcube.minecraft.bukkit.mythicdrops.utils.TierUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@SerializableAs(value="MythicDropsItem")
public class MythicDropsItem
extends Loot {
    private static ArrayList<String> tierList = null;
    public String tierName;
    public int amountLower = 1;
    public int amountUpper = 1;
    public int durabilityLower = 0;
    public int durabilityUpper = 0;

    public static void registerButtonAndTool() {
        ItemStack itemStack = new ItemStack(Material.ENCHANTMENT_TABLE);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        ArrayList<String> arrayList = new ArrayList<String>();
        itemMeta.setDisplayName("\u00a72Add new MythicDrops Item...");
        arrayList.add("\u00a74LEFT CLICK:");
        arrayList.add("\u00a76 Add new MythicDrops Item");
        arrayList.add("\u00a74RIGHT CLICK:");
        arrayList.add("\u00a76 Add new Gem");
        arrayList.add("\u00a74SHIFT + LEFT CLICK:");
        arrayList.add("\u00a76 Add new Unidentified Item");
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        InventoryListener.registerButton(new AddMythicDropsItemButton(itemStack));
        itemStack = new ItemStack(Material.ENCHANTMENT_TABLE);
        ItemMeta itemMeta2 = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        itemMeta2.setDisplayName("\u00a72MythicDrops Toggle (Click to change Tool)");
        arrayList2.add("\u00a71Toggles through the names of Tiers and Gems");
        arrayList2.add("\u00a71Names toggle in alphabetical order");
        arrayList2.add("\u00a74LEFT CLICK:");
        arrayList2.add("\u00a76 Next Name");
        arrayList2.add("\u00a74RIGHT CLICK:");
        arrayList2.add("\u00a76 Previous Name");
        arrayList2.add("\u00a74DOUBLE CLICK:");
        arrayList2.add("\u00a76 Ahead 10 Names");
        arrayList2.add("\u00a74SHIFT + LEFT CLICK:");
        arrayList2.add("\u00a76 Ahead 100 Names");
        arrayList2.add("\u00a74SHIFT + RIGHT CLICK:");
        arrayList2.add("\u00a76 Back 100 Names");
        arrayList2.add("\u00a74SCROLL CLICK:");
        arrayList2.add("\u00a76 Back to first Name");
        itemMeta2.setLore(arrayList2);
        itemStack.setItemMeta(itemMeta2);
        new Tool("MYTHICDROPS", itemStack).registerTool();
    }

    public MythicDropsItem(String string) {
        this.tierName = string;
    }

    public MythicDropsItem(String string, int n, int n2, int n3, int n4) {
        this.tierName = string;
        this.amountLower = n;
        this.amountUpper = n2;
        this.durabilityLower = n3;
        this.durabilityUpper = n4;
    }

    public MythicDropsItem(Map<String, Object> map) {
        String string = null;
        try {
            string = "Probability";
            Object object = map.get("Probability");
            this.setProbability(object instanceof Double ? (Double)object : (double)((Integer)object).intValue());
            string = "Tier";
            this.tierName = (String)map.get("Tier");
            string = "Amount";
            if (map.containsKey("Amount")) {
                this.amountLower = this.amountUpper = ((Integer)map.get(string)).intValue();
            } else {
                string = "AmountLower";
                if (map.containsKey("AmountLower")) {
                    this.amountLower = (Integer)map.get(string);
                    string = "AmountUpper";
                    this.amountUpper = (Integer)map.get("AmountUpper");
                }
            }
            string = "Durability";
            if (map.containsKey("Durability")) {
                this.durabilityLower = this.durabilityUpper = ((Integer)map.get(string)).intValue();
            } else {
                string = "DurabilityLower";
                if (map.containsKey("DurabilityLower")) {
                    this.durabilityLower = (Integer)map.get(string);
                    string = "DurabilityUpper";
                    this.durabilityUpper = (Integer)map.get("DurabilityUpper");
                }
            }
        }
        catch (Exception exception) {
            PhatLoots.logger.severe("Failed to load MythicDropsItem line: " + string);
            PhatLoots.logger.severe("of PhatLoot: " + (PhatLoot.current == null ? "unknown" : PhatLoot.current));
            PhatLoots.logger.severe("Last successfull load was...");
            PhatLoots.logger.severe("PhatLoot: " + (PhatLoot.last == null ? "unknown" : PhatLoot.last));
            PhatLoots.logger.severe("Loot: " + (Loot.last == null ? "unknown" : Loot.last.toString()));
        }
    }

    @Override
    public void getLoot(LootBundle lootBundle, double d) {
        Tier tier = TierUtil.getTier((String)this.tierName);
        for (int i = PhatLootsUtil.rollForInt(this.amountLower, this.amountUpper); i > 0; --i) {
            ItemStack itemStack = MythicDropsPlugin.getNewDropBuilder().useDurability(false).withItemGenerationReason(ItemGenerationReason.EXTERNAL).withTier(tier).build();
            if (this.durabilityLower > 0 || this.durabilityUpper > 0) {
                itemStack.setDurability(ItemStackUtil.getDurabilityForMaterial((Material)itemStack.getType(), (double)this.durabilityLower, (double)this.durabilityUpper));
            }
            lootBundle.addItem(itemStack);
        }
    }

    @Override
    public ItemStack getInfoStack() {
        ItemStack itemStack = new ItemStack(Material.ENCHANTMENT_TABLE);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72MythicDrops Item");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u00a71Tier: \u00a76" + this.tierName);
        arrayList.add("\u00a71Probability: \u00a76" + this.getProbability());
        if (this.amountLower == this.amountUpper) {
            arrayList.add("\u00a71Amount: \u00a76" + this.amountLower);
        } else {
            arrayList.add("\u00a71Amount: \u00a76" + this.amountLower + '-' + this.amountUpper);
        }
        if (this.durabilityLower == this.durabilityUpper) {
            arrayList.add("\u00a71Durability: \u00a76" + this.durabilityLower);
        } else {
            arrayList.add("\u00a71Durability: \u00a76" + this.durabilityLower + '-' + this.durabilityUpper);
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public boolean onToggle(ClickType clickType) {
        return false;
    }

    @Override
    public boolean onToolClick(Tool tool, ClickType clickType) {
        if (!tool.getName().equals("MYTHICDROPS")) {
            return false;
        }
        if (tierList.isEmpty()) {
            return false;
        }
        int n = tierList.indexOf(this.tierName);
        switch (clickType) {
            case LEFT: {
                ++n;
                break;
            }
            case DOUBLE_CLICK: {
                n += 9;
                break;
            }
            case RIGHT: {
                --n;
                break;
            }
            case SHIFT_LEFT: {
                n += 100;
                break;
            }
            case SHIFT_RIGHT: {
                n -= 100;
                break;
            }
            case MIDDLE: {
                n = 0;
                break;
            }
            default: {
                return false;
            }
        }
        while (n >= tierList.size()) {
            n -= tierList.size();
        }
        while (n < 0) {
            n += tierList.size();
        }
        this.tierName = tierList.get(n);
        return true;
    }

    private static void instantiateTierList() {
        if (tierList == null) {
            tierList = new ArrayList();
            for (Tier tier : TierMap.getInstance().values()) {
                tierList.add(tier.getName());
            }
            Collections.sort(tierList);
        }
    }

    @Override
    public boolean modifyAmount(int n, boolean bl) {
        if (bl) {
            this.amountLower += n;
            if (this.amountLower < 0) {
                this.amountLower = 0;
            }
        }
        this.amountUpper += n;
        if (this.amountUpper < this.amountLower) {
            this.amountUpper = this.amountLower;
        }
        return true;
    }

    @Override
    public boolean resetAmount() {
        this.amountLower = 1;
        this.amountUpper = 1;
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.amountLower);
        if (this.amountLower != this.amountUpper) {
            stringBuilder.append('-');
            stringBuilder.append(this.amountUpper);
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.tierName);
        stringBuilder.append(" tiered MythicDrops item ");
        stringBuilder.append(" @ ");
        stringBuilder.append(Math.floor(this.getProbability()) == this.getProbability() ? String.valueOf((int)this.getProbability()) : String.valueOf(this.getProbability()));
        stringBuilder.append("%");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MythicDropsItem)) {
            return false;
        }
        MythicDropsItem mythicDropsItem = (MythicDropsItem)object;
        return mythicDropsItem.tierName.equals(this.tierName) && mythicDropsItem.amountLower == this.amountLower && mythicDropsItem.amountUpper == this.amountUpper && mythicDropsItem.durabilityLower == this.durabilityLower && mythicDropsItem.durabilityUpper == this.durabilityUpper;
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + Objects.hashCode(this.tierName);
        n = 31 * n + this.amountLower;
        n = 31 * n + this.amountUpper;
        n = 31 * n + this.durabilityLower;
        n = 31 * n + this.durabilityUpper;
        return n;
    }

    public Map<String, Object> serialize() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Probability", this.getProbability());
        treeMap.put("Tier", this.tierName);
        if (this.amountLower == this.amountUpper) {
            if (this.amountLower != 1) {
                treeMap.put("Amount", this.amountLower);
            }
        } else {
            treeMap.put("AmountLower", this.amountLower);
            treeMap.put("AmountUpper", this.amountUpper);
        }
        if (this.durabilityLower == this.durabilityUpper) {
            if (this.durabilityLower != 1) {
                treeMap.put("Durability", this.durabilityLower);
            }
        } else {
            treeMap.put("DurabilityLower", this.durabilityLower);
            treeMap.put("DurabilityUpper", this.durabilityUpper);
        }
        return treeMap;
    }

    static {
        MythicDropsItem.instantiateTierList();
    }

    private static class AddMythicDropsItemButton
    extends Button {
        private AddMythicDropsItemButton(ItemStack itemStack) {
            super(itemStack);
        }

        @Override
        public boolean onClick(ClickType clickType, Inventory inventory, PhatLoot phatLoot, List<Loot> list) {
            Loot loot;
            switch (clickType) {
                case RIGHT: {
                    loot = new Gem();
                    break;
                }
                case SHIFT_LEFT: {
                    loot = new UnidentifiedItem();
                    break;
                }
                default: {
                    loot = new MythicDropsItem((String)tierList.get(0));
                }
            }
            list.add(loot);
            return true;
        }
    }
}

