/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.loot;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootBundle;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@SerializableAs(value="Message")
public class Message
extends Loot {
    private String msg;

    public Message(String string) {
        this.msg = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public Message(Map<String, Object> map) {
        String string = null;
        try {
            string = "Probability";
            this.probability = (Double)map.get("Probability");
            string = "Message";
            this.msg = (String)map.get("Message");
        }
        catch (Exception exception) {
            PhatLoots.logger.severe("Failed to load Message line: " + string);
            PhatLoots.logger.severe("of PhatLoot: " + (PhatLoot.current == null ? "unknown" : PhatLoot.current));
            PhatLoots.logger.severe("Last successfull load was...");
            PhatLoots.logger.severe("PhatLoot: " + (PhatLoot.last == null ? "unknown" : PhatLoot.last));
            PhatLoots.logger.severe("Loot: " + (Loot.last == null ? "unknown" : Loot.last.toString()));
        }
    }

    @Override
    public void getLoot(LootBundle lootBundle, double d) {
        lootBundle.addMessage(this.msg);
    }

    @Override
    public ItemStack getInfoStack() {
        ItemStack itemStack = new ItemStack(Material.MAP);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72Message");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u00a74Probability: \u00a76" + this.probability);
        arrayList.add("\u00a74Message: \u00a76" + this.msg);
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public boolean onToggle(ClickType clickType) {
        return false;
    }

    @Override
    public boolean modifyAmount(int n, boolean bl) {
        return false;
    }

    @Override
    public boolean resetAmount() {
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.msg);
        stringBuilder.append(" @ ");
        stringBuilder.append(String.valueOf(Math.floor(this.probability) == this.probability ? (double)((int)this.probability) : this.probability));
        stringBuilder.append("%");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Message) {
            Message message = (Message)object;
            return message.msg.equals(this.msg);
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 79 * n + (this.msg != null ? this.msg.hashCode() : 0);
        return n;
    }

    public Map<String, Object> serialize() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Probability", this.probability);
        treeMap.put("Message", this.msg);
        return treeMap;
    }
}

