/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.loot;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsConfig;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import com.codisimus.plugins.phatloots.gui.Button;
import com.codisimus.plugins.phatloots.gui.InventoryListener;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@SerializableAs(value="LootCollection")
public class LootCollection
extends Loot {
    public static boolean allowDuplicates;
    public String name;
    public int lowerNumberOfLoots;
    public int upperNumberOfLoots;
    private LinkedList<Loot> lootList;

    public static void registerButton() {
        ItemStack itemStack = new ItemStack(Material.ENDER_CHEST);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72Add new collection...");
        itemStack.setItemMeta(itemMeta);
        InventoryListener.registerButton(new AddCollectionButton(itemStack));
    }

    public LootCollection(String string) {
        this.name = string;
        this.lowerNumberOfLoots = PhatLootsConfig.defaultLowerNumberOfLoots;
        this.upperNumberOfLoots = PhatLootsConfig.defaultUpperNumberOfLoots;
        this.lootList = new LinkedList();
    }

    public LootCollection(String string, int n, int n2) {
        this.name = string;
        this.lowerNumberOfLoots = n;
        this.upperNumberOfLoots = n2;
        this.lootList = new LinkedList();
    }

    public LootCollection(Map<String, Object> map) {
        String string = null;
        try {
            string = "Probability";
            this.probability = (Double)map.get("Probability");
            string = "Name";
            this.name = (String)map.get("Name");
            string = "LowerNumberOfLoots";
            this.lowerNumberOfLoots = (Integer)map.get("LowerNumberOfLoots");
            string = "UpperNumberOfLoots";
            this.upperNumberOfLoots = (Integer)map.get("UpperNumberOfLoots");
            string = "LootList";
            this.lootList = new LinkedList((List)map.get("LootList"));
        }
        catch (Exception exception) {
            PhatLoots.logger.severe("Failed to load LootCollection line: " + string);
            PhatLoots.logger.severe("of PhatLoot: " + (PhatLoot.current == null ? "unknown" : PhatLoot.current));
            PhatLoots.logger.severe("Last successfull load was...");
            PhatLoots.logger.severe("PhatLoot: " + (PhatLoot.last == null ? "unknown" : PhatLoot.last));
            PhatLoots.logger.severe("Loot: " + (Loot.last == null ? "unknown" : Loot.last.toString()));
        }
    }

    @Override
    public void getLoot(LootBundle lootBundle, double d) {
        if (this.isRollForEach()) {
            for (Loot loot : this.lootList) {
                if (!loot.rollForLoot(d) || !loot.rollForLoot(d)) continue;
                loot.getLoot(lootBundle, d);
            }
        } else {
            int n;
            int n2 = n = this.lowerNumberOfLoots == this.upperNumberOfLoots ? this.lowerNumberOfLoots : PhatLootsUtil.rollForInt(this.lowerNumberOfLoots, this.upperNumberOfLoots);
            if (!this.lootList.isEmpty()) {
                Collections.sort(this.lootList);
                LinkedList<Loot> linkedList = new LinkedList<Loot>();
                block1: for (int i = 0; i < n; ++i) {
                    double d2 = 0.0;
                    for (Loot loot : this.lootList) {
                        d2 += loot.probability;
                    }
                    double d3 = PhatLootsUtil.rollForDouble(d2) - d;
                    for (Loot loot : this.lootList) {
                        if (!((d3 -= loot.getProbability()) <= 0.0)) continue;
                        loot.getLoot(lootBundle, d);
                        if (allowDuplicates) continue block1;
                        linkedList.add(loot);
                        this.lootList.remove(loot);
                        continue block1;
                    }
                }
                this.lootList.addAll(linkedList);
            }
        }
    }

    public LinkedList<Loot> getLootList() {
        return this.lootList;
    }

    @Override
    public ItemStack getInfoStack() {
        ItemStack itemStack = new ItemStack(Material.ENDER_CHEST);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72" + this.name + " (Collection)");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u00a71Probability: \u00a76" + this.probability);
        if (this.isRollForEach()) {
            arrayList.add("\u00a76Each loot is rolled for");
        } else if (this.lowerNumberOfLoots == this.upperNumberOfLoots) {
            arrayList.add("\u00a71Number of Loots: \u00a76" + this.lowerNumberOfLoots);
        } else {
            arrayList.add("\u00a71Number of Loots: \u00a76" + this.lowerNumberOfLoots + '-' + this.upperNumberOfLoots);
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public boolean onToggle(ClickType clickType) {
        return false;
    }

    @Override
    public boolean modifyAmount(int n, boolean bl) {
        if (bl) {
            this.lowerNumberOfLoots += n;
            if (this.lowerNumberOfLoots < 0) {
                this.lowerNumberOfLoots = 0;
            }
        }
        this.upperNumberOfLoots += n;
        if (this.upperNumberOfLoots < this.lowerNumberOfLoots) {
            this.upperNumberOfLoots = this.lowerNumberOfLoots;
        }
        return true;
    }

    @Override
    public boolean resetAmount() {
        this.lowerNumberOfLoots = 1;
        this.upperNumberOfLoots = 1;
        return true;
    }

    public boolean isRollForEach() {
        return this.upperNumberOfLoots <= 0;
    }

    public boolean addLoot(Loot loot) {
        for (Loot loot2 : this.lootList) {
            if (!loot2.equals(loot)) continue;
            return false;
        }
        this.lootList.add(loot);
        return true;
    }

    public boolean removeLoot(Loot loot) {
        Iterator iterator = this.lootList.iterator();
        while (iterator.hasNext()) {
            if (!((Loot)iterator.next()).equals(loot)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public LootCollection findCollection(String string) {
        if (this.name.equals(string)) {
            return this;
        }
        for (Loot loot : this.lootList) {
            LootCollection lootCollection;
            if (!(loot instanceof LootCollection) || (lootCollection = ((LootCollection)loot).findCollection(string)) == null) continue;
            return lootCollection;
        }
        return null;
    }

    public String toString() {
        return this.name + " (Collection)";
    }

    public boolean equals(Object object) {
        if (!(object instanceof LootCollection)) {
            return false;
        }
        LootCollection lootCollection = (LootCollection)object;
        return lootCollection.name.equals(this.name);
    }

    public int hashCode() {
        int n = 5;
        n = 59 * n + (this.name != null ? this.name.hashCode() : 0);
        return n;
    }

    public Map<String, Object> serialize() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Probability", this.probability);
        treeMap.put("Name", this.name);
        treeMap.put("LowerNumberOfLoots", this.lowerNumberOfLoots);
        treeMap.put("UpperNumberOfLoots", this.upperNumberOfLoots);
        treeMap.put("LootList", this.lootList);
        return treeMap;
    }

    private static class AddCollectionButton
    extends Button {
        private AddCollectionButton(ItemStack itemStack) {
            super(itemStack);
        }

        @Override
        public boolean onClick(ClickType clickType, Inventory inventory, PhatLoot phatLoot, List<Loot> list) {
            int n = 1;
            while (phatLoot.findCollection(String.valueOf(n)) != null) {
                ++n;
            }
            list.add(new LootCollection(String.valueOf(n)));
            return true;
        }
    }
}

