/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.loot;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@SerializableAs(value="Item")
public class Item
extends Loot {
    private static final String BASE_VALUES = "BaseValues";
    private static final String ENCHANTMENT_VALUES = "EnchantmentValues";
    private static final String TIERS = "TIERS";
    private static final String DIVIDER = ".";
    private static final String ARMOR = "ARMOR";
    private static final String SWORD = "SWORD";
    private static final String AXE = "AXE";
    private static final String BOW = "BOW";
    private static final String PICKAXE = "PICKAXE";
    private static final String SPADE = "SPADE";
    private static final String HOE = "HOE";
    private static final String DAMAGE = "<dam>";
    private static final String HOLY = "<holy>";
    private static final String FIRE = "<fire>";
    private static final String BUG = "<bug>";
    private static final String THORNS = "<thorns>";
    private static final String DEFENSE = "<def>";
    private static final String FIRE_DEFENSE = "<firedef>";
    private static final String RANGE_DEFENSE = "<rangedef>";
    private static final String BLAST_DEFENSE = "<blastdef>";
    private static final String FALL_DEFENSE = "<falldef>";
    private static final Enchantment[] ARMOR_ENCHANTMENTS = new Enchantment[]{Enchantment.PROTECTION_ENVIRONMENTAL, Enchantment.PROTECTION_FIRE, Enchantment.PROTECTION_EXPLOSIONS, Enchantment.PROTECTION_PROJECTILE, Enchantment.THORNS, Enchantment.DURABILITY};
    private static final Enchantment[] SWORD_ENCHANTMENTS = new Enchantment[]{Enchantment.DAMAGE_ALL, Enchantment.DAMAGE_UNDEAD, Enchantment.DAMAGE_ARTHROPODS, Enchantment.KNOCKBACK, Enchantment.FIRE_ASPECT, Enchantment.LOOT_BONUS_MOBS, Enchantment.DURABILITY};
    private static final Enchantment[] AXE_ENCHANTMENTS = new Enchantment[]{Enchantment.DAMAGE_ALL, Enchantment.DAMAGE_UNDEAD, Enchantment.DAMAGE_ARTHROPODS, Enchantment.KNOCKBACK, Enchantment.FIRE_ASPECT, Enchantment.LOOT_BONUS_MOBS, Enchantment.DURABILITY};
    private static final Enchantment[] BOW_ENCHANTMENTS = new Enchantment[]{Enchantment.ARROW_DAMAGE, Enchantment.ARROW_KNOCKBACK, Enchantment.ARROW_FIRE, Enchantment.ARROW_INFINITE, Enchantment.DURABILITY};
    private static final Enchantment[] PICKAXE_ENCHANTMENTS = new Enchantment[]{Enchantment.DIG_SPEED, Enchantment.DURABILITY};
    private static final Enchantment[] SPADE_ENCHANTMENTS = new Enchantment[]{Enchantment.DIG_SPEED, Enchantment.DURABILITY};
    private static final Enchantment[] HOE_ENCHANTMENTS = new Enchantment[]{Enchantment.DURABILITY};
    private static final EnumSet<Material> ARMOR_MATERIAL_SET = EnumSet.of(Material.DIAMOND_HELMET, new Material[]{Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS, Material.GOLD_HELMET, Material.GOLD_CHESTPLATE, Material.GOLD_LEGGINGS, Material.GOLD_BOOTS, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS});
    private static final EnumSet<Material> SWORD_MATERIAL_SET = EnumSet.of(Material.DIAMOND_SWORD, Material.IRON_SWORD, Material.GOLD_SWORD, Material.STONE_SWORD, Material.WOOD_SWORD);
    private static final EnumSet<Material> AXE_MATERIAL_SET = EnumSet.of(Material.DIAMOND_AXE, Material.IRON_AXE, Material.GOLD_AXE, Material.STONE_AXE, Material.WOOD_AXE);
    private static final EnumSet<Material> PICKAXE_MATERIAL_SET = EnumSet.of(Material.DIAMOND_PICKAXE, Material.IRON_PICKAXE, Material.GOLD_PICKAXE, Material.STONE_PICKAXE, Material.WOOD_PICKAXE);
    private static final EnumSet<Material> SPADE_MATERIAL_SET = EnumSet.of(Material.DIAMOND_SPADE, Material.IRON_SPADE, Material.GOLD_SPADE, Material.STONE_SPADE, Material.WOOD_SPADE);
    private static final EnumSet<Material> HOE_MATERIAL_SET = EnumSet.of(Material.DIAMOND_HOE, Material.IRON_HOE, Material.GOLD_HOE, Material.STONE_HOE, Material.WOOD_HOE);
    public static int tierNotify;
    public static FileConfiguration loreConfig;
    public static FileConfiguration tiersConfig;
    public static FileConfiguration enchantmentConfig;
    public static boolean damageTags;
    public static String damageString;
    public static String holyString;
    public static String bugString;
    public static String fireString;
    public static String thornsString;
    public static String defenseString;
    public static String fireDefenseString;
    public static String rangeDefenseString;
    public static String blastDefenseString;
    public static String fallDefenseString;
    public ItemStack item;
    public int amountBonus = 0;
    public int durabilityBonus = 0;
    public boolean autoEnchant = false;
    public boolean generateName = false;
    public boolean randomLore = false;
    public boolean tieredName = false;

    public Item(ItemStack itemStack, int n) {
        this.item = itemStack;
        this.amountBonus = n;
    }

    public Item(Map<String, Object> map) {
        String string = null;
        try {
            string = "Probability";
            Object object = map.get("Probability");
            this.probability = object instanceof Double ? (Double)object : (double)((Integer)object).intValue();
            string = "ItemStack";
            this.item = (ItemStack)map.get("ItemStack");
            string = "BonusAmount";
            if (map.containsKey("BonusAmount")) {
                this.amountBonus = (Integer)map.get(string);
            }
            string = "BonusDurability";
            if (map.containsKey("BonusDurability")) {
                this.durabilityBonus = (Integer)map.get(string);
            }
            string = "AutoEnchant";
            if (map.containsKey("AutoEnchant")) {
                this.autoEnchant = (Boolean)map.get(string);
            }
            string = "GenerateName";
            if (map.containsKey("GenerateName")) {
                this.generateName = (Boolean)map.get(string);
            }
            string = "RandomLore";
            if (map.containsKey("RandomLore")) {
                this.randomLore = (Boolean)map.get(string);
            }
            string = "Tiered";
            if (map.containsKey("Tiered")) {
                this.tieredName = (Boolean)map.get(string);
            }
        }
        catch (Exception exception) {
            PhatLoots.logger.severe("Failed to load Item line: " + string);
            PhatLoots.logger.severe("of PhatLoot: " + (PhatLoot.current == null ? "unknown" : PhatLoot.current));
            PhatLoots.logger.severe("Last successfull load was...");
            PhatLoots.logger.severe("PhatLoot: " + (PhatLoot.last == null ? "unknown" : PhatLoot.last));
            PhatLoots.logger.severe("Loot: " + (Loot.last == null ? "unknown" : Loot.last.toString()));
        }
    }

    @Override
    public void getLoot(LootBundle lootBundle, double d) {
        lootBundle.addItem(this.getItem());
    }

    @Override
    public ItemStack getInfoStack() {
        ArrayList<String> arrayList;
        ItemMeta itemMeta;
        boolean bl;
        ItemStack itemStack = this.item.clone();
        boolean bl2 = bl = itemStack.getType() == Material.AIR;
        if (bl) {
            itemStack.setType(Material.GLASS_BOTTLE);
        }
        ItemMeta itemMeta2 = itemMeta = itemStack.hasItemMeta() ? itemStack.getItemMeta() : Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        if (bl) {
            itemMeta.setDisplayName("AIR");
        }
        if (itemMeta.hasLore()) {
            arrayList = itemMeta.getLore();
            arrayList.add("\u00a71-----------------------------");
        } else {
            arrayList = new ArrayList<String>();
        }
        arrayList.add(ChatColor.DARK_BLUE + "Probability: " + ChatColor.GOLD + this.probability);
        if (this.amountBonus == 0) {
            arrayList.add(ChatColor.DARK_BLUE + "Amount: " + ChatColor.GOLD + this.item.getAmount());
        } else {
            arrayList.add(ChatColor.DARK_BLUE + "Amount: " + ChatColor.GOLD + this.item.getAmount() + '-' + (this.item.getAmount() + this.amountBonus));
        }
        if (this.autoEnchant) {
            arrayList.add(ChatColor.GOLD + "Auto Enchanted");
        }
        if (this.generateName) {
            arrayList.add(ChatColor.GOLD + "Generated Name");
        }
        if (this.randomLore) {
            arrayList.add(ChatColor.GOLD + "Random Lore");
        }
        if (this.tieredName) {
            arrayList.add(ChatColor.GOLD + "Tiered Name");
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public boolean onToggle(ClickType clickType) {
        switch (clickType) {
            case SHIFT_LEFT: {
                this.autoEnchant = !this.autoEnchant;
                break;
            }
            case SHIFT_RIGHT: {
                this.generateName = !this.generateName;
                break;
            }
            case MIDDLE: {
                this.tieredName = !this.tieredName;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean modifyAmount(int n, boolean bl) {
        if (bl) {
            this.item.setAmount(this.item.getAmount() + n);
            if (this.item.getAmount() < 0) {
                this.item.setAmount(this.item.getMaxStackSize());
            }
        } else {
            this.amountBonus += n;
            if (this.amountBonus < 0) {
                this.amountBonus = 50;
            }
        }
        return true;
    }

    @Override
    public boolean resetAmount() {
        this.item.setAmount(1);
        this.amountBonus = 0;
        return true;
    }

    public void setDurability(short s) {
        if (s >= 0) {
            this.item.setDurability(s);
        }
    }

    public ItemStack getItem() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        ItemStack itemStack = this.item.clone();
        Material material = itemStack.getType();
        if (this.autoEnchant) {
            if (ARMOR_MATERIAL_SET.contains(material)) {
                string = ARMOR;
                object4 = ARMOR_ENCHANTMENTS;
            } else if (SWORD_MATERIAL_SET.contains(material)) {
                string = SWORD;
                object4 = SWORD_ENCHANTMENTS;
            } else if (AXE_MATERIAL_SET.contains(material)) {
                string = AXE;
                object4 = AXE_ENCHANTMENTS;
            } else if (PICKAXE_MATERIAL_SET.contains(material)) {
                string = PICKAXE;
                object4 = PICKAXE_ENCHANTMENTS;
            } else if (SPADE_MATERIAL_SET.contains(material)) {
                string = SPADE;
                object4 = SPADE_ENCHANTMENTS;
            } else if (HOE_MATERIAL_SET.contains(material)) {
                string = HOE;
                object4 = HOE_ENCHANTMENTS;
            } else if (material == Material.BOW) {
                string = BOW;
                object4 = BOW_ENCHANTMENTS;
            } else {
                string = "";
                object4 = new Enchantment[]{};
            }
            for (Object object5 : object4) {
                String string2;
                object3 = string + '.' + object5.getName();
                if (!enchantmentConfig.contains((String)object3)) continue;
                object2 = enchantmentConfig.getConfigurationSection((String)object3);
                double d = 0.0;
                int n = 0;
                double d2 = Item.roll();
                Iterator iterator = object2.getKeys(false).iterator();
                while (iterator.hasNext() && !((d += object2.getDouble(string2 = (String)iterator.next())) > d2)) {
                    ++n;
                }
                if (n <= 0) continue;
                itemStack.addUnsafeEnchantment((Enchantment)object5, n);
            }
        }
        if (this.amountBonus > 0) {
            itemStack.setAmount(itemStack.getAmount() + PhatLootsUtil.rollForInt(this.amountBonus));
        }
        if (this.durabilityBonus > 0) {
            itemStack.setDurability((short)(itemStack.getDurability() + PhatLootsUtil.rollForInt(this.durabilityBonus)));
        }
        Object object6 = string = itemStack.hasItemMeta() ? itemStack.getItemMeta().clone() : Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        if (this.generateName || this.tieredName || this.randomLore) {
            object4 = new StringBuilder();
            if (this.randomLore) {
                object = itemStack.getType() + itemStack.getEnchantments().toString();
                File file = new File(PhatLoots.dataFolder, "Item Descriptions" + File.separator + (String)object);
                if (file.exists()) {
                    Object object5;
                    File[] fileArray = file.listFiles();
                    object5 = fileArray[PhatLootsUtil.rollForInt(fileArray.length)];
                    if (((File)object5).exists()) {
                        try {
                            object3 = new FileReader((File)object5);
                            object2 = null;
                            try (BufferedReader bufferedReader = new BufferedReader((Reader)object3);){
                                String string3 = bufferedReader.readLine();
                                if (string3 != null) {
                                    if (string3.charAt(0) == '&') {
                                        string3 = string3.replace('&', '\u00a7');
                                    }
                                    ((StringBuilder)object4).append(string3);
                                    LinkedList<String> linkedList = new LinkedList<String>();
                                    while ((string3 = bufferedReader.readLine()) != null) {
                                        string3 = string3.replace('&', '\u00a7');
                                        linkedList.add(string3);
                                    }
                                    string.setLore(linkedList);
                                }
                            }
                            catch (Throwable throwable) {
                                object2 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (object3 != null) {
                                    if (object2 != null) {
                                        try {
                                            ((InputStreamReader)object3).close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object2).addSuppressed(throwable);
                                        }
                                    } else {
                                        ((InputStreamReader)object3).close();
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        PhatLoots.logger.severe("The Item Description " + ((File)object5).getName() + " cannot be read");
                    }
                } else {
                    PhatLoots.logger.severe("You are attempting to use an undocumented feature (Random Lore), please contact Codisimus if you actually want to know how to use this.");
                }
            } else {
                ((StringBuilder)object4).append(PhatLootsUtil.getItemName(itemStack));
            }
            if (this.generateName) {
                this.generateName(itemStack, (StringBuilder)object4);
            }
            if (this.tieredName) {
                this.getTieredName(itemStack, (StringBuilder)object4);
            }
            string.setDisplayName(((StringBuilder)object4).toString());
            itemStack.setItemMeta((ItemMeta)string);
        }
        if (damageTags && string != null && string.hasLore()) {
            object4 = string.getLore();
            object = object4.listIterator();
            if (ARMOR_MATERIAL_SET.contains(material)) {
                while (object.hasNext()) {
                    String string4;
                    switch (string4 = (String)object.next()) {
                        case "<thorns>": {
                            if (itemStack.containsEnchantment(Enchantment.THORNS)) {
                                int n = (Integer)itemStack.getEnchantments().get(Enchantment.THORNS);
                                object.set(thornsString.replace("<chance>", String.valueOf(15 * n)));
                                break;
                            }
                            object.remove();
                            break;
                        }
                        case "<def>": {
                            int n;
                            int n2;
                            int n3 = this.getBaseArmor(itemStack.getType());
                            if (itemStack.containsEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL)) {
                                n2 = (Integer)itemStack.getEnchantments().get(Enchantment.PROTECTION_ENVIRONMENTAL);
                                int n4 = (int)Math.floor((double)(6 + n2 * n2) * 0.75 / 3.0);
                                n = n3 + (int)Math.ceil(n4 / 2);
                                int n5 = n3 + n4;
                                object.set(defenseString.replace("<amount>", n + "-" + n5));
                                break;
                            }
                            object.set(defenseString.replace("<amount>", String.valueOf(n3)));
                            break;
                        }
                        case "<firedef>": {
                            int n;
                            int n2;
                            if (itemStack.containsEnchantment(Enchantment.PROTECTION_FIRE)) {
                                n2 = (Integer)itemStack.getEnchantments().get(Enchantment.PROTECTION_FIRE);
                                int n6 = (int)Math.floor((double)(6 + n2 * n2) * 1.25 / 3.0);
                                n = (int)Math.ceil(n6 / 2);
                                int n7 = n6;
                                object.set(fireDefenseString.replace("<amount>", n + "-" + n7));
                                break;
                            }
                            object.remove();
                            break;
                        }
                        case "<rangedef>": {
                            int n;
                            int n2;
                            if (itemStack.containsEnchantment(Enchantment.PROTECTION_PROJECTILE)) {
                                n2 = (Integer)itemStack.getEnchantments().get(Enchantment.PROTECTION_PROJECTILE);
                                int n8 = (int)Math.floor((double)(6 + n2 * n2) * 1.5 / 3.0);
                                n = (int)Math.ceil(n8 / 2);
                                int n9 = n8;
                                object.set(rangeDefenseString.replace("<amount>", n + "-" + n9));
                                break;
                            }
                            object.remove();
                            break;
                        }
                        case "<blastdef>": {
                            int n;
                            int n2;
                            if (itemStack.containsEnchantment(Enchantment.PROTECTION_EXPLOSIONS)) {
                                n2 = (Integer)itemStack.getEnchantments().get(Enchantment.PROTECTION_EXPLOSIONS);
                                int n10 = (int)Math.floor((double)(6 + n2 * n2) * 1.5 / 3.0);
                                n = (int)Math.ceil(n10 / 2);
                                int n11 = n10;
                                object.set(blastDefenseString.replace("<amount>", n + "-" + n11));
                                break;
                            }
                            object.remove();
                            break;
                        }
                        case "<falldef>": {
                            int n;
                            int n2;
                            if (itemStack.containsEnchantment(Enchantment.PROTECTION_FALL)) {
                                n2 = (Integer)itemStack.getEnchantments().get(Enchantment.PROTECTION_FALL);
                                int n12 = (int)Math.floor((double)(6 + n2 * n2) * 2.5 / 3.0);
                                n = (int)Math.ceil(n12 / 2);
                                int n13 = n12;
                                object.set(fallDefenseString.replace("<amount>", n + "-" + n13));
                                break;
                            }
                            object.remove();
                            break;
                        }
                    }
                }
            } else if (material == Material.BOW) {
                while (object.hasNext()) {
                    String string5;
                    switch (string5 = (String)object.next()) {
                        case "<dam>": {
                            int n = 1;
                            int n14 = 10;
                            if (itemStack.containsEnchantment(Enchantment.DAMAGE_ALL)) {
                                int n15 = (Integer)itemStack.getEnchantments().get(Enchantment.ARROW_DAMAGE);
                                double d = n15 == 0 ? 0.0 : 0.25;
                                int n16 = n + (int)((double)n * (d += 0.25 * (double)n15));
                                int n17 = n14 + (int)((double)n14 * d);
                                object.set(damageString.replace("<amount>", n16 + "-" + n17));
                                break;
                            }
                            object.set(damageString.replace("<amount>", n + "-" + n14));
                            break;
                        }
                        case "<fire>": {
                            if (itemStack.containsEnchantment(Enchantment.ARROW_FIRE)) {
                                object.set(fireString.replace("<amount>", "4"));
                                break;
                            }
                            object.remove();
                            break;
                        }
                    }
                }
            } else {
                while (object.hasNext()) {
                    String string6;
                    switch (string6 = (String)object.next()) {
                        case "<dam>": {
                            int n;
                            int n18 = this.getBaseDamage(itemStack.getType());
                            int n19 = (int)((double)n18 * 1.5) + 2;
                            if (itemStack.containsEnchantment(Enchantment.DAMAGE_ALL)) {
                                int n20 = (Integer)itemStack.getEnchantments().get(Enchantment.DAMAGE_ALL);
                                n = n18 + n20;
                                int n21 = n19 + 3 * n20;
                                object.set(damageString.replace("<amount>", n + "-" + n21));
                                break;
                            }
                            object.set(damageString.replace("<amount>", n18 + "-" + n19));
                            break;
                        }
                        case "<holy>": {
                            int n;
                            if (itemStack.containsEnchantment(Enchantment.DAMAGE_UNDEAD)) {
                                int n22;
                                n = n22 = ((Integer)itemStack.getEnchantments().get(Enchantment.DAMAGE_UNDEAD)).intValue();
                                int n23 = 4 * n22;
                                object.set(holyString.replace("<amount>", n + "-" + n23));
                                break;
                            }
                            object.remove();
                            break;
                        }
                        case "<bug>": {
                            int n;
                            if (itemStack.containsEnchantment(Enchantment.DAMAGE_ARTHROPODS)) {
                                int n24;
                                n = n24 = ((Integer)itemStack.getEnchantments().get(Enchantment.DAMAGE_ARTHROPODS)).intValue();
                                int n25 = 4 * n24;
                                object.set(bugString.replace("<amount>", n + "-" + n25));
                                break;
                            }
                            object.remove();
                            break;
                        }
                        case "<fire>": {
                            int n;
                            if (itemStack.containsEnchantment(Enchantment.FIRE_ASPECT)) {
                                int n26 = (Integer)itemStack.getEnchantments().get(Enchantment.FIRE_ASPECT);
                                n = 4 * n26;
                                object.set(fireString.replace("<amount>", String.valueOf(n)));
                                break;
                            }
                            object.remove();
                            break;
                        }
                    }
                }
            }
            string.setLore((List)object4);
            itemStack.setItemMeta((ItemMeta)string);
        }
        return itemStack;
    }

    private void generateName(ItemStack itemStack, StringBuilder stringBuilder) {
        Material material = itemStack.getType();
        Map map = itemStack.getEnchantments();
        if (ARMOR_MATERIAL_SET.contains(material)) {
            String string = ARMOR;
            Enchantment enchantment = Enchantment.PROTECTION_FIRE;
            int n = this.getLevel(map, enchantment);
            String string2 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string2 != null) {
                stringBuilder.insert(0, ' ');
                stringBuilder.insert(0, string2);
            }
            enchantment = map.containsKey(Enchantment.THORNS) ? Enchantment.THORNS : Enchantment.DURABILITY;
            n = this.getLevel(map, enchantment);
            string2 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string2 != null) {
                stringBuilder.insert(0, ' ');
                stringBuilder.insert(0, string2);
            }
            enchantment = this.getTrump(map, Enchantment.PROTECTION_ENVIRONMENTAL, Enchantment.PROTECTION_PROJECTILE, Enchantment.PROTECTION_EXPLOSIONS);
            n = this.getLevel(map, enchantment);
            string2 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string2 != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string2);
            }
        } else if (SWORD_MATERIAL_SET.contains(material)) {
            String string = SWORD;
            Enchantment enchantment = this.getTrump(map, Enchantment.DAMAGE_ARTHROPODS, Enchantment.DAMAGE_ALL);
            int n = this.getLevel(map, enchantment);
            String string3 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string3 != null) {
                stringBuilder.replace(stringBuilder.length() - 5, stringBuilder.length(), string3);
            }
            enchantment = map.containsKey(Enchantment.FIRE_ASPECT) ? Enchantment.FIRE_ASPECT : Enchantment.DURABILITY;
            n = this.getLevel(map, enchantment);
            string3 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string3 != null) {
                stringBuilder.insert(0, ' ');
                stringBuilder.insert(0, string3);
            }
            enchantment = Enchantment.LOOT_BONUS_MOBS;
            n = this.getLevel(map, enchantment);
            string3 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string3 != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string3);
            }
            enchantment = this.getTrump(map, Enchantment.KNOCKBACK, Enchantment.DAMAGE_UNDEAD);
            n = this.getLevel(map, enchantment);
            string3 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string3 != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string3);
            }
        } else if (AXE_MATERIAL_SET.contains(material)) {
            String string = AXE;
            Enchantment enchantment = this.getTrump(map, Enchantment.DAMAGE_ARTHROPODS, Enchantment.DAMAGE_ALL);
            int n = this.getLevel(map, enchantment);
            String string4 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string4 != null) {
                stringBuilder.replace(stringBuilder.length() - 3, stringBuilder.length(), string4);
            }
            enchantment = map.containsKey(Enchantment.FIRE_ASPECT) ? Enchantment.FIRE_ASPECT : Enchantment.DURABILITY;
            n = this.getLevel(map, enchantment);
            string4 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string4 != null) {
                stringBuilder.insert(0, ' ');
                stringBuilder.insert(0, string4);
            }
            enchantment = Enchantment.LOOT_BONUS_MOBS;
            n = this.getLevel(map, enchantment);
            string4 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string4 != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string4);
            }
            enchantment = this.getTrump(map, Enchantment.KNOCKBACK, Enchantment.DAMAGE_UNDEAD);
            n = this.getLevel(map, enchantment);
            string4 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string4 != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string4);
            }
        } else if (PICKAXE_MATERIAL_SET.contains(material)) {
            String string = PICKAXE;
            Enchantment enchantment = Enchantment.DIG_SPEED;
            int n = this.getLevel(map, enchantment);
            String string5 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string5 != null) {
                stringBuilder.replace(stringBuilder.length() - 7, stringBuilder.length(), string5);
            }
            enchantment = Enchantment.DURABILITY;
            n = this.getLevel(map, enchantment);
            string5 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string5 != null) {
                stringBuilder.insert(0, ' ');
                stringBuilder.insert(0, string5);
            }
        } else if (SPADE_MATERIAL_SET.contains(material)) {
            String string = SPADE;
            Enchantment enchantment = Enchantment.DIG_SPEED;
            int n = this.getLevel(map, enchantment);
            String string6 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string6 != null) {
                stringBuilder.replace(stringBuilder.length() - 5, stringBuilder.length(), string6);
            }
            enchantment = Enchantment.DURABILITY;
            n = this.getLevel(map, enchantment);
            string6 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string6 != null) {
                stringBuilder.insert(0, ' ');
                stringBuilder.insert(0, string6);
            }
        } else if (HOE_MATERIAL_SET.contains(material)) {
            String string = HOE;
            Enchantment enchantment = Enchantment.DURABILITY;
            int n = this.getLevel(map, enchantment);
            String string7 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string7 != null) {
                stringBuilder.insert(0, ' ');
                stringBuilder.insert(0, string7);
            }
        } else if (material == Material.BOW) {
            String string = BOW;
            Enchantment enchantment = Enchantment.ARROW_DAMAGE;
            int n = this.getLevel(map, enchantment);
            String string8 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string8 != null) {
                stringBuilder.replace(0, 3, string8);
            }
            enchantment = Enchantment.DURABILITY;
            n = this.getLevel(map, enchantment);
            string8 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string8 != null) {
                stringBuilder.insert(0, ' ');
                stringBuilder.insert(0, string8);
            }
            enchantment = Enchantment.ARROW_FIRE;
            n = this.getLevel(map, enchantment);
            string8 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string8 != null) {
                stringBuilder.insert(0, ' ');
                stringBuilder.insert(0, string8);
            }
            enchantment = Enchantment.ARROW_INFINITE;
            n = this.getLevel(map, enchantment);
            string8 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string8 != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string8);
            }
            enchantment = Enchantment.ARROW_KNOCKBACK;
            n = this.getLevel(map, enchantment);
            string8 = loreConfig.getString(string + '.' + enchantment.getName() + '.' + n);
            if (string8 != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string8);
            }
        }
    }

    private void getTieredName(ItemStack itemStack, StringBuilder stringBuilder) {
        int n = tiersConfig.getInt("BaseValues." + itemStack.getType().name());
        Map map = itemStack.getEnchantments();
        for (Object object : map.keySet()) {
            n += tiersConfig.getInt("EnchantmentValues." + object.getName() + DIVIDER + map.get(object));
        }
        for (Object object : tiersConfig.getConfigurationSection(TIERS).getKeys(false)) {
            if (n <= Integer.parseInt((String)object)) continue;
            String string = tiersConfig.getString("TIERS." + (String)object + ".Prefix");
            if (string.startsWith("\u00c2")) {
                string = string.substring(1);
            }
            stringBuilder.insert(0, string);
            stringBuilder.append(tiersConfig.getString("TIERS." + (String)object + ".Suffix"));
            break;
        }
        if (n > tierNotify) {
            PhatLoots.logger.info(stringBuilder.toString() + " [Tier " + n + "] has been generated");
        }
    }

    private int getBaseDamage(Material material) {
        switch (material) {
            case WOOD_SPADE: {
                return 1;
            }
            case WOOD_PICKAXE: {
                return 2;
            }
            case WOOD_AXE: {
                return 3;
            }
            case WOOD_SWORD: {
                return 4;
            }
            case GOLD_SPADE: {
                return 1;
            }
            case GOLD_PICKAXE: {
                return 2;
            }
            case GOLD_AXE: {
                return 3;
            }
            case GOLD_SWORD: {
                return 4;
            }
            case STONE_SPADE: {
                return 2;
            }
            case STONE_PICKAXE: {
                return 3;
            }
            case STONE_AXE: {
                return 4;
            }
            case STONE_SWORD: {
                return 5;
            }
            case IRON_SPADE: {
                return 3;
            }
            case IRON_PICKAXE: {
                return 4;
            }
            case IRON_AXE: {
                return 5;
            }
            case IRON_SWORD: {
                return 6;
            }
            case DIAMOND_SPADE: {
                return 4;
            }
            case DIAMOND_PICKAXE: {
                return 5;
            }
            case DIAMOND_AXE: {
                return 6;
            }
            case DIAMOND_SWORD: {
                return 7;
            }
        }
        return 1;
    }

    private int getBaseArmor(Material material) {
        switch (material) {
            case LEATHER_BOOTS: {
                return 1;
            }
            case LEATHER_LEGGINGS: {
                return 2;
            }
            case LEATHER_CHESTPLATE: {
                return 3;
            }
            case LEATHER_HELMET: {
                return 1;
            }
            case GOLD_BOOTS: {
                return 1;
            }
            case GOLD_LEGGINGS: {
                return 3;
            }
            case GOLD_CHESTPLATE: {
                return 5;
            }
            case GOLD_HELMET: {
                return 1;
            }
            case CHAINMAIL_BOOTS: {
                return 2;
            }
            case CHAINMAIL_LEGGINGS: {
                return 4;
            }
            case CHAINMAIL_CHESTPLATE: {
                return 5;
            }
            case CHAINMAIL_HELMET: {
                return 1;
            }
            case IRON_BOOTS: {
                return 2;
            }
            case IRON_LEGGINGS: {
                return 5;
            }
            case IRON_CHESTPLATE: {
                return 6;
            }
            case IRON_HELMET: {
                return 2;
            }
            case DIAMOND_BOOTS: {
                return 3;
            }
            case DIAMOND_LEGGINGS: {
                return 6;
            }
            case DIAMOND_CHESTPLATE: {
                return 8;
            }
            case DIAMOND_HELMET: {
                return 3;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.item.getAmount();
        stringBuilder.append(n);
        if (this.amountBonus > 0) {
            stringBuilder.append('-');
            stringBuilder.append(n + this.amountBonus);
        }
        stringBuilder.append(" of ");
        if (this.tieredName) {
            stringBuilder.append("tiered ");
        }
        stringBuilder.append(PhatLootsUtil.getItemName(this.item));
        stringBuilder.append(" @ ");
        stringBuilder.append(Math.floor(this.probability) == this.probability ? String.valueOf((int)this.probability) : String.valueOf(this.probability));
        stringBuilder.append("%");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Item)) {
            return false;
        }
        Item item = (Item)object;
        return item.item.equals((Object)this.item) && item.amountBonus == this.amountBonus && item.durabilityBonus == this.durabilityBonus && item.autoEnchant == this.autoEnchant && item.generateName == this.generateName && item.randomLore == this.randomLore && item.tieredName == this.tieredName;
    }

    public int hashCode() {
        int n = 7;
        n = 37 * n + (this.item != null ? this.item.hashCode() : 0);
        n = 37 * n + this.amountBonus;
        n = 37 * n + this.durabilityBonus;
        n = 37 * n + (int)(Double.doubleToLongBits(this.probability) ^ Double.doubleToLongBits(this.probability) >>> 32);
        n = 37 * n + (this.autoEnchant ? 1 : 0);
        n = 37 * n + (this.generateName ? 1 : 0);
        n = 37 * n + (this.randomLore ? 1 : 0);
        n = 37 * n + (this.tieredName ? 1 : 0);
        return n;
    }

    private Enchantment getTrump(Map<Enchantment, Integer> map, Enchantment ... enchantmentArray) {
        int n = -1;
        Enchantment enchantment = null;
        for (Enchantment enchantment2 : enchantmentArray) {
            int n2 = this.getLevel(map, enchantment2);
            if (n2 <= n) continue;
            enchantment = enchantment2;
            n = n2;
        }
        return enchantment;
    }

    private int getLevel(Map<Enchantment, Integer> map, Enchantment enchantment) {
        Integer n = map.get(enchantment);
        return n == null ? 0 : n;
    }

    public Map<String, Object> serialize() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Probability", this.probability);
        treeMap.put("ItemStack", this.item);
        if (this.amountBonus > 0) {
            treeMap.put("BonusAmount", this.amountBonus);
        }
        if (this.durabilityBonus > 0) {
            treeMap.put("BonusDurability", this.durabilityBonus);
        }
        if (this.autoEnchant) {
            treeMap.put("AutoEnchant", this.autoEnchant);
        }
        if (this.generateName) {
            treeMap.put("GenerateName", this.generateName);
        }
        if (this.randomLore) {
            treeMap.put("RandomLore", this.randomLore);
        }
        if (this.tieredName) {
            treeMap.put("Tiered", this.tieredName);
        }
        return treeMap;
    }
}

