/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.loot;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import com.codisimus.plugins.phatloots.gui.Tool;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootBundle;
import com.tealcube.minecraft.bukkit.mythicdrops.MythicDropsPlugin;
import com.tealcube.minecraft.bukkit.mythicdrops.api.socketting.GemType;
import com.tealcube.minecraft.bukkit.mythicdrops.socketting.SocketGem;
import com.tealcube.minecraft.bukkit.mythicdrops.socketting.SocketItem;
import com.tealcube.minecraft.bukkit.mythicdrops.utils.SocketGemUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@SerializableAs(value="Gem")
public class Gem
extends Loot {
    private static final String RANDOM_GEM = "RANDOM";
    private static EnumMap<GemType, ArrayList<String>> gemLists = null;
    public GemType gemType = GemType.ANY;
    public String gemName;
    public int amountLower = 1;
    public int amountUpper = 1;

    public Gem() {
        this.gemName = RANDOM_GEM;
    }

    public Gem(String string) {
        this.gemName = string;
    }

    public Gem(String string, int n, int n2) {
        this.gemName = string;
        this.amountLower = n;
        this.amountUpper = n2;
    }

    public Gem(Map<String, Object> map) {
        String string = null;
        try {
            string = "Probability";
            Object object = map.get("Probability");
            this.setProbability(object instanceof Double ? (Double)object : (double)((Integer)object).intValue());
            string = "Name";
            this.gemName = (String)map.get("Name");
            string = "Type";
            this.gemType = GemType.valueOf((String)((String)map.get("Type")));
            string = "Amount";
            if (map.containsKey("Amount")) {
                this.amountLower = this.amountUpper = ((Integer)map.get(string)).intValue();
            } else {
                string = "AmountLower";
                if (map.containsKey("AmountLower")) {
                    this.amountLower = (Integer)map.get(string);
                    string = "AmountUpper";
                    this.amountUpper = (Integer)map.get("AmountUpper");
                }
            }
        }
        catch (Exception exception) {
            PhatLoots.logger.severe("Failed to load Gem line: " + string);
            PhatLoots.logger.severe("of PhatLoot: " + (PhatLoot.current == null ? "unknown" : PhatLoot.current));
            PhatLoots.logger.severe("Last successfull load was...");
            PhatLoots.logger.severe("PhatLoot: " + (PhatLoot.last == null ? "unknown" : PhatLoot.last));
            PhatLoots.logger.severe("Loot: " + (Loot.last == null ? "unknown" : Loot.last.toString()));
        }
    }

    @Override
    public void getLoot(LootBundle lootBundle, double d) {
        for (int i = PhatLootsUtil.rollForInt(this.amountLower, this.amountUpper); i > 0; --i) {
            Object object;
            Object object2;
            SocketGem socketGem;
            if (this.gemName.equalsIgnoreCase(RANDOM_GEM)) {
                switch (this.gemType) {
                    case ANY: {
                        socketGem = SocketGemUtil.getRandomSocketGemWithChance();
                        break;
                    }
                    default: {
                        Gem.instantiateGemLists();
                        object2 = gemLists.get(this.gemType);
                        object = (String)((ArrayList)object2).get(PhatLootsUtil.rollForInt(1, ((ArrayList)object2).size() - 1));
                        socketGem = SocketGemUtil.getSocketGemFromName((String)object);
                        break;
                    }
                }
            } else {
                socketGem = SocketGemUtil.getSocketGemFromName((String)this.gemName);
            }
            if (socketGem == null) continue;
            object2 = SocketGemUtil.getRandomSocketGemMaterial();
            object = new SocketItem((Material)object2, socketGem);
            lootBundle.addItem((ItemStack)object);
        }
    }

    @Override
    public ItemStack getInfoStack() {
        ItemStack itemStack = new ItemStack(Material.DIAMOND);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72Gem");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.gemName.equalsIgnoreCase(RANDOM_GEM)) {
            arrayList.addAll(SocketGemUtil.getSocketGemFromName((String)this.gemName).getLore());
            arrayList.add("\u00a71-----------------------------");
        }
        arrayList.add("\u00a71Name: \u00a76" + this.gemName);
        arrayList.add("\u00a71Probability: \u00a76" + this.getProbability());
        if (this.amountLower == this.amountUpper) {
            arrayList.add("\u00a71Amount: \u00a76" + this.amountLower);
        } else {
            arrayList.add("\u00a71Amount: \u00a76" + this.amountLower + '-' + this.amountUpper);
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public boolean onToggle(ClickType clickType) {
        int n;
        switch (clickType) {
            case SHIFT_LEFT: {
                n = this.gemType.ordinal() + 1;
                if (n < GemType.values().length) break;
                n = 0;
                break;
            }
            case SHIFT_RIGHT: {
                n = this.gemType.ordinal() - 1;
                if (n >= 0) break;
                n = GemType.values().length - 1;
                break;
            }
            case MIDDLE: {
                n = 0;
                break;
            }
            default: {
                return false;
            }
        }
        this.gemType = GemType.values()[n];
        ArrayList<String> arrayList = gemLists.get(this.gemType);
        if (!arrayList.contains(this.gemName)) {
            this.gemName = RANDOM_GEM;
        }
        return false;
    }

    @Override
    public boolean onToolClick(Tool tool, ClickType clickType) {
        if (!tool.getName().equals("MYTHICDROPS")) {
            return false;
        }
        Gem.instantiateGemLists();
        ArrayList<String> arrayList = gemLists.get(this.gemType);
        int n = arrayList.indexOf(this.gemName);
        switch (clickType) {
            case LEFT: {
                ++n;
                break;
            }
            case DOUBLE_CLICK: {
                n += 9;
                break;
            }
            case RIGHT: {
                --n;
                break;
            }
            case SHIFT_LEFT: {
                n += 100;
                break;
            }
            case SHIFT_RIGHT: {
                n -= 100;
                break;
            }
            case MIDDLE: {
                n = 0;
                break;
            }
            default: {
                return false;
            }
        }
        while (n >= arrayList.size()) {
            n -= arrayList.size();
        }
        while (n < 0) {
            n += arrayList.size();
        }
        this.gemName = arrayList.get(n);
        return true;
    }

    private static void instantiateGemLists() {
        if (gemLists == null) {
            gemLists = new EnumMap(GemType.class);
            for (GemType[] gemTypeArray : MythicDropsPlugin.getInstance().getSockettingSettings().getSocketGemMap().values()) {
                GemType gemType = gemTypeArray.getGemType();
                if (gemLists.get(gemType) == null) {
                    gemLists.put(gemType, new ArrayList());
                }
                ArrayList<String> arrayList = gemLists.get(gemType);
                arrayList.add(gemTypeArray.getName());
            }
            if (gemLists.get(GemType.ANY) == null) {
                gemLists.put(GemType.ANY, new ArrayList());
            }
            ArrayList<String> arrayList = gemLists.get(GemType.ANY);
            for (GemType gemType : GemType.values()) {
                if (gemType == GemType.ANY) continue;
                arrayList.addAll((Collection)gemLists.get(gemType));
            }
            for (GemType gemType : GemType.values()) {
                ArrayList<String> arrayList2 = gemLists.get(gemType);
                Collections.sort(arrayList2);
                arrayList2.add(0, RANDOM_GEM);
            }
        }
    }

    @Override
    public boolean modifyAmount(int n, boolean bl) {
        if (bl) {
            this.amountLower += n;
            if (this.amountLower < 0) {
                this.amountLower = 0;
            }
        }
        this.amountUpper += n;
        if (this.amountUpper < this.amountLower) {
            this.amountUpper = this.amountLower;
        }
        return true;
    }

    @Override
    public boolean resetAmount() {
        this.amountLower = 1;
        this.amountUpper = 1;
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.amountLower);
        if (this.amountLower != this.amountUpper) {
            stringBuilder.append('-');
            stringBuilder.append(this.amountUpper);
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.gemName);
        stringBuilder.append(" (Gem) ");
        stringBuilder.append(" @ ");
        stringBuilder.append(Math.floor(this.getProbability()) == this.getProbability() ? String.valueOf((int)this.getProbability()) : String.valueOf(this.getProbability()));
        stringBuilder.append("%");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Gem)) {
            return false;
        }
        Gem gem = (Gem)object;
        return gem.gemName.equals(this.gemName) && gem.amountLower == this.amountLower && gem.amountUpper == this.amountUpper;
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + Objects.hashCode(this.gemName);
        n = 31 * n + this.amountLower;
        n = 31 * n + this.amountUpper;
        return n;
    }

    public Map<String, Object> serialize() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Probability", this.getProbability());
        treeMap.put("Name", this.gemName);
        treeMap.put("Type", this.gemType.name());
        if (this.amountLower == this.amountUpper) {
            if (this.amountLower != 1) {
                treeMap.put("Amount", this.amountLower);
            }
        } else {
            treeMap.put("AmountLower", this.amountLower);
            treeMap.put("AmountUpper", this.amountUpper);
        }
        return treeMap;
    }

    static {
        Gem.instantiateGemLists();
    }
}

