/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.loot;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import com.codisimus.plugins.phatloots.gui.Button;
import com.codisimus.plugins.phatloots.gui.InventoryListener;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@SerializableAs(value="Experience")
public class Experience
extends Loot {
    private int lowerAmount;
    private int upperAmount;

    public static void registerButton() {
        ItemStack itemStack = new ItemStack(Material.EXP_BOTTLE);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72Add experience...");
        itemStack.setItemMeta(itemMeta);
        InventoryListener.registerButton(new AddExperienceButton(itemStack));
    }

    public Experience(int n, int n2) {
        this.lowerAmount = n;
        this.upperAmount = n2;
    }

    public Experience(Map<String, Object> map) {
        String string = null;
        try {
            string = "Probability";
            this.probability = (Double)map.get("Probability");
            string = "Lower";
            this.lowerAmount = (Integer)map.get("Lower");
            string = "Upper";
            this.upperAmount = (Integer)map.get("Upper");
        }
        catch (Exception exception) {
            PhatLoots.logger.severe("Failed to load Experience line: " + string);
            PhatLoots.logger.severe("of PhatLoot: " + (PhatLoot.current == null ? "unknown" : PhatLoot.current));
            PhatLoots.logger.severe("Last successfull load was...");
            PhatLoots.logger.severe("PhatLoot: " + (PhatLoot.last == null ? "unknown" : PhatLoot.last));
            PhatLoots.logger.severe("Loot: " + (Loot.last == null ? "unknown" : Loot.last.toString()));
        }
    }

    @Override
    public void getLoot(LootBundle lootBundle, double d) {
        lootBundle.addExp(PhatLootsUtil.rollForInt(this.lowerAmount, this.upperAmount));
    }

    @Override
    public ItemStack getInfoStack() {
        ItemStack itemStack = new ItemStack(Material.EXP_BOTTLE);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72Experience");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u00a74Probability: \u00a76" + this.probability);
        arrayList.add("\u00a74Lower Bound: \u00a76" + this.lowerAmount);
        arrayList.add("\u00a74Upper Bound: \u00a76" + this.upperAmount);
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public boolean onToggle(ClickType clickType) {
        return false;
    }

    @Override
    public boolean modifyAmount(int n, boolean bl) {
        if (bl) {
            this.lowerAmount += n;
        }
        this.upperAmount += n;
        if (n < 0) {
            if (this.upperAmount < 0) {
                this.resetAmount();
            } else if (this.lowerAmount < 0) {
                this.lowerAmount = 0;
            }
        }
        return true;
    }

    @Override
    public boolean resetAmount() {
        this.lowerAmount = 0;
        this.upperAmount = 0;
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.lowerAmount);
        if (this.lowerAmount != this.upperAmount) {
            stringBuilder.append("-");
            stringBuilder.append(this.upperAmount);
        }
        stringBuilder.append(" experience");
        stringBuilder.append(" @ ");
        stringBuilder.append(String.valueOf(Math.floor(this.probability) == this.probability ? (double)((int)this.probability) : this.probability));
        stringBuilder.append("%");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Experience) {
            Experience experience = (Experience)object;
            return experience.lowerAmount == this.lowerAmount && experience.upperAmount == this.upperAmount;
        }
        return false;
    }

    public int hashCode() {
        int n = 3;
        n = 47 * n + this.lowerAmount;
        n = 47 * n + this.upperAmount;
        return n;
    }

    public Map<String, Object> serialize() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Probability", this.probability);
        treeMap.put("Lower", this.lowerAmount);
        treeMap.put("Upper", this.upperAmount);
        return treeMap;
    }

    private static class AddExperienceButton
    extends Button {
        private AddExperienceButton(ItemStack itemStack) {
            super(itemStack);
        }

        @Override
        public boolean onClick(ClickType clickType, Inventory inventory, PhatLoot phatLoot, List<Loot> list) {
            list.add(new Experience(0, 0));
            return true;
        }
    }
}

