/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.loot;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsCommandSender;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootBundle;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@SerializableAs(value="Command")
public class CommandLoot
extends Loot {
    private static PhatLootsCommandSender cs = new PhatLootsCommandSender();
    public String command;
    public boolean fromConsole;
    public boolean tempOP;

    public CommandLoot(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.startsWith("sudo ")) {
            this.fromConsole = false;
            this.tempOP = true;
            this.command = string.substring(5);
        } else {
            this.fromConsole = true;
            this.command = string;
        }
    }

    public CommandLoot(Map<String, Object> map) {
        String string = null;
        try {
            string = "Probability";
            this.probability = (Double)map.get("Probability");
            string = "Command";
            this.command = (String)map.get("Command");
            string = "FromConsole";
            this.fromConsole = (Boolean)map.get("FromConsole");
            string = "TempOP";
            this.tempOP = (Boolean)map.get("TempOP");
        }
        catch (Exception exception) {
            PhatLoots.logger.severe("Failed to load CommandLoot line: " + string);
            PhatLoots.logger.severe("of PhatLoot: " + (PhatLoot.current == null ? "unknown" : PhatLoot.current));
            PhatLoots.logger.severe("Last successfull load was...");
            PhatLoots.logger.severe("PhatLoot: " + (PhatLoot.last == null ? "unknown" : PhatLoot.last));
            PhatLoots.logger.severe("Loot: " + (Loot.last == null ? "unknown" : Loot.last.toString()));
        }
    }

    @Override
    public void getLoot(LootBundle lootBundle, double d) {
        lootBundle.addCommand(this);
    }

    public void execute(Player player) {
        String string = this.command;
        if (player == null) {
            if (!this.fromConsole || this.command.contains("<player>") || this.command.contains("<killer>")) {
                return;
            }
        } else {
            string = string.replace("<player>", player.getName());
            if (this.command.contains("<killer>")) {
                Player player2 = player.getKiller();
                if (player2 == null) {
                    return;
                }
                string = string.replace("<killer>", player2.getName());
            }
        }
        if (this.fromConsole) {
            Bukkit.dispatchCommand((CommandSender)cs, (String)string);
        } else if (this.tempOP) {
            player.setOp(true);
            Bukkit.dispatchCommand((CommandSender)player, (String)string);
            player.setOp(false);
        } else {
            Bukkit.dispatchCommand((CommandSender)player, (String)string);
        }
    }

    @Override
    public ItemStack getInfoStack() {
        ItemStack itemStack = new ItemStack(Material.COMMAND);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72Command");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u00a74Probability: \u00a76" + this.probability);
        arrayList.add("\u00a74Command: \u00a76" + this.command);
        arrayList.add(this.fromConsole ? "\u00a76From Console" : "\u00a76From Player");
        if (this.tempOP) {
            arrayList.add("\u00a76Player is temporarily OPed");
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public boolean onToggle(ClickType clickType) {
        switch (clickType) {
            case SHIFT_LEFT: {
                this.fromConsole = !this.fromConsole;
                break;
            }
            case SHIFT_RIGHT: {
                this.tempOP = !this.tempOP;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean modifyAmount(int n, boolean bl) {
        return false;
    }

    @Override
    public boolean resetAmount() {
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/");
        if (!this.fromConsole) {
            stringBuilder.append("sudo ");
        }
        stringBuilder.append("command @ ");
        stringBuilder.append(String.valueOf(Math.floor(this.probability) == this.probability ? (double)((int)this.probability) : this.probability));
        stringBuilder.append("%");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof CommandLoot) {
            CommandLoot commandLoot = (CommandLoot)object;
            return commandLoot.fromConsole == this.fromConsole && commandLoot.tempOP == this.tempOP && commandLoot.command.equals(this.command);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 37 * n + (this.command != null ? this.command.hashCode() : 0);
        n = 37 * n + (this.fromConsole ? 1 : 0);
        n = 37 * n + (this.tempOP ? 1 : 0);
        return n;
    }

    public Map<String, Object> serialize() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Probability", this.probability);
        treeMap.put("Command", this.command);
        treeMap.put("FromConsole", this.fromConsole);
        treeMap.put("TempOP", this.tempOP);
        return treeMap;
    }
}

