/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.listeners;

import com.codisimus.plugins.phatloots.ForgettableInventory;
import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLootChest;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsAPI;
import com.codisimus.plugins.phatloots.PhatLootsConfig;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class PhatLootsListener
implements Listener {
    public static boolean autoBreakOnPunch;

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        if (!playerInteractEvent.hasBlock()) {
            return;
        }
        boolean bl = false;
        switch (playerInteractEvent.getAction()) {
            case RIGHT_CLICK_BLOCK: {
                break;
            }
            case LEFT_CLICK_BLOCK: {
                if (playerInteractEvent.getClickedBlock().getType() == Material.DISPENSER) break;
                if (autoBreakOnPunch) {
                    bl = true;
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        Player player = playerInteractEvent.getPlayer();
        boolean bl2 = PhatLootsAPI.loot(playerInteractEvent.getClickedBlock(), player, bl);
        if (bl2) {
            playerInteractEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCloseChest(InventoryCloseEvent inventoryCloseEvent) {
        Player player;
        HumanEntity humanEntity = inventoryCloseEvent.getPlayer();
        if (humanEntity instanceof Player && PhatLootChest.openPhatLootChests.containsKey((player = (Player)humanEntity).getUniqueId())) {
            PhatLootChest phatLootChest = PhatLootChest.openPhatLootChests.get(player.getUniqueId());
            boolean bl = ForgettableInventory.has("global@" + phatLootChest.toString());
            phatLootChest.closeInventory(player, inventoryCloseEvent.getInventory(), bl);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        Block block = blockBreakEvent.getBlock();
        if (!PhatLootsUtil.isLinkableType(block)) {
            return;
        }
        if (!PhatLootChest.isPhatLootChest(block)) {
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        if (player == null) {
            blockBreakEvent.setCancelled(true);
            return;
        }
        if (!player.hasPermission("phatloots.admin")) {
            player.sendMessage(PhatLootsConfig.permission);
            blockBreakEvent.setCancelled(true);
            return;
        }
        for (PhatLoot phatLoot : PhatLoots.getPhatLoots(block)) {
            phatLoot.removeChest(block);
            player.sendMessage("\u00a75Broken \u00a76" + block.getType().toString() + "\u00a75 has been unlinked from PhatLoot \u00a76" + phatLoot.name);
            phatLoot.saveChests();
        }
    }
}

