/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.gui;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Tool {
    private static final ArrayList<Tool> tools = new ArrayList();
    private final int id = tools.size();
    private final String name;
    private final ItemStack item;

    public Tool(String string, ItemStack itemStack) {
        this.name = string;
        this.item = itemStack;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Tool prevTool() {
        int n = this.id - 1;
        if (n < 0) {
            n = tools.size() - 1;
        }
        return Tool.getToolByID(n);
    }

    public Tool nextTool() {
        int n = this.id + 1;
        if (n >= tools.size()) {
            n = 0;
        }
        return Tool.getToolByID(n);
    }

    public void registerTool() {
        tools.add(this);
    }

    public static Tool getToolByID(int n) {
        return n >= tools.size() ? null : tools.get(n);
    }

    public static Tool getToolByName(String string) {
        for (Tool tool : tools) {
            if (!tool.name.equals(string)) continue;
            return tool;
        }
        return null;
    }

    public static Tool getTool(ItemStack itemStack) {
        Material material = itemStack.getType();
        for (Tool tool : tools) {
            if (tool.item.getType() != material) continue;
            return tool;
        }
        return null;
    }

    static {
        ItemStack itemStack = new ItemStack(Material.LEASH);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        ArrayList<String> arrayList = new ArrayList<String>();
        itemMeta.setDisplayName("\u00a72Navigate/Move (Click to change Tool)");
        arrayList.add("\u00a74LEFT CLICK:");
        arrayList.add("\u00a76 Enter a Collection");
        arrayList.add("\u00a74RIGHT CLICK:");
        arrayList.add("\u00a76 Leave a Collection");
        arrayList.add("\u00a74SHIFT + LEFT CLICK:");
        arrayList.add("\u00a76 Picks up a Collection");
        arrayList.add("\u00a76 Shift a Loot to the Left");
        arrayList.add("\u00a74SHIFT + RIGHT CLICK:");
        arrayList.add("\u00a76 Shift a Loot to the Right");
        arrayList.add("\u00a74SCROLL CLICK:");
        arrayList.add("\u00a76 Remove a Loot/Add an Item (from inventory)");
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        new Tool("NAVIGATE_AND_MOVE", itemStack).registerTool();
        itemStack = new ItemStack(Material.NAME_TAG);
        itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        arrayList.clear();
        itemMeta.setDisplayName("\u00a72Modify Probability/Toggle (Click to change Tool)");
        arrayList.add("\u00a74LEFT CLICK:");
        arrayList.add("\u00a76 +1 Probability");
        arrayList.add("\u00a74DOUBLE LEFT CLICK:");
        arrayList.add("\u00a76 +10 Probability");
        arrayList.add("\u00a74RIGHT CLICK:");
        arrayList.add("\u00a76 -1 Probability");
        arrayList.add("\u00a74SHIFT + LEFT CLICK:");
        arrayList.add("\u00a76 Toggle AutoEnchant/FromConsole");
        arrayList.add("\u00a74SHIFT + RIGHT CLICK:");
        arrayList.add("\u00a76 Toggle GenerateName/TempOP");
        arrayList.add("\u00a74SCROLL CLICK:");
        arrayList.add("\u00a76 Toggle TieredName and Loot table settings");
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        new Tool("MODIFY_PROBABILITY_AND_TOGGLE", itemStack).registerTool();
        itemStack = new ItemStack(Material.GOLD_NUGGET);
        itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        arrayList.clear();
        itemMeta.setDisplayName("\u00a72Modify Amount (Click to change Tool)");
        arrayList.add("\u00a74LEFT CLICK:");
        arrayList.add("\u00a76 +1 Amount");
        arrayList.add("\u00a74DOUBLE LEFT CLICK:");
        arrayList.add("\u00a76 +10 Amount");
        arrayList.add("\u00a74RIGHT CLICK:");
        arrayList.add("\u00a76 -1 Amount");
        arrayList.add("\u00a74SHIFT + LEFT CLICK:");
        arrayList.add("\u00a76 +1 Amount (Upper Range)");
        arrayList.add("\u00a74SHIFT + RIGHT CLICK:");
        arrayList.add("\u00a76 -1 Amount (Upper Range)");
        arrayList.add("\u00a74SCROLL CLICK:");
        arrayList.add("\u00a76 Set Amount to 1 and Clear time/exp/money");
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        new Tool("MODIFY_AMOUNT", itemStack).registerTool();
    }
}

