/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.gui;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.gui.Button;
import com.codisimus.plugins.phatloots.gui.Tool;
import com.codisimus.plugins.phatloots.loot.Item;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InventoryListener
implements Listener {
    private static final int NAVIGATE_AND_MOVE = 0;
    private static final int MODIFY_PROBABILITY_AND_TOGGLE = 1;
    private static final int MODIFY_AMOUNT = 2;
    private static final int SIZE = 54;
    static final int TOOL_SLOT = 45;
    private static final HashMap<UUID, Boolean> switchingPages = new HashMap();
    private static final HashMap<UUID, PhatLoot> infoViewers = new HashMap();
    private static final HashMap<UUID, Stack<Inventory>> pageStacks = new HashMap();
    private static final HashMap<UUID, Loot> holding = new HashMap();
    private static final HashMap<Integer, Button> buttons = new HashMap();

    public static void registerButton(Button button) {
        buttons.put(button.getSlot(), button);
    }

    private static List<Loot> getLootList(PhatLoot phatLoot, Inventory inventory) {
        LootCollection lootCollection = null;
        String string = inventory.getName();
        if (string.endsWith(" (Collection)")) {
            lootCollection = phatLoot.findCollection(string.substring(0, string.length() - 13));
        }
        return lootCollection == null ? phatLoot.lootList : lootCollection.getLootList();
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInvClick(InventoryClickEvent inventoryClickEvent) {
        Object object;
        Loot loot;
        HumanEntity humanEntity = inventoryClickEvent.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID uUID = player.getUniqueId();
        if (!infoViewers.containsKey(uUID)) {
            return;
        }
        if (!inventoryClickEvent.getInventory().getTitle().contains("Loot") && !inventoryClickEvent.getInventory().getTitle().contains("Collection")) {
            infoViewers.remove(uUID).save();
            pageStacks.get(uUID).empty();
            pageStacks.remove(uUID);
            return;
        }
        inventoryClickEvent.setResult(Event.Result.DENY);
        player.updateInventory();
        PhatLoot phatLoot = infoViewers.get(uUID);
        Inventory inventory = inventoryClickEvent.getInventory();
        Tool tool = Tool.getTool(inventory.getItem(45));
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        List<Loot> list = InventoryListener.getLootList(phatLoot, inventory);
        int n = inventoryClickEvent.getRawSlot();
        Loot loot2 = loot = n >= 0 && list.size() > n ? list.get(n) : null;
        if (holding.containsKey(uUID)) {
            switch (inventoryClickEvent.getClick()) {
                case LEFT: {
                    if (loot != null) break;
                    if (n == list.size()) {
                        list.add(holding.remove(uUID));
                        inventoryClickEvent.setCurrentItem(inventoryClickEvent.getCursor());
                    } else if (n > list.size() && n < 45) {
                        list.add(holding.remove(uUID));
                        inventory.setItem(list.size() - 1, inventoryClickEvent.getCursor());
                        player.updateInventory();
                    } else {
                        if (n != -999) break;
                        holding.remove(uUID);
                    }
                    inventoryClickEvent.setCursor(null);
                    return;
                }
                case RIGHT: {
                    if (n < 45) {
                        InventoryListener.up(player);
                    }
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (n == -999 || n == 45) {
            switch (inventoryClickEvent.getClick()) {
                case LEFT: {
                    if (holding.containsKey(uUID)) break;
                    inventory.setItem(45, tool.prevTool().getItem());
                    player.updateInventory();
                    break;
                }
                case RIGHT: {
                    inventory.setItem(45, tool.nextTool().getItem());
                    player.updateInventory();
                    break;
                }
            }
            return;
        }
        if (itemStack.getType() == Material.LADDER && (object = itemStack.getItemMeta()).hasDisplayName()) {
            String string;
            switch (string = itemStack.getItemMeta().getDisplayName()) {
                case "\u00a72Up to...": {
                    InventoryListener.up(player);
                    return;
                }
                case "\u00a72Back to top...": {
                    InventoryListener.viewPhatLoot(player, phatLoot);
                    return;
                }
            }
        }
        if (buttons.containsKey(n)) {
            if (buttons.get(n).onClick(inventoryClickEvent.getClick(), inventory, phatLoot, list)) {
                InventoryListener.refreshPage(player, inventory, list);
            }
            return;
        }
        if (loot == null) {
            if (tool.getID() == 0) {
                switch (inventoryClickEvent.getClick()) {
                    case LEFT: {
                        if (n < 54) break;
                        object = holding.remove(uUID);
                        if (itemStack.getType() != Material.AIR || object == null) {
                            loot = new Item(itemStack, 0);
                            holding.put(uUID, loot);
                            inventoryClickEvent.setCursor(loot.getInfoStack());
                            inventoryClickEvent.setCurrentItem(null);
                        } else {
                            inventoryClickEvent.setCursor(null);
                        }
                        if (object == null || !(object instanceof Item)) break;
                        inventoryClickEvent.setCurrentItem(((Item)object).getItem());
                        break;
                    }
                    case RIGHT: {
                        InventoryListener.up(player);
                        break;
                    }
                    case MIDDLE: {
                        if (n <= 54) break;
                        object = itemStack.clone();
                        list.add(new Item((ItemStack)object, 0));
                        InventoryListener.refreshPage(player, inventory, list);
                    }
                }
                return;
            }
            int n2 = 0;
            boolean bl = false;
            if (tool.getID() == 2) {
                switch (inventoryClickEvent.getClick()) {
                    case LEFT: {
                        n2 = 1;
                        bl = true;
                        break;
                    }
                    case DOUBLE_CLICK: {
                        n2 = 9;
                        bl = true;
                        break;
                    }
                    case RIGHT: {
                        n2 = -1;
                        bl = true;
                        break;
                    }
                    case SHIFT_LEFT: {
                        n2 = 1;
                        bl = false;
                        break;
                    }
                    case SHIFT_RIGHT: {
                        n2 = -1;
                        bl = false;
                        break;
                    }
                    case MIDDLE: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (inventory.getTitle().endsWith("Loot Tables")) {
                String string;
                ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(Material.STONE);
                ArrayList<String> arrayList = new ArrayList<String>();
                switch (n) {
                    case 51: {
                        if (tool.getID() == 2) {
                            return;
                        }
                        phatLoot.breakAndRespawn = !phatLoot.breakAndRespawn;
                        string = new ItemStack(phatLoot.breakAndRespawn ? Material.MOB_SPAWNER : Material.CHEST);
                        itemMeta.setDisplayName("\u00a74Break and Respawn: \u00a76" + phatLoot.breakAndRespawn);
                        if (phatLoot.breakAndRespawn) {
                            arrayList.add("\u00a76This chest will break after it is looted");
                            arrayList.add("\u00a76and respawn once it may be looted again.");
                            break;
                        }
                        arrayList.add("\u00a76This chest will always be present");
                        arrayList.add("\u00a76even after it is looted.");
                        break;
                    }
                    case 52: {
                        if (tool.getID() == 2) {
                            return;
                        }
                        phatLoot.autoLoot = !phatLoot.autoLoot;
                        string = new ItemStack(phatLoot.autoLoot ? Material.REDSTONE_TORCH_ON : Material.LEVER);
                        itemMeta.setDisplayName("\u00a74AutoLoot: \u00a76" + phatLoot.autoLoot);
                        break;
                    }
                    case 53: {
                        if (tool.getID() == 2) {
                            if (n2 == 0) {
                                phatLoot.days = 0;
                                phatLoot.hours = 0;
                                phatLoot.minutes = 0;
                                phatLoot.seconds = 0;
                            } else if (bl) {
                                phatLoot.hours += n2;
                            } else {
                                phatLoot.minutes += n2;
                            }
                        } else if (inventoryClickEvent.getClick() == ClickType.LEFT) {
                            phatLoot.global = !phatLoot.global;
                        } else {
                            phatLoot.round = !phatLoot.round;
                        }
                        string = new ItemStack(Material.WATCH);
                        itemMeta.setDisplayName("\u00a72Reset Time");
                        arrayList.add("\u00a74Days: \u00a76" + phatLoot.days);
                        arrayList.add("\u00a74Hours: \u00a76" + phatLoot.hours);
                        arrayList.add("\u00a74Minutes: \u00a76" + phatLoot.minutes);
                        arrayList.add("\u00a74Seconds: \u00a76" + phatLoot.seconds);
                        arrayList.add("\u00a74Reset Type: \u00a76" + (phatLoot.global ? "Global" : "Individual"));
                        if (!phatLoot.round) break;
                        arrayList.add("\u00a76Time is rounded down");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                itemMeta.setLore(arrayList);
                string.setItemMeta(itemMeta);
                inventoryClickEvent.setCurrentItem((ItemStack)string);
            }
            return;
        }
        switch (tool.getID()) {
            case 0: {
                switch (inventoryClickEvent.getClick()) {
                    case LEFT: {
                        if (loot instanceof LootCollection) {
                            if (holding.containsKey(uUID)) {
                                object = holding.remove(uUID);
                                ((LootCollection)loot).addLoot((Loot)object);
                                inventoryClickEvent.setCursor(null);
                            } else {
                                InventoryListener.viewCollection(player, ((LootCollection)loot).name);
                            }
                            return;
                        }
                        if (holding.containsKey(uUID)) {
                            object = holding.remove(uUID);
                            holding.put(uUID, list.get(n));
                            list.set(n, (Loot)object);
                            inventoryClickEvent.setCurrentItem(inventoryClickEvent.getCursor());
                            inventoryClickEvent.setCursor(itemStack);
                            break;
                        }
                        holding.put(uUID, list.remove(n));
                        inventoryClickEvent.setCursor(itemStack);
                        InventoryListener.refreshPage(player, inventory, list);
                        break;
                    }
                    case RIGHT: {
                        InventoryListener.up(player);
                        break;
                    }
                    case SHIFT_LEFT: {
                        if (loot instanceof LootCollection) {
                            if (holding.containsKey(uUID)) {
                                object = holding.remove(uUID);
                                holding.put(uUID, list.get(n));
                                list.set(n, (Loot)object);
                                inventoryClickEvent.setCurrentItem(inventoryClickEvent.getCursor());
                                inventoryClickEvent.setCursor(itemStack);
                                break;
                            }
                            holding.put(uUID, list.remove(n));
                            inventoryClickEvent.setCursor(itemStack);
                            InventoryListener.refreshPage(player, inventory, list);
                            break;
                        }
                        if (n <= 0) break;
                        list.set(n, list.get(n - 1));
                        list.set(n - 1, loot);
                        InventoryListener.refreshPage(player, inventory, list);
                        break;
                    }
                    case SHIFT_RIGHT: {
                        if (n >= list.size() - 1) break;
                        list.set(n, list.get(n + 1));
                        list.set(n + 1, loot);
                        InventoryListener.refreshPage(player, inventory, list);
                        break;
                    }
                    case MIDDLE: {
                        list.remove(n);
                        InventoryListener.refreshPage(player, inventory, list);
                    }
                }
                break;
            }
            case 1: {
                switch (inventoryClickEvent.getClick()) {
                    case DOUBLE_CLICK: {
                        loot.setProbability(loot.getProbability() + 8.0);
                    }
                    case LEFT: {
                        loot.setProbability(loot.getProbability() + 1.0);
                        while (loot.getProbability() > 100.0) {
                            loot.setProbability(loot.getProbability() - 100.0);
                        }
                        break;
                    }
                    case RIGHT: {
                        loot.setProbability(loot.getProbability() - 1.0);
                        while (loot.getProbability() < 0.0) {
                            loot.setProbability(loot.getProbability() + 100.0);
                        }
                        break;
                    }
                    default: {
                        if (loot.onToggle(inventoryClickEvent.getClick())) break;
                        return;
                    }
                }
                inventoryClickEvent.setCurrentItem(loot.getInfoStack());
                break;
            }
            case 2: {
                boolean bl;
                int n3;
                switch (inventoryClickEvent.getClick()) {
                    case LEFT: {
                        n3 = 1;
                        bl = true;
                        break;
                    }
                    case DOUBLE_CLICK: {
                        n3 = 9;
                        bl = true;
                        break;
                    }
                    case RIGHT: {
                        n3 = -1;
                        bl = true;
                        break;
                    }
                    case SHIFT_LEFT: {
                        n3 = 1;
                        bl = false;
                        break;
                    }
                    case SHIFT_RIGHT: {
                        n3 = -1;
                        bl = false;
                        break;
                    }
                    case MIDDLE: {
                        if (loot.resetAmount()) {
                            inventoryClickEvent.setCurrentItem(loot.getInfoStack());
                        }
                        return;
                    }
                    default: {
                        return;
                    }
                }
                if (!loot.modifyAmount(n3, bl)) break;
                inventoryClickEvent.setCurrentItem(loot.getInfoStack());
                break;
            }
            default: {
                if (!loot.onToolClick(tool, inventoryClickEvent.getClick())) break;
                InventoryListener.refreshPage(player, inventory, list);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCloseChest(InventoryCloseEvent inventoryCloseEvent) {
        HumanEntity humanEntity = inventoryCloseEvent.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID uUID = player.getUniqueId();
        if (!infoViewers.containsKey(uUID)) {
            return;
        }
        if (switchingPages.containsKey(uUID)) {
            if (switchingPages.get(uUID).booleanValue()) {
                pageStacks.get(uUID).add(inventoryCloseEvent.getInventory());
            }
            switchingPages.remove(uUID);
        } else {
            infoViewers.remove(uUID).save();
            pageStacks.get(uUID).empty();
            pageStacks.remove(uUID);
        }
        if (holding.containsKey(uUID)) {
            holding.remove(uUID);
            inventoryCloseEvent.getView().setCursor(null);
        }
    }

    public static void viewPhatLoot(Player player, PhatLoot phatLoot) {
        String string = phatLoot.name.length() <= 20 ? phatLoot.name + " Loot Tables" : (phatLoot.name.length() <= 32 ? phatLoot.name : phatLoot.name.substring(0, 32));
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)string);
        int n = 54;
        ItemStack itemStack = new ItemStack(Material.WATCH);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72Reset Time");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u00a74Days: \u00a76" + phatLoot.days);
        arrayList.add("\u00a74Hours: \u00a76" + phatLoot.hours);
        arrayList.add("\u00a74Minutes: \u00a76" + phatLoot.minutes);
        arrayList.add("\u00a74Seconds: \u00a76" + phatLoot.seconds);
        arrayList.add("\u00a74Reset Type: \u00a76" + (phatLoot.global ? "Global" : "Individual"));
        if (phatLoot.round) {
            arrayList.add("\u00a76Time is rounded down");
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        inventory.setItem(--n, itemStack);
        itemStack = new ItemStack(phatLoot.autoLoot ? Material.REDSTONE_TORCH_ON : Material.LEVER);
        itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a74AutoLoot: \u00a76" + phatLoot.autoLoot);
        itemStack.setItemMeta(itemMeta);
        inventory.setItem(--n, itemStack);
        itemStack = new ItemStack(phatLoot.breakAndRespawn ? Material.MOB_SPAWNER : Material.CHEST);
        itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a74Break and Respawn: \u00a76" + phatLoot.breakAndRespawn);
        arrayList = new ArrayList();
        if (phatLoot.breakAndRespawn) {
            arrayList.add("\u00a76This chest will break after it is looted");
            arrayList.add("\u00a76and respawn once it may be looted again.");
        } else {
            arrayList.add("\u00a76This chest will always be present");
            arrayList.add("\u00a76even after it is looted.");
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        inventory.setItem(--n, itemStack);
        pageStacks.put(player.getUniqueId(), new Stack());
        infoViewers.put(player.getUniqueId(), phatLoot);
        InventoryListener.switchView(player, inventory);
    }

    private static void viewCollection(Player player, String string) {
        pageStacks.get(player.getUniqueId()).add(player.getOpenInventory().getTopInventory());
        String string2 = string.length() < 20 ? string + " (Collection)" : (string.length() <= 32 ? string : string.substring(0, 32));
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)string2);
        ItemStack itemStack = new ItemStack(Material.LADDER);
        ItemMeta itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72Back to top...");
        itemStack.setItemMeta(itemMeta);
        inventory.setItem(52, itemStack);
        itemStack = new ItemStack(Material.LADDER);
        itemMeta = Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        itemMeta.setDisplayName("\u00a72Up to...");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u00a76" + pageStacks.get(player.getUniqueId()).peek().getTitle());
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        inventory.setItem(53, itemStack);
        InventoryListener.switchView(player, inventory);
    }

    private static void up(Player player) {
        Stack<Inventory> stack;
        if (!pageStacks.isEmpty() && !(stack = pageStacks.get(player.getUniqueId())).empty()) {
            InventoryListener.switchView(player, stack.pop());
        }
    }

    private static void switchView(final Player player, final Inventory inventory) {
        UUID uUID = player.getUniqueId();
        switchingPages.put(uUID, false);
        final ItemStack itemStack = player.getItemOnCursor();
        Loot loot = holding.get(uUID);
        player.closeInventory();
        if (loot != null) {
            holding.put(uUID, loot);
        }
        inventory.setItem(45, Tool.getToolByID(0).getItem());
        for (int i = 1; i <= buttons.size(); ++i) {
            int n = 45 + i;
            inventory.setItem(n, buttons.get(n).getItem());
        }
        InventoryListener.refreshPage(player, inventory, InventoryListener.getLootList(infoViewers.get(player.getUniqueId()), inventory));
        new BukkitRunnable(){

            public void run() {
                player.openInventory(inventory).setCursor(itemStack);
            }
        }.runTaskLater((Plugin)PhatLoots.plugin, 2L);
    }

    private static void refreshPage(Player player, Inventory inventory, List<Loot> list) {
        int n = 0;
        for (Loot loot : list) {
            inventory.setItem(n, loot.getInfoStack());
            if (++n < 45) continue;
            player.sendMessage("\u00a74Not all items could fit within the inventory view.");
            break;
        }
        while (n < 45) {
            inventory.clear(n);
            ++n;
        }
        player.updateInventory();
    }

    static {
        if (0 != Tool.getToolByName("NAVIGATE_AND_MOVE").getID() || 1 != Tool.getToolByName("MODIFY_PROBABILITY_AND_TOGGLE").getID() || 2 != Tool.getToolByName("MODIFY_AMOUNT").getID()) {
            PhatLoots.logger.severe("Tool IDs do not match their expected values, Please notify Codisimus!");
        }
    }
}

