/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.commands;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsConfig;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import com.codisimus.plugins.phatloots.commands.CommandHandler;
import com.codisimus.plugins.phatloots.gui.InventoryListener;
import com.codisimus.plugins.phatloots.loot.Experience;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootCollection;
import com.codisimus.plugins.phatloots.loot.Money;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LootCommand {
    public static boolean setUnlockable;

    @CommandHandler.CodCommand(command="make", weight=10.0, aliases={"create"}, usage={"\u00a72<command> <Name>\u00a7b Create PhatLoot with given name"}, permission="phatloots.make")
    public boolean make(CommandSender commandSender, String string) {
        if (PhatLoots.hasPhatLoot(string)) {
            commandSender.sendMessage("\u00a74A PhatLoot named \u00a76" + string + "\u00a74 already exists.");
        } else {
            PhatLoots.addPhatLoot(new PhatLoot(string));
            commandSender.sendMessage("\u00a75PhatLoot \u00a76" + string + "\u00a75 made!");
        }
        return true;
    }

    @CommandHandler.CodCommand(command="delete", weight=20.0, usage={"\u00a72<command> <Name>\u00a7b Delete PhatLoot"}, permission="phatloots.delete")
    public boolean delete(CommandSender commandSender, PhatLoot phatLoot) {
        PhatLoots.removePhatLoot(phatLoot);
        commandSender.sendMessage("\u00a75PhatLoot \u00a76" + phatLoot.name + "\u00a75 was deleted!");
        return true;
    }

    @CommandHandler.CodCommand(command="rename", weight=21.0, usage={"\u00a72<command> <PhatLoot> <Collection> <NewName>\u00a7b Rename a PhatLoot collection"}, permission="phatloots.make")
    public boolean rename(CommandSender commandSender, PhatLoot phatLoot, String string, String string2) {
        LootCollection lootCollection = phatLoot.findCollection(string);
        if (lootCollection == null) {
            return false;
        }
        lootCollection.name = string2;
        phatLoot.save();
        commandSender.sendMessage("\u00a75Collection renamed to \u00a76" + string);
        return true;
    }

    @CommandHandler.CodCommand(command="link", subcommand="hand", weight=30.0, usage={"\u00a72<command> <Name>\u00a7b Link Item in hand with PhatLoot"}, permission="phatloots.link")
    public boolean linkHand(Player player, PhatLoot phatLoot) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        ItemMeta itemMeta = itemStack.hasItemMeta() ? itemStack.getItemMeta() : Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        List list = itemMeta.hasLore() ? itemMeta.getLore() : new ArrayList();
        list.add(PhatLootsConfig.lootBagKey + phatLoot.name);
        itemMeta.setLore(list);
        itemStack.setItemMeta(itemMeta);
        player.sendMessage("\u00a76" + PhatLootsUtil.getItemName(itemStack) + "\u00a75 has been linked to PhatLoot \u00a76" + phatLoot.name);
        return true;
    }

    @CommandHandler.CodCommand(command="link", weight=30.1, usage={"\u00a72<command> <Name>\u00a7b Link target Block with PhatLoot"}, permission="phatloots.link")
    public boolean link(Player player, PhatLoot phatLoot) {
        Block block = player.getTargetBlock(EnumSet.of(Material.AIR), 10);
        String string = block.getType().toString();
        if (!PhatLootsUtil.isLinkableType(block)) {
            player.sendMessage("\u00a76" + string + "\u00a74 is not a linkable type.");
            return true;
        }
        switch (block.getType()) {
            case CHEST: {
                Chest chest = (Chest)block.getState();
                Inventory inventory = chest.getInventory();
                if (inventory instanceof DoubleChestInventory) {
                    chest = (Chest)((DoubleChestInventory)inventory).getLeftSide().getHolder();
                    block = chest.getBlock();
                }
            }
            case ENDER_CHEST: {
                break;
            }
        }
        phatLoot.addChest(block);
        player.sendMessage("\u00a75Target \u00a76" + string + "\u00a75 has been linked to PhatLoot \u00a76" + phatLoot.name);
        phatLoot.saveChests();
        return true;
    }

    @CommandHandler.CodCommand(command="unlink", weight=40.0, usage={"\u00a72<command> [Name]\u00a7b Unlink target Block from PhatLoot", "\u00a77If Name is not specified then all PhatLoots linked to the target Block will be affected"}, permission="phatloots.unlink")
    public boolean unlink(Player player, PhatLoot phatLoot) {
        Block block = player.getTargetBlock(EnumSet.of(Material.AIR), 10);
        phatLoot.removeChest(block);
        player.sendMessage("\u00a75Target \u00a76" + block.getType().toString() + "\u00a75 has been unlinked from PhatLoot \u00a76" + phatLoot.name);
        phatLoot.saveChests();
        return true;
    }

    @CommandHandler.CodCommand(command="unlink", weight=40.1)
    public boolean unlink(Player player) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.unlink(player, phatLoot);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="time", weight=50.0, usage={"\u00a72<command> [Name] <Days> <Hrs> <Mins> <Secs>\u00a7b Set cooldown time for PhatLoot", "\u00a72<command> [Name] never\u00a7b Set PhatLoot to only be lootable once per chest", "\u00a77If Name is not specified then all PhatLoots linked to the target Block will be affected"}, permission="phatloots.time")
    public boolean time(CommandSender commandSender, PhatLoot phatLoot, int n, int n2, int n3, int n4) {
        phatLoot.days = n;
        phatLoot.hours = n2;
        phatLoot.minutes = n3;
        phatLoot.seconds = n4;
        commandSender.sendMessage("\u00a75Reset time for PhatLoot \u00a76" + phatLoot.name + "\u00a75 has been set to \u00a76" + n + " days, " + n2 + " hours, " + n3 + " minutes, and " + n4 + " seconds");
        phatLoot.save();
        return true;
    }

    @CommandHandler.CodCommand(command="time", weight=50.1)
    public boolean time(Player player, int n, int n2, int n3, int n4) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.time((CommandSender)player, phatLoot, n, n2, n3, n4);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="time", weight=50.2)
    public boolean time(CommandSender commandSender, PhatLoot phatLoot, String string) {
        if (string.equals("never")) {
            phatLoot.days = -1;
            phatLoot.hours = -1;
            phatLoot.minutes = -1;
            phatLoot.seconds = -1;
            commandSender.sendMessage("\u00a75PhatLoot \u00a76" + phatLoot.name + "\u00a75 has been set to \u00a76never\u00a75 reset");
            phatLoot.save();
            return true;
        }
        return false;
    }

    @CommandHandler.CodCommand(command="time", weight=50.3)
    public boolean time(Player player, String string) {
        if (string.equals("never")) {
            for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
                this.time((CommandSender)player, phatLoot, string);
            }
            return true;
        }
        return false;
    }

    @CommandHandler.CodCommand(command="global", weight=60.0, usage={"\u00a72<command> [Name] <true|false>\u00a7b Set PhatLoot to global or individual", "\u00a77If Name is not specified then all PhatLoots linked to the target Block will be affected"}, permission="phatloots.global")
    public boolean global(CommandSender commandSender, PhatLoot phatLoot, boolean bl) {
        phatLoot.global = bl;
        phatLoot.reset(null);
        commandSender.sendMessage("\u00a75PhatLoot \u00a76" + phatLoot.name + "\u00a75 has been set to \u00a76" + (bl ? "global" : "individual") + "\u00a75 reset");
        phatLoot.save();
        return true;
    }

    @CommandHandler.CodCommand(command="global", weight=60.1)
    public boolean global(Player player, boolean bl) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.global((CommandSender)player, phatLoot, bl);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="autoloot", weight=70.0, usage={"\u00a72<command> [Name] <true|false>\u00a7b Set if Items are automatically looted", "\u00a77If Name is not specified then all PhatLoots linked to the target Block will be affected"}, permission="phatloots.autoloot")
    public boolean autoloot(CommandSender commandSender, PhatLoot phatLoot, boolean bl) {
        phatLoot.autoLoot = bl;
        commandSender.sendMessage("\u00a75PhatLoot \u00a76" + phatLoot.name + "\u00a75 has been set to " + (bl ? "automatically add Loot to the looters inventory." : "open the chest inventory for the looter."));
        phatLoot.save();
        return true;
    }

    @CommandHandler.CodCommand(command="autoloot", weight=70.1)
    public boolean autoloot(Player player, boolean bl) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.autoloot((CommandSender)player, phatLoot, bl);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="break", weight=80.0, usage={"\u00a72<command> [Name] <true|false>\u00a7b Set if global Chests are broken after looting", "\u00a77If Name is not specified then all PhatLoots linked to the target Block will be affected"}, permission="phatloots.break")
    public boolean breakAndRespawn(CommandSender commandSender, PhatLoot phatLoot, boolean bl) {
        if (bl && !phatLoot.global) {
            phatLoot.global = true;
            phatLoot.reset(null);
            commandSender.sendMessage("\u00a75PhatLoot \u00a76" + phatLoot.name + "\u00a75 has been set to \u00a76global\u00a75 reset");
        }
        phatLoot.breakAndRespawn = bl;
        commandSender.sendMessage("\u00a75PhatLoot \u00a76" + phatLoot.name + "\u00a75 has been set to " + (bl ? "automatically break global chests when they are looted and have them respawn." : "keep chests present after looting."));
        phatLoot.save();
        return true;
    }

    @CommandHandler.CodCommand(command="break", weight=80.1)
    public boolean breakAndRespawn(Player player, boolean bl) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.breakAndRespawn((CommandSender)player, phatLoot, bl);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="round", weight=90.0, usage={"\u00a72<command> [Name] <true|false>\u00a7b Set if cooldown times should round down (ex. Daily/Hourly loots)", "\u00a77If Name is not specified then all PhatLoots linked to the target Block will be affected"}, permission="phatloots.round")
    public boolean round(CommandSender commandSender, PhatLoot phatLoot, boolean bl) {
        phatLoot.round = bl;
        commandSender.sendMessage("\u00a75PhatLoot \u00a76" + phatLoot.name + "\u00a75 has been set to \u00a76" + (bl ? "" : "not ") + "round down time");
        phatLoot.save();
        return true;
    }

    @CommandHandler.CodCommand(command="round", weight=90.1)
    public boolean round(Player player, boolean bl) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.round((CommandSender)player, phatLoot, bl);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="money", weight=100.0, usage={"\u00a72<command> [Name] <Amount>\u00a7b Set money range to be looted", "\u00a77If Name is not specified then all PhatLoots linked to the target Block will be affected", "\u00a76Amount may be a number \u00a74(100)\u00a76 or range \u00a74(100-500)"}, permission="phatloots.money")
    public boolean money(CommandSender commandSender, PhatLoot phatLoot, int n, int n2) {
        Iterator<Loot> iterator = phatLoot.lootList.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Money)) continue;
            iterator.remove();
        }
        phatLoot.addLoot(new Money(n, n2));
        commandSender.sendMessage("\u00a75Money for PhatLoot \u00a76" + phatLoot.name + "\u00a75 set to " + (n == n2 ? "\u00a76" : "a range from \u00a76" + n + "\u00a75 to \u00a76") + n2);
        phatLoot.save();
        return true;
    }

    @CommandHandler.CodCommand(command="money", weight=100.1)
    public boolean money(Player player, int n, int n2) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.money((CommandSender)player, phatLoot, n, n2);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="money", weight=100.2)
    public boolean money(Player player, PhatLoot phatLoot, int n) {
        return this.money((CommandSender)player, phatLoot, n, n);
    }

    @CommandHandler.CodCommand(command="money", weight=100.3)
    public boolean money(Player player, int n) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.money((CommandSender)player, phatLoot, n, n);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="money", weight=100.4)
    public boolean money(CommandSender commandSender, PhatLoot phatLoot, String string) {
        int n;
        int n2;
        String[] stringArray = string.split("-");
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            return false;
        }
        return this.money(commandSender, phatLoot, n2, n);
    }

    @CommandHandler.CodCommand(command="money", weight=100.5)
    public boolean money(Player player, String string) {
        int n;
        int n2;
        String[] stringArray = string.split("-");
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            return false;
        }
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.money((CommandSender)player, phatLoot, n2, n);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="cost", weight=110.0, usage={"\u00a72<command> [Name] <Amount>\u00a7b Set cost of looting", "\u00a77If Name is not specified then all PhatLoots linked to the target Block will be affected", "\u00a76Amount may be a number \u00a74(100)\u00a76 or range \u00a74(100-500)"}, permission="phatloots.cost")
    public boolean cost(CommandSender commandSender, PhatLoot phatLoot, int n, int n2) {
        return this.money(commandSender, phatLoot, -n, -n2);
    }

    @CommandHandler.CodCommand(command="cost", weight=110.1)
    public boolean cost(Player player, int n, int n2) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.money((CommandSender)player, phatLoot, -n, -n2);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="cost", weight=110.2)
    public boolean cost(Player player, PhatLoot phatLoot, int n) {
        return this.money((CommandSender)player, phatLoot, -n, -n);
    }

    @CommandHandler.CodCommand(command="cost", weight=110.3)
    public boolean cost(Player player, int n) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.money((CommandSender)player, phatLoot, -n, -n);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="cost", weight=110.4)
    public boolean cost(CommandSender commandSender, PhatLoot phatLoot, String string) {
        int n;
        int n2;
        String[] stringArray = string.split("-");
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            return false;
        }
        return this.money(commandSender, phatLoot, -n2, -n);
    }

    @CommandHandler.CodCommand(command="cost", weight=110.5)
    public boolean cost(Player player, String string) {
        int n;
        int n2;
        String[] stringArray = string.split("-");
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            return false;
        }
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.money((CommandSender)player, phatLoot, -n2, -n);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="exp", weight=120.0, usage={"\u00a72<command> [Name] <Amount>\u00a7b Set experience to be gained", "\u00a77If Name is not specified then all PhatLoots linked to the target Block will be affected", "\u00a76Amount may be a number \u00a74(100)\u00a76 or range \u00a74(100-500)"}, permission="phatloots.exp")
    public boolean exp(CommandSender commandSender, PhatLoot phatLoot, int n, int n2) {
        Iterator<Loot> iterator = phatLoot.lootList.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Experience)) continue;
            iterator.remove();
        }
        phatLoot.addLoot(new Experience(n, n2));
        commandSender.sendMessage("\u00a75Experience for PhatLoot \u00a76" + phatLoot.name + "\u00a75 set to " + (n == n2 ? "\u00a76" : "a range from \u00a76" + n + "\u00a75 to \u00a76") + n2);
        phatLoot.save();
        return true;
    }

    @CommandHandler.CodCommand(command="exp", weight=120.1)
    public boolean exp(Player player, int n, int n2) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.exp((CommandSender)player, phatLoot, n, n2);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="exp", weight=120.2)
    public boolean exp(CommandSender commandSender, PhatLoot phatLoot, int n) {
        return this.exp(commandSender, phatLoot, n, n);
    }

    @CommandHandler.CodCommand(command="exp", weight=120.3)
    public boolean exp(Player player, int n) {
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            this.exp((CommandSender)player, phatLoot, n, n);
        }
        return true;
    }

    @CommandHandler.CodCommand(command="list", weight=130.0, usage={"\u00a72<command>\u00a7b List all PhatLoots"}, permission="phatloots.list")
    public boolean list(CommandSender commandSender) {
        String string = "\u00a75Current PhatLoots: \u00a76";
        for (PhatLoot phatLoot : PhatLoots.getPhatLoots()) {
            string = string + phatLoot.name + ", ";
        }
        commandSender.sendMessage(string.substring(0, string.length() - 2));
        return true;
    }

    @CommandHandler.CodCommand(command="gui", aliases={"info"}, weight=140.0, usage={"\u00a72<command> [Name]\u00a7b Open info GUI of PhatLoot", "\u00a77If Name is not specified then all PhatLoots linked to the target Block will be affected"}, permission="phatloots.info")
    public boolean gui(Player player, PhatLoot phatLoot) {
        InventoryListener.viewPhatLoot(player, phatLoot);
        return true;
    }

    @CommandHandler.CodCommand(command="gui", weight=140.1)
    public boolean gui(CommandSender commandSender, PhatLoot phatLoot) {
        commandSender.sendMessage("\u00a72Name:\u00a7b " + phatLoot.name + " \u00a72Global Reset:\u00a7b " + phatLoot.global + " \u00a72Round Down:\u00a7b " + phatLoot.round);
        commandSender.sendMessage("\u00a72Reset Time:\u00a7b " + phatLoot.days + " days, " + phatLoot.hours + " hours, " + phatLoot.minutes + " minutes, and " + phatLoot.seconds + " seconds.");
        return true;
    }

    @CommandHandler.CodCommand(command="gui", weight=140.2)
    public boolean gui(Player player) {
        LinkedList<PhatLoot> linkedList = PhatLootsUtil.getPhatLoots(player);
        switch (linkedList.size()) {
            case 0: {
                return false;
            }
            case 1: {
                this.gui(player, linkedList.getFirst());
                break;
            }
            default: {
                String string = "\u00a75Linked PhatLoots: \u00a76";
                for (PhatLoot phatLoot : linkedList) {
                    string = string + phatLoot.name + ", ";
                }
                player.sendMessage(string.substring(0, string.length() - 2));
            }
        }
        return true;
    }

    @CommandHandler.CodCommand(command="give", weight=150.0, usage={"\u00a72<command> <Player> <PhatLoot> [Title]\u00a7b Force Player to loot a PhatLoot"}, permission="phatloots.give")
    public boolean give(CommandSender commandSender, Player player, PhatLoot phatLoot, String string) {
        phatLoot.rollForLoot(player, ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        commandSender.sendMessage("\u00a75PhatLoot \u00a76" + phatLoot.name + "\u00a75 given to \u00a76" + player.getName());
        return true;
    }

    @CommandHandler.CodCommand(command="give", weight=150.1)
    public boolean give(CommandSender commandSender, Player player, PhatLoot phatLoot) {
        return this.give(commandSender, player, phatLoot, phatLoot.name);
    }

    @CommandHandler.CodCommand(command="give", weight=150.2, minArgs=1)
    public boolean give(CommandSender commandSender, Player player, PhatLoot phatLoot, String[] stringArray) {
        return this.give(commandSender, player, phatLoot, PhatLootsUtil.concatArgs(stringArray));
    }

    @CommandHandler.CodCommand(command="reset", weight=160.0, usage={"\u00a72<command>\u00a7b Reset looted times for target Block", "\u00a72<command> <Name>\u00a7b Reset looted times for PhatLoot", "\u00a72<command> all\u00a7b Reset looted times for all PhatLoots"}, permission="phatloots.reset")
    public boolean reset(Player player) {
        Block block = player.getTargetBlock(EnumSet.noneOf(Material.class), 10);
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            phatLoot.reset(block);
            player.sendMessage("\u00a75Target \u00a76" + block.getType().toString() + "\u00a75 has been reset.");
        }
        return true;
    }

    @CommandHandler.CodCommand(command="reset", weight=160.1)
    public boolean reset(CommandSender commandSender, PhatLoot phatLoot) {
        phatLoot.reset(null);
        commandSender.sendMessage("\u00a75All Chests in PhatLoot \u00a76" + phatLoot.name + "\u00a75 have been reset.");
        return true;
    }

    @CommandHandler.CodCommand(command="reset", weight=160.2)
    public boolean reset(CommandSender commandSender, String string) {
        if (string.equals("all")) {
            for (PhatLoot phatLoot : PhatLoots.getPhatLoots()) {
                phatLoot.reset(null);
            }
            commandSender.sendMessage("\u00a75All Chests in each PhatLoot have been reset.");
        }
        return true;
    }

    @CommandHandler.CodCommand(command="clean", weight=170.0, usage={"\u00a72<command>\u00a7b Clean looted times for target Block", "\u00a72<command> <Name>\u00a7b Clean looted times for PhatLoot", "\u00a72<command> all\u00a7b Clean looted times for all PhatLoots"}, permission="phatloots.clean")
    public boolean clean(Player player) {
        Block block = player.getTargetBlock(EnumSet.noneOf(Material.class), 10);
        for (PhatLoot phatLoot : PhatLootsUtil.getPhatLoots(player)) {
            phatLoot.clean(block);
            player.sendMessage("\u00a75Target \u00a76" + block.getType().toString() + "\u00a75 has been cleaned.");
        }
        return true;
    }

    @CommandHandler.CodCommand(command="clean", weight=170.1)
    public boolean clean(CommandSender commandSender, PhatLoot phatLoot) {
        phatLoot.clean(null);
        commandSender.sendMessage("\u00a75All Chests in PhatLoot \u00a76" + phatLoot.name + "\u00a75 have been cleaned.");
        return true;
    }

    @CommandHandler.CodCommand(command="clean", weight=170.2)
    public boolean clean(CommandSender commandSender, String string) {
        if (string.equals("all")) {
            for (PhatLoot phatLoot : PhatLoots.getPhatLoots()) {
                phatLoot.clean(null);
            }
            commandSender.sendMessage("\u00a75All Chests in each PhatLoot have been cleaned.");
        }
        return true;
    }

    @CommandHandler.CodCommand(command="reload", weight=180.0, aliases={"rl"}, usage={"\u00a72<command>\u00a7b Reset looted times for target Block", "\u00a72<command> <Name>\u00a7b Reset looted times for PhatLoot", "\u00a72<command> all\u00a7b Reset looted times for all PhatLoots"}, permission="phatloots.reload")
    public boolean reload(CommandSender commandSender) {
        PhatLoots.rl(commandSender);
        return true;
    }
}

