/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots.commands;

import com.codisimus.plugins.phatloots.PhatLoots;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandHandler
implements CommandExecutor {
    private static final Comparator<Method> METHOD_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return Double.compare(((Method)object).getAnnotation(CodCommand.class).weight(), ((Method)object2).getAnnotation(CodCommand.class).weight());
        }
    };
    private static final Comparator<CodCommand> CODCOMMAND_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return Double.compare(((CodCommand)object).weight(), ((CodCommand)object2).weight());
        }
    };
    private final boolean groupedCommands;
    private final String parentCommand;
    private final TreeSet<CodCommand> metas = new TreeSet<CodCommand>(CODCOMMAND_COMPARATOR);
    private final HashMap<CodCommand, TreeSet<Method>> methods = new HashMap();
    private final Properties aliases = new Properties();
    private final JavaPlugin plugin;

    public CommandHandler(JavaPlugin javaPlugin) {
        this.plugin = javaPlugin;
        this.groupedCommands = false;
        this.parentCommand = null;
    }

    public CommandHandler(JavaPlugin javaPlugin, String string) {
        this.plugin = javaPlugin;
        this.groupedCommands = true;
        PluginCommand pluginCommand = javaPlugin.getCommand(string);
        if (pluginCommand == null) {
            javaPlugin.getLogger().warning("CodCommand " + string + " was not found in plugin.yml");
            this.parentCommand = null;
        } else {
            pluginCommand.setExecutor((CommandExecutor)this);
            this.parentCommand = pluginCommand.getName();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerCommands(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            void var7_13;
            if (method.getAnnotation(CodCommand.class) == null) continue;
            if (method.getReturnType() == Boolean.class) {
                this.plugin.getLogger().warning("CodCommand " + method.getName() + " does not return a boolean");
                continue;
            }
            CodCommand codCommand = method.getAnnotation(CodCommand.class);
            if (!this.groupedCommands) {
                PluginCommand pluginCommand = this.plugin.getCommand(codCommand.command());
                if (pluginCommand == null) {
                    this.plugin.getLogger().warning("CodCommand " + method.getName() + " was not found in plugin.yml");
                    continue;
                }
                pluginCommand.setExecutor((CommandExecutor)this);
                pluginCommand.setAliases(Arrays.asList(codCommand.aliases()));
            } else {
                for (String string : codCommand.aliases()) {
                    this.aliases.setProperty(string, codCommand.command());
                }
            }
            CodCommand codCommand2 = this.findMeta(codCommand);
            if (codCommand2 == null || CODCOMMAND_COMPARATOR.compare(codCommand, codCommand2) < 0) {
                TreeSet<Method> treeSet;
                if (codCommand2 == null) {
                    treeSet = new TreeSet<Method>(METHOD_COMPARATOR);
                } else {
                    this.metas.remove(codCommand2);
                    treeSet = this.methods.remove(codCommand2);
                }
                CodCommand codCommand3 = codCommand;
                this.metas.add(codCommand3);
                this.methods.put(codCommand3, treeSet);
            }
            this.methods.get(var7_13).add(method);
        }
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        String string2;
        if (!this.groupedCommands) {
            this.handleCommand(commandSender, this.findMeta(command.getName(), ""), stringArray);
            return true;
        }
        if (stringArray.length == 0) {
            CodCommand codCommand = this.findMeta("&none", null);
            if (codCommand != null) {
                this.handleCommand(commandSender, codCommand, new String[0]);
            } else {
                this.displayHelpPage(commandSender);
            }
            return true;
        }
        String string3 = this.aliases.containsKey(stringArray[0]) ? this.aliases.getProperty(stringArray[0]) : stringArray[0];
        CodCommand codCommand = this.findMeta(string3, string2 = stringArray.length > 1 ? stringArray[1] : null);
        if (codCommand != null) {
            int n;
            int n2 = n = codCommand.command().equals("&variable") ? 0 : 1;
            if (!codCommand.subcommand().isEmpty()) {
                ++n;
            }
            this.handleCommand(commandSender, codCommand, Arrays.copyOfRange(stringArray, n, stringArray.length));
        } else if (string3.equals("help")) {
            string3 = string2 != null && this.aliases.containsKey(string2) ? this.aliases.getProperty(string2) : string2;
            switch (stringArray.length) {
                case 2: {
                    codCommand = this.findMeta(string3, null);
                    break;
                }
                case 3: {
                    codCommand = this.findMeta(string3, stringArray[2]);
                    break;
                }
            }
            if (codCommand != null) {
                this.displayUsage(commandSender, codCommand);
            } else {
                this.displayHelpPage(commandSender);
            }
        } else {
            commandSender.sendMessage("\u00a76" + string3 + "\u00a74 is not a valid command");
            this.displayHelpPage(commandSender);
        }
        return true;
    }

    private void handleCommand(CommandSender commandSender, CodCommand codCommand, String[] stringArray) {
        try {
            if (!codCommand.permission().isEmpty() && !commandSender.hasPermission(codCommand.permission())) {
                commandSender.sendMessage("\u00a74You don't have permission to do that");
                return;
            }
            for (Method method : this.methods.get(codCommand)) {
                int n;
                Class<?>[] classArray = method.getParameterTypes();
                Object[] objectArray = new Object[classArray.length];
                int n2 = stringArray.length;
                if (classArray[0] == Player.class && !(commandSender instanceof Player)) continue;
                objectArray[0] = commandSender;
                if (classArray[classArray.length - 1] == String[].class) {
                    String[] stringArray2;
                    n2 = classArray.length - 2;
                    n = stringArray.length - n2;
                    if (n < codCommand.minArgs() || codCommand.maxArgs() != -1 && n > codCommand.maxArgs()) continue;
                    objectArray[objectArray.length - 1] = stringArray2 = n == 0 ? new String[]{} : Arrays.copyOfRange(stringArray, n2, stringArray.length);
                } else if (classArray.length - 1 != n2) continue;
                n = 1;
                for (int i = 0; i < n2; ++i) {
                    Object object = this.validate(stringArray[i], classArray[i + 1]);
                    if (object == null) {
                        n = 0;
                        break;
                    }
                    objectArray[i + 1] = object;
                }
                if (n == 0) continue;
                if (!((Boolean)method.invoke(method.getDeclaringClass().newInstance(), objectArray)).booleanValue()) {
                    this.displayUsage(commandSender, codCommand);
                }
                return;
            }
            this.displayUsage(commandSender, codCommand);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            commandSender.sendMessage("\u00a74An error occured while trying to perform this command. Please notify a server administator.");
            this.plugin.getLogger().log(Level.SEVERE, "Error occured when executing command " + this.getCommand(codCommand), exception);
        }
    }

    private Object validate(String string, Class clazz) {
        try {
            ParameterType parameterType = ParameterType.getType(clazz);
            switch (parameterType) {
                case STRING: {
                    return string;
                }
                case INT: {
                    return Integer.parseInt(string);
                }
                case DOUBLE: {
                    return Double.parseDouble(string);
                }
                case BOOLEAN: {
                    switch (string) {
                        case "true": 
                        case "on": 
                        case "yes": {
                            return true;
                        }
                        case "false": 
                        case "off": 
                        case "no": {
                            return false;
                        }
                    }
                    return null;
                }
                case MATERIAL: {
                    return string.matches("[0-9]+") ? Material.getMaterial((int)Integer.parseInt(string)) : Material.matchMaterial((String)string);
                }
                case PLAYER: {
                    return Bukkit.getPlayer((String)string);
                }
                case OFFLINEPLAYER: {
                    return Bukkit.getOfflinePlayer((String)string);
                }
                case PHATLOOT: {
                    return PhatLoots.getPhatLoot(string);
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private CodCommand findMeta(String string, String string2) {
        for (CodCommand codCommand : this.metas) {
            if (!codCommand.command().equals(string) && (!codCommand.command().equals("&variable") || string.equals("&none") || string.equals("help")) || !codCommand.subcommand().isEmpty() && !codCommand.subcommand().equals(string2)) continue;
            return codCommand;
        }
        return null;
    }

    private CodCommand findMeta(CodCommand codCommand) {
        for (CodCommand codCommand2 : this.metas) {
            if (!codCommand2.command().equals(codCommand.command()) || !codCommand2.subcommand().equals(codCommand.subcommand())) continue;
            return codCommand2;
        }
        return null;
    }

    private void displayHelpPage(CommandSender commandSender) {
        commandSender.sendMessage("\u00a71Sub commands of \u00a76/" + this.parentCommand + "\u00a71:");
        commandSender.sendMessage("\u00a72/" + this.parentCommand + " help \u00a7f<\u00a76command\u00a7f> =\u00a7b Display the usage of a sub command");
        for (CodCommand codCommand : this.metas) {
            this.displayOneLiner(commandSender, codCommand);
        }
    }

    private void displayOneLiner(CommandSender commandSender, CodCommand codCommand) {
        String string = this.getCommand(codCommand);
        if (codCommand.usage().length == 1) {
            commandSender.sendMessage(codCommand.usage()[0].replace("<command>", string));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u00a72");
            stringBuilder.append(this.getCommand(codCommand));
            stringBuilder.append(" \u00a7f=\u00a7b '/");
            stringBuilder.append(this.parentCommand);
            stringBuilder.append(" help ");
            stringBuilder.append(codCommand.command());
            if (!codCommand.subcommand().isEmpty()) {
                stringBuilder.append(' ');
                stringBuilder.append(codCommand.subcommand());
            }
            stringBuilder.append("' for full usage.");
            commandSender.sendMessage(stringBuilder.toString());
        }
    }

    private void displayUsage(CommandSender commandSender, CodCommand codCommand) {
        String string = this.getCommand(codCommand);
        for (String string2 : codCommand.usage()) {
            commandSender.sendMessage(string2.replace("<command>", string));
        }
    }

    private String getCommand(CodCommand codCommand) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('/');
        if (this.groupedCommands) {
            stringBuilder.append(this.parentCommand);
        }
        if (!codCommand.command().startsWith("&")) {
            stringBuilder.append(' ');
            stringBuilder.append(codCommand.command());
        }
        if (!codCommand.subcommand().isEmpty()) {
            stringBuilder.append(' ');
            stringBuilder.append(codCommand.subcommand());
        }
        return stringBuilder.toString();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CodCommand {
        public String command();

        public String subcommand() default "";

        public double weight() default 0.0;

        public String[] aliases() default {};

        public String[] usage() default {};

        public String permission() default "";

        public int minArgs() default 0;

        public int maxArgs() default -1;
    }

    private static enum ParameterType {
        STRING,
        INT,
        DOUBLE,
        BOOLEAN,
        MATERIAL,
        PLAYER,
        OFFLINEPLAYER,
        PHATLOOT;


        public static ParameterType getType(Class clazz) {
            try {
                return ParameterType.valueOf(clazz.getSimpleName().toUpperCase());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

