/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Random;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PhatLootsUtil {
    private static Random random = new Random();
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final String TEXT_EXTENSION = ".txt";
    public static final String YAML_EXTENSION = ".yml";
    public static final FilenameFilter YAML_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(PhatLootsUtil.YAML_EXTENSION);
        }
    };

    public static boolean canLoot(Player player, PhatLoot phatLoot) {
        if (PhatLootsConfig.restrictAll || PhatLootsConfig.restricted.contains(phatLoot.name)) {
            return player.hasPermission("phatloots.loot.*") ? true : player.hasPermission("phatloots.loot." + phatLoot.name);
        }
        return true;
    }

    public static boolean isLinkableType(Block block) {
        return PhatLoots.types.containsKey(block.getType());
    }

    public static int rollForInt(int n) {
        return random.nextInt(n + 1);
    }

    public static int rollForInt(int n, int n2) {
        return random.nextInt(n2 + 1 - n) + n;
    }

    public static double rollForDouble(double d) {
        return random.nextDouble() * d;
    }

    public static double rollForDouble(int n, int n2) {
        return random.nextInt(n2 + 1 - n) + n;
    }

    public static String getItemName(ItemStack itemStack) {
        String string;
        if (itemStack.hasItemMeta() && (string = itemStack.getItemMeta().getDisplayName()) != null && !string.isEmpty()) {
            return string;
        }
        return WordUtils.capitalizeFully((String)itemStack.getType().toString().replace("_", " "));
    }

    public static Block getLeftSide(Block block) {
        switch (block.getType()) {
            case TRAPPED_CHEST: 
            case CHEST: {
                Chest chest = (Chest)block.getState();
                Inventory inventory = chest.getInventory();
                if (!(inventory instanceof DoubleChestInventory)) break;
                chest = (Chest)((DoubleChestInventory)inventory).getLeftSide().getHolder();
                block = chest.getBlock();
                break;
            }
        }
        return block;
    }

    public static Player getNearestPlayer(Location location) {
        Player player = null;
        double d = 2500.0;
        for (Player player2 : location.getWorld().getPlayers()) {
            Location location2 = player2.getLocation();
            double d2 = location.distanceSquared(location2);
            if (!(d2 < d)) continue;
            player = player2;
            d = d2;
        }
        return player;
    }

    public static LinkedList<PhatLoot> getPhatLoots(Player player) {
        LinkedList<Object> linkedList = new LinkedList();
        Block block = player.getTargetBlock(EnumSet.of(Material.AIR), 10);
        String string = block.getType().toString();
        if (!PhatLootsUtil.isLinkableType(block)) {
            player.sendMessage("\u00a76" + string + "\u00a74 is not a linkable type.");
            return linkedList;
        }
        linkedList = PhatLoots.getPhatLoots(block);
        if (linkedList.isEmpty()) {
            player.sendMessage("\u00a74Target \u00a76" + string + "\u00a74 is not linked to a PhatLoot");
        }
        return linkedList;
    }

    public static String concatArgs(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i <= stringArray.length - 1; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.substring(1);
    }
}

