/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLootChest;
import com.codisimus.plugins.phatloots.PhatLootsConfig;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import com.codisimus.plugins.phatloots.commands.CommandHandler;
import com.codisimus.plugins.phatloots.commands.LootCommand;
import com.codisimus.plugins.phatloots.commands.ManageLootCommand;
import com.codisimus.plugins.phatloots.commands.ManageMoneyLootCommand;
import com.codisimus.plugins.phatloots.commands.ManageMythicDropsLootCommand;
import com.codisimus.plugins.phatloots.commands.VariableLootCommand;
import com.codisimus.plugins.phatloots.events.ChestRespawnEvent;
import com.codisimus.plugins.phatloots.gui.InventoryListener;
import com.codisimus.plugins.phatloots.listeners.CitizensListener;
import com.codisimus.plugins.phatloots.listeners.DispenserListener;
import com.codisimus.plugins.phatloots.listeners.FishingListener;
import com.codisimus.plugins.phatloots.listeners.LootBagListener;
import com.codisimus.plugins.phatloots.listeners.MobDeathListener;
import com.codisimus.plugins.phatloots.listeners.MobListener;
import com.codisimus.plugins.phatloots.listeners.MobSpawnListener;
import com.codisimus.plugins.phatloots.listeners.PhatLootsListener;
import com.codisimus.plugins.phatloots.listeners.VoteListener;
import com.codisimus.plugins.phatloots.loot.CommandLoot;
import com.codisimus.plugins.phatloots.loot.Experience;
import com.codisimus.plugins.phatloots.loot.Gem;
import com.codisimus.plugins.phatloots.loot.Item;
import com.codisimus.plugins.phatloots.loot.LootCollection;
import com.codisimus.plugins.phatloots.loot.Message;
import com.codisimus.plugins.phatloots.loot.Money;
import com.codisimus.plugins.phatloots.loot.MythicDropsItem;
import com.codisimus.plugins.phatloots.loot.UnidentifiedItem;
import com.codisimus.plugins.phatloots.regions.RegionHook;
import com.codisimus.plugins.phatloots.regions.RegionToolsRegionHook;
import com.codisimus.plugins.phatloots.regions.WorldGuardRegionHook;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PhatLoots
extends JavaPlugin {
    public static JavaPlugin plugin;
    public static Logger logger;
    public static Economy econ;
    public static String dataFolder;
    public static boolean mythicDropsSupport;
    public static long autoSavePeriod;
    public static CommandHandler handler;
    public static final HashMap<String, RegionHook> regionHooks;
    public static final EnumMap<Material, HashMap<String, String>> types;
    private static final HashMap<String, PhatLoot> phatLoots;

    public static void main(String[] stringArray) {
    }

    public void onDisable() {
        PhatLoots.saveLootTimes();
        for (PhatLootChest phatLootChest : (Collection)PhatLootChest.chestsToRespawn.clone()) {
            phatLootChest.respawn(ChestRespawnEvent.RespawnReason.PLUGIN_DISABLED);
        }
    }

    public void onEnable() {
        Object object;
        File file;
        logger = this.getLogger();
        plugin = this;
        File file2 = this.getDataFolder();
        if (!file2.isDirectory()) {
            file2.mkdir();
        }
        if (!(file2 = new File(dataFolder = file2.getPath(), "LootTables")).isDirectory()) {
            file2.mkdir();
        }
        if (!(file2 = new File(dataFolder, "Chests")).isDirectory()) {
            file2.mkdir();
        }
        if (!(file2 = new File(dataFolder, "LootTimes")).isDirectory()) {
            file2.mkdir();
        }
        if (!(file2 = new File(dataFolder, "Addons")).isDirectory()) {
            file2.mkdir();
        }
        if (!(file = new File(dataFolder, "LootTables" + File.separator + "SampleLoot.yml")).exists()) {
            try {
                object = this.getResource("SampleLoot.yml");
                Plugin[] pluginArray = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    int n;
                    byte[] byArray = new byte[1024];
                    while ((n = ((InputStream)object).read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                }
                catch (Throwable object2) {
                    pluginArray = object2;
                    throw object2;
                }
                finally {
                    if (object != null) {
                        if (pluginArray != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable) {
                                pluginArray.addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Could not save resource: SampleLoot.yml", iOException);
            }
        }
        if (mythicDropsSupport = Bukkit.getPluginManager().isPluginEnabled("MythicDrops")) {
            logger.info("Enabling MythicDrops support");
        } else if (PhatLoots.isDebug()) {
            PhatLoots.debug("Plugin MythicDrops could not be found, support has been turned off.");
        }
        LootCollection.registerButton();
        Experience.registerButton();
        if (econ != null) {
            Money.registerButton();
        }
        if (mythicDropsSupport) {
            MythicDropsItem.registerButtonAndTool();
        }
        object = (String)this.getDescription().getCommands().keySet().toArray()[0];
        handler = new CommandHandler(this, (String)object);
        if (mythicDropsSupport) {
            handler.registerCommands(ManageMythicDropsLootCommand.class);
        }
        handler.registerCommands(LootCommand.class);
        handler.registerCommands(ManageLootCommand.class);
        handler.registerCommands(VariableLootCommand.class);
        if (econ != null) {
            handler.registerCommands(ManageMoneyLootCommand.class);
        }
        PhatLoots.registerRegionHook("RegionTools", new RegionToolsRegionHook());
        PhatLoots.registerRegionHook("WorldGuard", new WorldGuardRegionHook());
        ConfigurationSerialization.registerClass(PhatLoot.class, (String)"PhatLoot");
        ConfigurationSerialization.registerClass(LootCollection.class, (String)"LootCollection");
        ConfigurationSerialization.registerClass(Item.class, (String)"Item");
        ConfigurationSerialization.registerClass(CommandLoot.class, (String)"Command");
        ConfigurationSerialization.registerClass(Message.class, (String)"Message");
        ConfigurationSerialization.registerClass(Experience.class, (String)"Experience");
        ConfigurationSerialization.registerClass(Money.class, (String)"Money");
        if (mythicDropsSupport) {
            ConfigurationSerialization.registerClass(MythicDropsItem.class, (String)"MythicDropsItem");
            ConfigurationSerialization.registerClass(UnidentifiedItem.class, (String)"UnidentifiedItem");
            ConfigurationSerialization.registerClass(Gem.class, (String)"Gem");
        }
        for (Plugin plugin : Bukkit.getPluginManager().loadPlugins(file2)) {
            Bukkit.getPluginManager().enablePlugin(plugin);
        }
        this.registerEvents();
        PhatLoots.load();
        if (autoSavePeriod > 0L) {
            new BukkitRunnable(){

                public void run() {
                    PhatLoots.saveLootTimes();
                }
            }.runTaskTimer((Plugin)this, autoSavePeriod, autoSavePeriod);
        }
    }

    public void reloadConfig() {
        this.saveDefaultConfig();
        super.reloadConfig();
        PhatLootsConfig.load();
        this.setupEconomy();
    }

    private void registerEvents() {
        Object object;
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new PhatLootsListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryListener(), (Plugin)this);
        if (pluginManager.isPluginEnabled("Citizens")) {
            logger.info("Listening for Citizens NPC deaths");
            pluginManager.registerEvents((Listener)new CitizensListener(), (Plugin)this);
        } else if (PhatLoots.isDebug()) {
            PhatLoots.debug("Plugin Citizens could not be found, support has been turned off.");
        }
        if (this.getConfig().getBoolean("LootBags")) {
            logger.info("Listening for Loot bags");
            pluginManager.registerEvents((Listener)new LootBagListener(), (Plugin)this);
        } else if (PhatLoots.isDebug()) {
            PhatLoots.debug("LootBags have been turned off.");
        }
        if (this.getConfig().getBoolean("DispenserLoot")) {
            logger.info("Listening for Dispensers");
            pluginManager.registerEvents((Listener)new DispenserListener(), (Plugin)this);
        } else if (PhatLoots.isDebug()) {
            PhatLoots.debug("DispenserLoot has been turned off.");
        }
        String string = this.getConfig().getString("RegionPlugin");
        if (PhatLoots.isDebug()) {
            PhatLoots.debug("RegionPlugin is set to " + string);
            PhatLoots.debug("Registered Region plugins are " + regionHooks.keySet());
        }
        if (string.equals("auto")) {
            for (Map.Entry<String, RegionHook> object22 : regionHooks.entrySet()) {
                string = object22.getKey();
                if (Bukkit.getPluginManager().isPluginEnabled(string)) {
                    if (PhatLoots.isDebug()) {
                        PhatLoots.debug("Plugin " + string + " has been found, applying associated RegionHook.");
                    }
                    MobListener.regionHook = object22.getValue();
                    break;
                }
                if (!PhatLoots.isDebug()) continue;
                PhatLoots.debug("Plugin " + string + " could not be found, moving on...");
            }
            if (PhatLoots.isDebug()) {
                PhatLoots.debug("No compatiable plugins could be found, region support has been turned off");
            }
        } else if (Bukkit.getPluginManager().isPluginEnabled(string)) {
            if (PhatLoots.isDebug()) {
                PhatLoots.debug("Plugin " + string + " has been found, applying associated RegionHook.");
            }
            MobListener.regionHook = regionHooks.get(string);
        } else if (PhatLoots.isDebug()) {
            PhatLoots.debug("Plugin " + string + " could not be found, moving on...");
        }
        if (this.getConfig().getBoolean("MobDropLoot")) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Listening for Mob deaths");
            MobDeathListener mobDeathListener = new MobDeathListener();
            mobDeathListener.mobWorlds = this.getConfig().getBoolean("WorldMobDropLoot");
            boolean bl = mobDeathListener.mobRegions = this.getConfig().getBoolean("RegionMobDropLoot") && MobListener.regionHook != null;
            if (mobDeathListener.mobWorlds) {
                ((StringBuilder)object).append(" w/ MultiWorld support");
            } else if (PhatLoots.isDebug()) {
                PhatLoots.debug("MultiWorld support has been turned off for Mob loot.");
            }
            if (mobDeathListener.mobRegions) {
                ((StringBuilder)object).append(mobDeathListener.mobWorlds ? " and " : " w/ ");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append(" Regions");
            }
            logger.info(((StringBuilder)object).toString());
            pluginManager.registerEvents((Listener)mobDeathListener, (Plugin)this);
        } else if (PhatLoots.isDebug()) {
            PhatLoots.debug("Mob loot has been turned off.");
        }
        if (this.getConfig().getBoolean("MobSpawnLoot")) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Listening for Mob spawns");
            MobSpawnListener mobSpawnListener = new MobSpawnListener();
            mobSpawnListener.mobWorlds = this.getConfig().getBoolean("WorldMobSpawnLoot");
            boolean bl = mobSpawnListener.mobRegions = this.getConfig().getBoolean("RegionMobSpawnLoot") && MobListener.regionHook != null;
            if (mobSpawnListener.mobWorlds) {
                ((StringBuilder)object).append(" w/ MultiWorld support");
            } else if (PhatLoots.isDebug()) {
                PhatLoots.debug("MultiWorld support has been turned off for Mob armor/weapon spawning.");
            }
            if (mobSpawnListener.mobRegions) {
                ((StringBuilder)object).append(mobSpawnListener.mobWorlds ? " and " : " w/ ");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append(" Regions");
            }
            logger.info(((StringBuilder)object).toString());
            pluginManager.registerEvents((Listener)mobSpawnListener, (Plugin)this);
        } else if (PhatLoots.isDebug()) {
            PhatLoots.debug("Mob armor/weapon spawning has been turned off.");
        }
        if (this.getConfig().getBoolean("FishingLoot")) {
            logger.info("Listening for Players fishing");
            pluginManager.registerEvents((Listener)new FishingListener(), (Plugin)this);
        } else if (PhatLoots.isDebug()) {
            PhatLoots.debug("Fishing loot has been turned off.");
        }
        if (this.getConfig().getBoolean("VotifierLoot")) {
            logger.info("Listening for Votifier votes");
            pluginManager.registerEvents((Listener)new VoteListener(), (Plugin)this);
        } else if (PhatLoots.isDebug()) {
            PhatLoots.debug("Votifier loot has been turned off.");
        }
    }

    public static void registerRegionHook(String string, RegionHook regionHook) {
        regionHooks.put(string, regionHook);
        if (PhatLoots.isDebug()) {
            PhatLoots.debug("A RegionHook has been registered for " + string);
        }
    }

    public static void load() {
        File file = new File(dataFolder, "LootTables");
        if (PhatLoots.isDebug()) {
            PhatLoots.debug(file.listFiles(PhatLootsUtil.YAML_FILTER).length + " loot table(s) have been found in " + file.getPath());
        }
        for (File file2 : file.listFiles(PhatLootsUtil.YAML_FILTER)) {
            try {
                String string = file2.getName();
                string = string.substring(0, string.length() - ".yml".length());
                YamlConfiguration yamlConfiguration = PhatLoots.loadConfig(file2);
                PhatLoot phatLoot = (PhatLoot)yamlConfiguration.get(yamlConfiguration.contains(string) ? string : (String)yamlConfiguration.getKeys(false).iterator().next());
                if (!phatLoot.name.equals(string)) {
                    if (PhatLoots.isDebug()) {
                        PhatLoots.debug("PhatLoot name (" + phatLoot.name + ") does not match file name (" + string + "), renaming PhatLoot to " + string);
                    }
                    phatLoot.name = string;
                }
                phatLoots.put(string, phatLoot);
                phatLoot.save();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failed to load " + file2.getName(), exception);
            }
        }
        if (PhatLoots.isDebug()) {
            PhatLoots.debug(phatLoots.size() + " loot tables were succesfully loaded.");
        }
    }

    public static void saveAll() {
        for (PhatLoot phatLoot : phatLoots.values()) {
            phatLoot.saveAll();
        }
    }

    public static boolean hasPhatLoot(String string) {
        return phatLoots.containsKey(string);
    }

    public static Collection<PhatLoot> getPhatLoots() {
        return phatLoots.values();
    }

    public static void addPhatLoot(PhatLoot phatLoot) {
        phatLoots.put(phatLoot.name, phatLoot);
        phatLoot.save();
    }

    public static void removePhatLoot(PhatLoot phatLoot) {
        phatLoots.remove(phatLoot.name);
        new File(dataFolder, "LootTables" + File.separator + phatLoot.name + ".yml").delete();
        new File(dataFolder, "Chests" + File.separator + phatLoot.name + ".txt").delete();
        new File(dataFolder, "LootTimes" + File.separator + phatLoot.name + ".properties").delete();
    }

    public static PhatLoot getPhatLoot(String string) {
        return string == null ? null : phatLoots.get(string);
    }

    public static LinkedList<PhatLoot> getPhatLoots(Block block, Player player) {
        LinkedList<PhatLoot> linkedList = PhatLoots.getPhatLoots(block);
        for (PhatLoot phatLoot : linkedList) {
            if (PhatLootsUtil.canLoot(player, phatLoot)) continue;
            linkedList.remove(phatLoot);
        }
        return linkedList;
    }

    public static LinkedList<PhatLoot> getPhatLoots(Block block) {
        LinkedList<PhatLoot> linkedList = PhatLoots.getAutoLinkedPhatLoots(block);
        if (linkedList.isEmpty()) {
            linkedList = PhatLoots.getExplicitlyLinkedPhatLoots(block);
        }
        return linkedList;
    }

    public static LinkedList<PhatLoot> getAutoLinkedPhatLoots(Block block) {
        HashMap<String, String> hashMap;
        LinkedList<PhatLoot> linkedList = new LinkedList<PhatLoot>();
        if (PhatLootsUtil.isLinkableType(block) && (hashMap = types.get(block.getType())) != null) {
            String string;
            String string2 = block.getWorld().getName();
            String string3 = string = hashMap.containsKey(string2) ? hashMap.get(string2) : hashMap.get("all");
            if (string != null) {
                for (String string4 : string.split("; ")) {
                    PhatLoot phatLoot = PhatLoots.getPhatLoot(string4);
                    if (phatLoot == null) {
                        logger.warning("PhatLoot " + string4 + " does not exist.");
                        logger.warning("Please adjust your config or create the PhatLoot");
                    }
                    linkedList.add(phatLoot);
                }
            }
        }
        return linkedList;
    }

    public static LinkedList<PhatLoot> getExplicitlyLinkedPhatLoots(Block block) {
        LinkedList<PhatLoot> linkedList = new LinkedList<PhatLoot>();
        if (PhatLootsUtil.isLinkableType(block) && PhatLootChest.isPhatLootChest(block = PhatLootsUtil.getLeftSide(block))) {
            PhatLootChest phatLootChest = PhatLootChest.getChest(block);
            for (PhatLoot phatLoot : phatLoots.values()) {
                if (!phatLoot.containsChest(phatLootChest)) continue;
                linkedList.add(phatLoot);
            }
        }
        return linkedList;
    }

    public static CommandHandler getCommandHandler() {
        return handler;
    }

    private boolean setupEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            return false;
        }
        econ = (Economy)registeredServiceProvider.getProvider();
        return econ != null;
    }

    public static void saveLootTimes() {
        for (PhatLoot phatLoot : PhatLoots.getPhatLoots()) {
            phatLoot.clean(null);
            phatLoot.saveLootTimes();
        }
    }

    public static void rl() {
        PhatLoots.rl(null);
    }

    public static void rl(CommandSender commandSender) {
        PhatLoots.saveLootTimes();
        phatLoots.clear();
        plugin.reloadConfig();
        PhatLoots.load();
        logger.info("PhatLoots reloaded");
        if (commandSender instanceof Player) {
            commandSender.sendMessage("\u00a75PhatLoots reloaded");
        }
    }

    private static YamlConfiguration loadConfig(File file) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try {
            if (PhatLoots.isValidUTF8(Files.toByteArray((File)file))) {
                yamlConfiguration.loadFromString(Files.toString((File)file, (Charset)Charset.forName("UTF-8")));
            } else {
                yamlConfiguration.load(file);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "\u00a74Could not load data from " + file, exception);
        }
        return yamlConfiguration;
    }

    private static boolean isValidUTF8(byte[] byArray) {
        try {
            ((Charset)Charset.availableCharsets().get("UTF-8")).newDecoder().decode(ByteBuffer.wrap(byArray));
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }

    public static boolean isDebug() {
        return PhatLootsConfig.debug;
    }

    public static void debug(String string) {
        logger.info("DEBUG: " + string);
    }

    static {
        econ = null;
        regionHooks = new HashMap();
        types = new EnumMap(Material.class);
        phatLoots = new HashMap();
    }
}

