/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots;

import com.codisimus.plugins.phatloots.ChestAnimations;
import com.codisimus.plugins.phatloots.ForgettableInventory;
import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsConfig;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import com.codisimus.plugins.phatloots.events.ChestBreakEvent;
import com.codisimus.plugins.phatloots.events.ChestRespawnEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Dropper;
import org.bukkit.block.NoteBlock;
import org.bukkit.block.Skull;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PhatLootChest {
    private static EnumSet<Material> untriggeredRedstone = EnumSet.of(Material.REDSTONE_WIRE, new Material[]{Material.REDSTONE_COMPARATOR_OFF, Material.REDSTONE_LAMP_OFF, Material.REDSTONE_TORCH_OFF, Material.DIODE_BLOCK_OFF, Material.DISPENSER, Material.DROPPER, Material.NOTE_BLOCK, Material.PISTON_BASE, Material.TNT});
    private static EnumSet<Material> triggeredRedstone = EnumSet.of(Material.REDSTONE_WIRE, new Material[]{Material.REDSTONE_COMPARATOR_ON, Material.REDSTONE_LAMP_ON, Material.REDSTONE_TORCH_ON, Material.DIODE_BLOCK_ON, Material.PISTON_BASE});
    private static HashMap<String, PhatLootChest> chests = new HashMap();
    static HashSet<PhatLootChest> chestsToRespawn = new HashSet();
    public static HashMap<UUID, PhatLootChest> openPhatLootChests = new HashMap();
    static boolean useBreakAndRepawn;
    static boolean soundOnBreak;
    static boolean shuffleLoot;
    static String chestName;
    private String world;
    private int x;
    private int y;
    private int z;
    private boolean isDispenser;
    private BlockState state;
    private BlockState otherHalfState;

    private PhatLootChest(Block block) {
        this.world = block.getWorld().getName();
        this.x = block.getX();
        this.y = block.getY();
        this.z = block.getZ();
        switch (block.getType()) {
            case DISPENSER: 
            case DROPPER: {
                this.isDispenser = true;
            }
        }
    }

    private PhatLootChest(String string, int n, int n2, int n3) {
        this.world = string;
        this.x = n;
        this.y = n2;
        this.z = n3;
        World world = Bukkit.getWorld((String)string);
        if (world == null) {
            PhatLoots.logger.warning("The world '" + string + "' is not currently loaded, all linked chests in this world are being unlinked.");
            PhatLoots.logger.warning("THIS CHEST UNLINKING IS PERMANANT IF YOU LINK/UNLINK ANY OTHER CHESTS IN THIS PHATLOOT!");
        } else {
            Block block = world.getBlockAt(n, n2, n3);
            switch (block.getType()) {
                case DISPENSER: 
                case DROPPER: {
                    this.isDispenser = true;
                }
            }
        }
    }

    public static PhatLootChest getChest(Block block) {
        String string = PhatLootChest.toString(block = PhatLootsUtil.getLeftSide(block));
        if (chests.containsKey(string)) {
            return chests.get(string);
        }
        PhatLootChest phatLootChest = new PhatLootChest(block);
        chests.put(string, phatLootChest);
        return phatLootChest;
    }

    public static PhatLootChest getChest(String string, int n, int n2, int n3) {
        World world = Bukkit.getWorld((String)string);
        if (world == null) {
            return null;
        }
        return PhatLootChest.getChest(world.getBlockAt(n, n2, n3));
    }

    public static PhatLootChest getChest(String[] stringArray) {
        try {
            return PhatLootChest.getChest(stringArray[0], Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Collection<PhatLootChest> getChests() {
        return chests.values();
    }

    public static boolean isPhatLootChest(Block block) {
        String string = PhatLootChest.toString(PhatLootsUtil.getLeftSide(block));
        return chests.containsKey(string);
    }

    public boolean isDispenser() {
        return this.isDispenser;
    }

    public Block getBlock() {
        return Bukkit.getWorld((String)this.world).getBlockAt(this.x, this.y, this.z);
    }

    public boolean isInWorld(World world) {
        return world.getName().equals(this.world);
    }

    public LinkedList<PhatLoot> getLinkedPhatLoots() {
        LinkedList<PhatLoot> linkedList = new LinkedList<PhatLoot>();
        for (PhatLoot phatLoot : PhatLoots.getPhatLoots()) {
            if (!phatLoot.containsChest(this)) continue;
            linkedList.add(phatLoot);
        }
        return linkedList;
    }

    public void moveTo(Block block) {
        if (this.state != null) {
            this.state.update(true);
        }
        Block block2 = this.getBlock();
        block2.setType(Material.AIR);
        block2 = PhatLootsUtil.getLeftSide(block2);
        this.x = block.getX();
        this.y = block.getY();
        this.z = block.getZ();
        if (this.state == null) {
            block.setType(block2.getType());
            block.setData(block2.getData());
        } else {
            this.state = block.getState();
        }
    }

    public void breakChest(Player player, long l) {
        ChestBreakEvent chestBreakEvent = new ChestBreakEvent(this, player, l);
        Bukkit.getPluginManager().callEvent((Event)chestBreakEvent);
        if (chestBreakEvent.isCancelled()) {
            return;
        }
        if (chestBreakEvent.getRespawnTime() == 0L) {
            return;
        }
        chestsToRespawn.add(this);
        Block block = this.getBlock();
        this.state = block.getState();
        block.setType(Material.AIR);
        Block block2 = PhatLootsUtil.getLeftSide(block);
        if (!block2.equals(block)) {
            this.otherHalfState = block2.getState();
            block2.setType(Material.AIR);
        }
        if (chestBreakEvent.getRespawnTime() > 0L) {
            new BukkitRunnable(){

                public void run() {
                    PhatLootChest.this.respawn(ChestRespawnEvent.RespawnReason.INITIAL);
                }
            }.runTaskLater((Plugin)PhatLoots.plugin, chestBreakEvent.getRespawnTime());
        }
        if (soundOnBreak) {
            block.getWorld().playSound(block.getLocation(), Sound.ENTITY_ZOMBIE_BREAK_DOOR_WOOD, 1.0f, 1.0f);
        }
    }

    public void respawn(ChestRespawnEvent.RespawnReason respawnReason) {
        if (this.state != null) {
            ChestRespawnEvent chestRespawnEvent = new ChestRespawnEvent(this, 0L, respawnReason);
            Bukkit.getPluginManager().callEvent((Event)chestRespawnEvent);
            if (chestRespawnEvent.isCancelled()) {
                return;
            }
            if (chestRespawnEvent.getRespawnTime() > 0L) {
                new BukkitRunnable(){

                    public void run() {
                        PhatLootChest.this.respawn(ChestRespawnEvent.RespawnReason.DELAYED);
                    }
                }.runTaskLater((Plugin)PhatLoots.plugin, chestRespawnEvent.getRespawnTime());
            } else {
                Skull skull;
                Skull skull2;
                this.state.update(true);
                if (this.state instanceof Skull) {
                    skull2 = (Skull)this.state;
                    skull = (Skull)this.state.getBlock().getState();
                    skull.setSkullType(skull2.getSkullType());
                    skull.setRotation(skull2.getRotation());
                    skull.setOwner(skull2.getOwner());
                    skull.update();
                }
                this.state = null;
                if (this.otherHalfState != null) {
                    this.otherHalfState.update(true);
                    if (this.otherHalfState instanceof Skull) {
                        skull2 = (Skull)this.otherHalfState;
                        skull = (Skull)this.otherHalfState.getBlock().getState();
                        skull.setSkullType(skull2.getSkullType());
                        skull.setRotation(skull2.getRotation());
                        skull.setOwner(skull2.getOwner());
                        skull.update();
                    }
                    this.otherHalfState = null;
                }
                chestsToRespawn.remove(this);
            }
        }
    }

    public Inventory getInventory(String string, String string2) {
        return PhatLootChest.getInventory(string, string2, this);
    }

    public static Inventory getInventory(String string, String string2, PhatLootChest phatLootChest) {
        Inventory inventory;
        ForgettableInventory forgettableInventory;
        String string3;
        if (phatLootChest != null && phatLootChest.isDispenser) {
            string3 = phatLootChest.getBlock().getState();
            switch (string3.getType()) {
                case DISPENSER: {
                    return ((Dispenser)string3).getInventory();
                }
                case DROPPER: {
                    return ((Dropper)string3).getInventory();
                }
            }
            phatLootChest.isDispenser = false;
        }
        string3 = string;
        if (phatLootChest != null) {
            string3 = string3 + '@' + phatLootChest.toString();
        }
        if ((forgettableInventory = ForgettableInventory.get(string3)) != null) {
            inventory = forgettableInventory.getInventory();
        } else {
            string2 = chestName.replace("<name>", ChatColor.translateAlternateColorCodes((char)'&', (String)string2.replace('_', ' ')));
            if (phatLootChest != null) {
                Block block = phatLootChest.getBlock();
                switch (block.getType()) {
                    case TRAPPED_CHEST: 
                    case CHEST: {
                        inventory = ((Chest)block.getState()).getInventory();
                        break;
                    }
                    default: {
                        inventory = null;
                        break;
                    }
                }
            } else {
                inventory = null;
            }
            inventory = Bukkit.createInventory(null, (int)(inventory == null ? 27 : inventory.getSize()), (String)string2);
            forgettableInventory = new ForgettableInventory(string3, inventory);
        }
        forgettableInventory.schedule();
        return inventory;
    }

    public void addItems(Collection<ItemStack> collection, Player player, Inventory inventory) {
        for (ItemStack itemStack : collection) {
            this.addItem(itemStack, player, inventory);
        }
        if (shuffleLoot) {
            List<ItemStack> list = Arrays.asList(inventory.getContents());
            Collections.shuffle(list);
            inventory.setContents(list.toArray(new ItemStack[list.size()]));
        }
    }

    public void addItem(ItemStack itemStack, Player player, Inventory inventory) {
        Collection collection = inventory.addItem(new ItemStack[]{itemStack}).values();
        if (!collection.isEmpty()) {
            for (ItemStack itemStack2 : collection) {
                this.overFlow(itemStack2, player);
            }
        }
        if (this.isDispenser) {
            BlockState blockState = this.getBlock().getState();
            switch (blockState.getType()) {
                case DISPENSER: {
                    ItemStack itemStack2;
                    itemStack2 = (Dispenser)blockState;
                    while (inventory.firstEmpty() > 0) {
                        itemStack2.dispense();
                    }
                    break;
                }
                case DROPPER: {
                    Dropper dropper = (Dropper)blockState;
                    while (inventory.firstEmpty() > 0) {
                        dropper.drop();
                    }
                    break;
                }
                default: {
                    this.isDispenser = false;
                }
            }
        }
    }

    public void overFlow(ItemStack itemStack, Player player) {
        Block block = this.getBlock();
        block.getWorld().dropItemNaturally(block.getLocation(), itemStack);
        if (player != null && PhatLootsConfig.overflow != null) {
            String string = PhatLootsConfig.overflow.replace("<item>", PhatLootsUtil.getItemName(itemStack));
            int n = itemStack.getAmount();
            string = n > 1 ? string.replace("<amount>", String.valueOf(itemStack.getAmount())) : string.replace("x<amount>", "").replace("<amount>", String.valueOf(itemStack.getAmount()));
            player.sendMessage(string);
        }
    }

    public void openInventory(Player player, Inventory inventory, boolean bl) {
        if (this.isDispenser) {
            return;
        }
        openPhatLootChests.put(player.getUniqueId(), this);
        player.openInventory(inventory);
        switch (this.getBlock().getType()) {
            case TRAPPED_CHEST: {
                for (Block object : PhatLootChest.findRedstone(this.getBlock(), false)) {
                    PhatLootChest.trigger(object);
                }
            }
            case CHEST: 
            case ENDER_CHEST: {
                Location location = new Location(Bukkit.getWorld((String)this.world), (double)this.x, (double)this.y, (double)this.z);
                if (bl) {
                    if (inventory.getViewers().size() > 1) break;
                    for (Player player2 : player.getWorld().getPlayers()) {
                        player2.playSound(location, Sound.BLOCK_CHEST_OPEN, 0.75f, 0.95f);
                        ChestAnimations.openChest(this.getBlock());
                    }
                    break;
                }
                player.playSound(location, Sound.BLOCK_CHEST_OPEN, 0.75f, 0.95f);
                ChestAnimations.openChest(player, this.getBlock());
                break;
            }
        }
    }

    public void closeInventory(Player player, Inventory inventory, boolean bl) {
        openPhatLootChests.remove(player.getUniqueId());
        player.closeInventory();
        block0 : switch (this.getBlock().getType()) {
            case TRAPPED_CHEST: {
                for (Block location : PhatLootChest.findRedstone(this.getBlock(), true)) {
                    PhatLootChest.trigger(location);
                }
            }
            case CHEST: 
            case ENDER_CHEST: {
                Block block = this.getBlock();
                Location location = block.getLocation();
                if (bl) {
                    if (inventory.getViewers().size() >= 1) break;
                    for (Player player2 : player.getWorld().getPlayers()) {
                        switch (block.getType()) {
                            case TRAPPED_CHEST: 
                            case CHEST: 
                            case ENDER_CHEST: {
                                player2.playSound(location, Sound.BLOCK_CHEST_CLOSE, 0.75f, 0.95f);
                                ChestAnimations.closeChest(this.getBlock());
                                break;
                            }
                        }
                    }
                    if (!useBreakAndRepawn) {
                        return;
                    }
                    for (ItemStack itemStack : inventory.getContents()) {
                        if (itemStack == null || itemStack.getTypeId() == 0) continue;
                        return;
                    }
                    long l = this.getResetTime();
                    if (l <= 20L) break;
                    this.breakChest(player, l);
                    break;
                }
                switch (block.getType()) {
                    case TRAPPED_CHEST: 
                    case CHEST: 
                    case ENDER_CHEST: {
                        player.playSound(location, Sound.BLOCK_CHEST_CLOSE, 0.75f, 0.95f);
                        ChestAnimations.closeChest(player, this.getBlock());
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public long getResetTime() {
        return this.getResetTime(PhatLoots.getPhatLoots());
    }

    public long getResetTime(Collection<PhatLoot> collection) {
        long l = -1L;
        for (PhatLoot phatLoot : collection) {
            if (!phatLoot.containsChest(this) || !phatLoot.breakAndRespawn) continue;
            if (!phatLoot.global) break;
            long l2 = phatLoot.getTimeRemaining(this);
            if (l2 < 1L || l >= 0L && l2 >= l) continue;
            l = l2;
        }
        return l /= 50L;
    }

    private static LinkedList<Block> findRedstone(Block block, boolean bl) {
        EnumSet<Material> enumSet = bl ? triggeredRedstone : untriggeredRedstone;
        LinkedList<Block> linkedList = new LinkedList<Block>();
        Block block2 = block.getRelative(1, 0, 0);
        if (enumSet.contains(block2.getType())) {
            linkedList.add(block2);
        } else {
            block2 = block.getRelative(2, 0, 0);
            if (enumSet.contains(block2.getType())) {
                linkedList.add(block2);
            }
        }
        block2 = block.getRelative(0, 0, 1);
        if (enumSet.contains(block2.getType())) {
            linkedList.add(block2);
        } else {
            block2 = block.getRelative(0, 0, 2);
            if (enumSet.contains(block2.getType())) {
                linkedList.add(block2);
            }
        }
        block2 = block.getRelative(-1, 0, 0);
        if (enumSet.contains(block2.getType())) {
            linkedList.add(block2);
        } else {
            block2 = block.getRelative(-2, 0, 0);
            if (enumSet.contains(block2.getType())) {
                linkedList.add(block2);
            }
        }
        block2 = block.getRelative(0, 0, -1);
        if (enumSet.contains(block2.getType())) {
            linkedList.add(block2);
        } else {
            block2 = block.getRelative(0, 0, -2);
            if (enumSet.contains(block2.getType())) {
                linkedList.add(block2);
            }
        }
        block2 = block.getRelative(0, -1, 0);
        if (enumSet.contains(block2.getType())) {
            linkedList.add(block2);
        } else {
            block2 = block.getRelative(0, -2, 0);
            if (enumSet.contains(block2.getType())) {
                linkedList.add(block2);
            }
        }
        block2 = block.getRelative(1, -1, 0);
        if (enumSet.contains(block2.getType())) {
            linkedList.add(block2);
        } else {
            block2 = block.getRelative(2, -1, 0);
            if (enumSet.contains(block2.getType())) {
                linkedList.add(block2);
            }
        }
        block2 = block.getRelative(0, -1, 1);
        if (enumSet.contains(block2.getType())) {
            linkedList.add(block2);
        } else {
            block2 = block.getRelative(0, -1, 2);
            if (enumSet.contains(block2.getType())) {
                linkedList.add(block2);
            }
        }
        block2 = block.getRelative(-1, -11, 0);
        if (enumSet.contains(block2.getType())) {
            linkedList.add(block2);
        } else {
            block2 = block.getRelative(-2, -1, 0);
            if (enumSet.contains(block2.getType())) {
                linkedList.add(block2);
            }
        }
        block2 = block.getRelative(0, -1, -1);
        if (enumSet.contains(block2.getType())) {
            linkedList.add(block2);
        } else {
            block2 = block.getRelative(0, -1, -2);
            if (enumSet.contains(block2.getType())) {
                linkedList.add(block2);
            }
        }
        return linkedList;
    }

    private static void trigger(Block block) {
        switch (block.getType()) {
            case REDSTONE_WIRE: {
                block.setData((byte)(block.getData() ^ 0xF), true);
                break;
            }
            case REDSTONE_COMPARATOR_OFF: {
                block.setTypeId(Material.REDSTONE_COMPARATOR_ON.getId(), true);
                break;
            }
            case REDSTONE_LAMP_OFF: {
                block.setTypeId(Material.REDSTONE_LAMP_ON.getId(), true);
                break;
            }
            case REDSTONE_TORCH_OFF: {
                block.setTypeId(Material.REDSTONE_TORCH_ON.getId(), true);
                break;
            }
            case DIODE_BLOCK_OFF: {
                block.setTypeId(Material.DIODE_BLOCK_ON.getId(), true);
                break;
            }
            case DISPENSER: {
                ((Dispenser)block.getState()).dispense();
                break;
            }
            case DROPPER: {
                ((Dropper)block.getState()).drop();
                break;
            }
            case NOTE_BLOCK: {
                ((NoteBlock)block.getState()).play();
                break;
            }
            case PISTON_BASE: {
                block.setData((byte)(block.getData() ^ 8), true);
                break;
            }
            case TNT: {
                block.setTypeId(0);
                TNTPrimed tNTPrimed = (TNTPrimed)block.getWorld().spawnEntity(block.getLocation(), EntityType.PRIMED_TNT);
                tNTPrimed.setFuseTicks(80);
                break;
            }
            case REDSTONE_COMPARATOR_ON: {
                block.setTypeId(Material.REDSTONE_COMPARATOR_OFF.getId(), true);
                break;
            }
            case REDSTONE_LAMP_ON: {
                block.setTypeId(Material.REDSTONE_LAMP_OFF.getId(), true);
                break;
            }
            case REDSTONE_TORCH_ON: {
                block.setTypeId(Material.REDSTONE_TORCH_OFF.getId(), true);
                break;
            }
            case DIODE_BLOCK_ON: {
                block.setTypeId(Material.DIODE_BLOCK_OFF.getId(), true);
                break;
            }
        }
    }

    public static String toString(Block block) {
        return block.getWorld().getName() + "'" + block.getX() + "'" + block.getY() + "'" + block.getZ();
    }

    public String toString() {
        return this.world + "'" + this.x + "'" + this.y + "'" + this.z;
    }
}

