/*
 * Decompiled with CFR 0.152.
 */
package com.codisimus.plugins.phatloots;

import com.codisimus.plugins.phatloots.PhatLootChest;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsConfig;
import com.codisimus.plugins.phatloots.PhatLootsUtil;
import com.codisimus.plugins.phatloots.events.MobDropLootEvent;
import com.codisimus.plugins.phatloots.events.MobEquipEvent;
import com.codisimus.plugins.phatloots.events.PhatLootsEvent;
import com.codisimus.plugins.phatloots.events.PlayerLootEvent;
import com.codisimus.plugins.phatloots.events.PreMobDropLootEvent;
import com.codisimus.plugins.phatloots.events.PreMobEquipEvent;
import com.codisimus.plugins.phatloots.events.PrePlayerLootEvent;
import com.codisimus.plugins.phatloots.loot.CommandLoot;
import com.codisimus.plugins.phatloots.loot.Experience;
import com.codisimus.plugins.phatloots.loot.Loot;
import com.codisimus.plugins.phatloots.loot.LootBundle;
import com.codisimus.plugins.phatloots.loot.LootCollection;
import com.codisimus.plugins.phatloots.loot.Money;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;

@SerializableAs(value="PhatLoot")
public final class PhatLoot
implements ConfigurationSerializable {
    public static String current;
    public static String last;
    static boolean onlyDropLootOnPlayerKill;
    static boolean onlyDropExpOnPlayerKill;
    static boolean replaceMobLoot;
    static float chanceOfDrop;
    public static double lootingBonusPerLvl;
    static boolean decimals;
    static boolean unlink;
    static boolean soundOnAutoLoot;
    static boolean commandCooldown;
    public String name;
    public ArrayList<Loot> lootList;
    public int days;
    public int hours;
    public int minutes;
    public int seconds;
    public boolean global;
    public boolean round;
    public boolean autoLoot;
    public boolean breakAndRespawn;
    private HashSet<PhatLootChest> chests;
    private Properties lootTimes;

    public PhatLoot(String string) {
        this.chests = new HashSet();
        this.lootTimes = new Properties();
        this.name = string;
        this.lootList = new ArrayList();
        this.days = PhatLootsConfig.defaultDays;
        this.hours = PhatLootsConfig.defaultHours;
        this.minutes = PhatLootsConfig.defaultMinutes;
        this.seconds = PhatLootsConfig.defaultSeconds;
        this.global = PhatLootsConfig.defaultGlobal;
        this.round = PhatLootsConfig.defaultRound;
        this.autoLoot = PhatLootsConfig.defaultAutoLoot;
        this.breakAndRespawn = PhatLootsConfig.defaultBreakAndRespawn;
    }

    public long getTimeRemaining(Player player) {
        return this.getTimeRemaining(player, null);
    }

    public long getTimeRemaining(PhatLootChest phatLootChest) {
        return this.getTimeRemaining(null, phatLootChest);
    }

    public long getTimeRemaining(Player player, PhatLootChest phatLootChest) {
        if (this.days == 0 && this.hours == 0 && this.minutes == 0 && this.seconds == 0) {
            return 0L;
        }
        String string = this.lootTimes.getProperty(this.getKey(player, phatLootChest));
        long l = 0L;
        if (string == null) {
            return 0L;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            PhatLoots.logger.severe("Fixed corrupted time value!");
        }
        if (this.days < 0 || this.hours < 0 || this.minutes < 0 || this.seconds < 0) {
            return -1L;
        }
        return Math.max((l += (long)this.days * 86400000L + (long)this.hours * 3600000L + (long)this.minutes * 60000L + (long)this.seconds * 1000L) - System.currentTimeMillis(), 0L);
    }

    public String timeToString(long l) {
        if (l < 0L) {
            return "forever";
        }
        if (l > 86400000L) {
            return l / 86400000L + " day(s)";
        }
        if (l > 3600000L) {
            return l / 3600000L + " hour(s)";
        }
        if (l > 60000L) {
            return l / 60000L + " minute(s)";
        }
        if (l > 1000L) {
            return l / 1000L + " second(s)";
        }
        return l + " millisecond(s)";
    }

    public void setTime(Player player, PhatLootChest phatLootChest) {
        Calendar calendar = Calendar.getInstance();
        if (this.round && this.seconds == 0) {
            calendar.clear(13);
            if (this.minutes == 0) {
                calendar.clear(12);
                if (this.hours == 0) {
                    calendar.clear(11);
                }
            }
        }
        this.lootTimes.setProperty(this.getKey(player, phatLootChest), String.valueOf(calendar.getTimeInMillis()));
    }

    public void rollForLoot(Player player) {
        this.rollForLoot(player, null);
    }

    public void rollForLoot(Player player, String string) {
        this.rollForChestLoot(player, null, string);
    }

    public boolean rollForChestLoot(Player player, PhatLootChest phatLootChest) {
        return this.rollForChestLoot(player, phatLootChest, null);
    }

    public boolean rollForChestLoot(Player player, PhatLootChest phatLootChest, String string) {
        return this.rollForChestLoot(player, phatLootChest, string, false);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean rollForChestLoot(Player var1_1, PhatLootChest var2_2, String var3_3, boolean var4_4) {
        block47: {
            block46: {
                var5_5 = false;
                if (var3_3 == null) {
                    var3_3 = this.name;
                }
                if ((var6_6 = this.getTimeRemaining(var1_1, var2_2)) != 0L && (var2_2 != null || PhatLoot.commandCooldown)) {
                    if (var2_2 == null) {
                        var8_7 = PhatLootsConfig.commandTimeRemaining;
                    } else {
                        var9_9 = var2_2.getInventory(this.getUser(var1_1), var3_3);
                        if (var1_1.getOpenInventory().getTopInventory() != var9_9) {
                            var2_2.openInventory(var1_1, var9_9, this.global);
                        }
                        if (var2_2.isDispenser()) {
                            var8_7 = PhatLootsConfig.dispenserTimeRemaining;
                        } else {
                            var10_11 = true;
                            for (ItemStack var14_18 : var9_9.getContents()) {
                                if (var14_18 == null || var14_18.getType() == Material.AIR) continue;
                                var10_11 = false;
                                break;
                            }
                            v0 = var8_7 = var10_11 != false ? PhatLootsConfig.emptyChestTimeRemaining : PhatLootsConfig.chestTimeRemaining;
                        }
                    }
                    if (var6_6 > 0L && var8_7 != null) {
                        var1_1.sendMessage(var8_7.replace("<time>", this.timeToString(var6_6)));
                    }
                    return var5_5;
                }
                var8_8 = new PrePlayerLootEvent(var1_1, this, var2_2, 0.0);
                Bukkit.getPluginManager().callEvent((Event)var8_8);
                if (var8_8.isCancelled()) {
                    return var5_5;
                }
                var9_10 = this.rollForLoot(var8_8.getLootingBonus());
                var10_12 = new PlayerLootEvent(var1_1, this, var2_2, var9_10);
                Bukkit.getPluginManager().callEvent((Event)var10_12);
                if (var10_12.isCancelled()) {
                    return var5_5;
                }
                var11_14 = var9_10.getMoney();
                if (!(var11_14 > 0.0)) break block46;
                if (PhatLoots.econ != null) {
                    var13_17 = PhatLoots.econ.depositPlayer((OfflinePlayer)var1_1, var11_14);
                    if (var13_17.transactionSuccess() && PhatLootsConfig.moneyLooted != null) {
                        var14_19 = PhatLoots.econ.format(var11_14).replace(".00", "");
                        var1_1.sendMessage(PhatLootsConfig.moneyLooted.replace("<amount>", (CharSequence)var14_19));
                    }
                } else {
                    var1_1.sendMessage("\u00a76Vault \u00a74is not enabled, so no money can be processed.");
                }
                break block47;
            }
            if (!(var11_14 < 0.0)) break block47;
            var11_14 *= -1.0;
            if (PhatLoots.econ == null) ** GOTO lbl55
            var13_17 = PhatLoots.econ.withdrawPlayer((OfflinePlayer)var1_1, var11_14);
            var14_19 = PhatLoots.econ.format(var11_14).replace(".00", "");
            if (var13_17.transactionSuccess()) {
                if (PhatLootsConfig.moneyCharged != null) {
                    var1_1.sendMessage(PhatLootsConfig.moneyCharged.replace("<amount>", (CharSequence)var14_19));
                }
            } else {
                if (PhatLootsConfig.insufficientFunds != null) {
                    var1_1.sendMessage(PhatLootsConfig.insufficientFunds.replace("<amount>", (CharSequence)var14_19));
                }
                return var5_5;
lbl55:
                // 1 sources

                var1_1.sendMessage("\u00a76Vault \u00a74is not enabled, so no money can be processed.");
                return var5_5;
            }
        }
        if (var9_10.getExp() > 0) {
            var1_1.giveExp(var9_10.getExp());
            if (PhatLootsConfig.experienceLooted != null) {
                var1_1.sendMessage(PhatLootsConfig.experienceLooted.replace("<amount>", String.valueOf(var9_10.getExp())));
            }
        }
        for (Object var14_19 : var9_10.getCommandList()) {
            var14_19.execute(var1_1);
        }
        for (Object var14_19 : var9_10.getMessageList()) {
            var1_1.sendMessage((String)var14_19);
        }
        var13_17 = var9_10.getItemList();
        var14_19 = PhatLootChest.getInventory(this.getUser(var1_1), var3_3, var2_2);
        if (var1_1.getOpenInventory().getTopInventory() != var14_19) {
            var14_19.clear();
        }
        if (this.autoLoot) {
            var15_20 = var1_1.getInventory().addItem(var13_17.toArray(new ItemStack[var13_17.size()]));
            if (PhatLootsConfig.autoLoot != null) {
                var16_21 = 0;
                var17_24 = var13_17.iterator();
                while (var17_24.hasNext()) {
                    var18_26 = (ItemStack)var17_24.next();
                    var19_28 = PhatLootsConfig.autoLoot.replace("<item>", PhatLootsUtil.getItemName((ItemStack)var18_26));
                    var20_29 = var18_26.getAmount();
                    if (var15_20.containsKey(var16_21)) {
                        var20_29 -= ((ItemStack)var15_20.get(var16_21)).getAmount();
                    }
                    if (var20_29 > 0) {
                        var19_28 = var20_29 > 1 ? var19_28.replace("<amount>", String.valueOf(var18_26.getAmount())) : var19_28.replace("x<amount>", "").replace("<amount>", String.valueOf(var18_26.getAmount()));
                        var1_1.sendMessage(var19_28);
                    }
                    ++var16_21;
                }
            }
            var13_17 = var15_20.values();
        }
        if (this.global && var4_4) {
            var15_20 = var2_2 == null ? var1_1.getLocation() : var2_2.getBlock().getLocation().add(0.5, 0.5, 0.5);
            var16_22 = var13_17.iterator();
            while (var16_22.hasNext()) {
                var17_24 = (ItemStack)var16_22.next();
                var1_1.getWorld().dropItemNaturally((Location)var15_20, (ItemStack)var17_24);
            }
            for (String var19_28 : var14_19.getContents()) {
                if (var19_28 == null || var19_28.getType() == Material.AIR) continue;
                var1_1.getWorld().dropItemNaturally((Location)var15_20, (ItemStack)var19_28);
            }
            var14_19.clear();
            var5_5 = true;
        } else if (var2_2 == null) {
            if (!var13_17.isEmpty()) {
                var15_20 = var13_17.iterator();
                while (var15_20.hasNext()) {
                    var16_23 = (ItemStack)var15_20.next();
                    var17_24 = var14_19.addItem(new ItemStack[]{var16_23}).values();
                    if (var17_24.isEmpty()) continue;
                    var18_26 = var17_24.iterator();
                    while (var18_26.hasNext()) {
                        var19_28 = (ItemStack)var18_26.next();
                        var1_1.getWorld().dropItemNaturally(var1_1.getLocation(), (ItemStack)var19_28);
                        if (PhatLootsConfig.overflow == null) continue;
                        var20_31 = PhatLootsConfig.overflow.replace("<item>", PhatLootsUtil.getItemName((ItemStack)var19_28));
                        var21_32 = var19_28.getAmount();
                        var20_31 = var21_32 > 1 ? var20_31.replace("<amount>", String.valueOf(var19_28.getAmount())) : var20_31.replace("x<amount>", "").replace("<amount>", String.valueOf(var19_28.getAmount()));
                        var1_1.sendMessage(var20_31);
                    }
                }
                var1_1.openInventory((Inventory)var14_19);
            }
        } else if (!var13_17.isEmpty()) {
            var2_2.addItems((Collection<ItemStack>)var13_17, var1_1, (Inventory)var14_19);
            if (var1_1.getOpenInventory().getTopInventory() != var14_19) {
                var2_2.openInventory(var1_1, (Inventory)var14_19, this.global);
            }
        } else if (!this.autoLoot) {
            if (var1_1.getOpenInventory().getTopInventory() != var14_19) {
                var2_2.openInventory(var1_1, (Inventory)var14_19, this.global);
            }
        } else {
            v1 = var5_5 = PhatLootChest.useBreakAndRepawn != false && this.breakAndRespawn != false;
        }
        if (PhatLootsConfig.lootMessage != null) {
            var1_1.sendMessage(PhatLootsConfig.lootMessage.replace("<phatloot>", this.name));
        }
        if (PhatLootsConfig.lootBroadcast != null) {
            Bukkit.broadcastMessage((String)PhatLootsConfig.lootBroadcast.replace("<name>", var1_1.getName()).replace("<phatloot>", this.name));
        }
        if (!var4_4) {
            var1_1.updateInventory();
        }
        this.setTime(var1_1, var2_2);
        return var5_5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int rollForMobDrops(LivingEntity livingEntity, Player player, List<ItemStack> list) {
        Object object;
        LootBundle lootBundle;
        block23: {
            String string;
            double d;
            block24: {
                long l;
                if (onlyDropLootOnPlayerKill && player == null) {
                    list.clear();
                }
                if (onlyDropExpOnPlayerKill && player == null) {
                    return 0;
                }
                if (replaceMobLoot) {
                    Iterator<ItemStack> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ItemStack itemStack = iterator.next();
                        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) continue;
                        iterator.remove();
                    }
                }
                if ((l = this.getTimeRemaining(player)) > 0L) {
                    if (player != null && PhatLootsConfig.mobTimeRemaining != null) {
                        player.sendMessage(PhatLootsConfig.mobTimeRemaining.replace("<time>", this.timeToString(l)));
                    }
                    return 0;
                }
                ItemStack itemStack = player == null ? null : player.getInventory().getItemInMainHand();
                double d2 = itemStack == null ? 0.0 : lootingBonusPerLvl * (double)itemStack.getEnchantmentLevel(Enchantment.LOOT_BONUS_MOBS);
                PreMobDropLootEvent preMobDropLootEvent = new PreMobDropLootEvent(livingEntity, player, d2);
                Bukkit.getPluginManager().callEvent((Event)preMobDropLootEvent);
                if (preMobDropLootEvent.isCancelled()) {
                    return 0;
                }
                lootBundle = this.rollForLoot(new LootBundle(list), preMobDropLootEvent.getLootingBonus());
                if (player != null && lootBundle.getMoney() > 0.0 && (player.getGameMode().equals((Object)GameMode.CREATIVE) || !player.hasPermission("phatloots.moneyfrommobs"))) {
                    lootBundle.setMoney(0.0);
                }
                MobDropLootEvent mobDropLootEvent = new MobDropLootEvent(livingEntity, player, lootBundle);
                Bukkit.getPluginManager().callEvent((Event)mobDropLootEvent);
                if (mobDropLootEvent.isCancelled()) {
                    list.clear();
                    return 0;
                }
                if (player == null) break block23;
                d = lootBundle.getMoney();
                if (decimals) {
                    d /= 100.0;
                }
                if (!(d > 0.0)) break block24;
                if (PhatLoots.econ != null) {
                    object = PhatLoots.econ.depositPlayer((OfflinePlayer)player, d);
                    if (object.transactionSuccess() && PhatLootsConfig.moneyLooted != null) {
                        string = PhatLoots.econ.format(d).replace(".00", "");
                        player.sendMessage(PhatLootsConfig.mobDroppedMoney.replace("<amount>", string));
                    }
                    break block23;
                } else {
                    PhatLoots.logger.warning("\u00a76Vault \u00a74is not enabled, so no money can be processed.");
                }
                break block23;
            }
            if (d < 0.0) {
                d *= -1.0;
                if (PhatLoots.econ == null) {
                    PhatLoots.logger.warning("\u00a76Vault \u00a74is not enabled, so no money can be processed.");
                    list.clear();
                    return 0;
                }
                object = PhatLoots.econ.withdrawPlayer((OfflinePlayer)player, d);
                string = PhatLoots.econ.format(d).replace(".00", "");
                if (object.transactionSuccess()) {
                    if (PhatLootsConfig.moneyCharged != null) {
                        player.sendMessage(PhatLootsConfig.moneyCharged.replace("<amount>", string));
                    }
                } else {
                    if (PhatLootsConfig.insufficientFunds != null) {
                        player.sendMessage(PhatLootsConfig.insufficientFunds.replace("<amount>", string));
                    }
                    list.clear();
                    return 0;
                }
            }
        }
        for (CommandLoot commandLoot : lootBundle.getCommandList()) {
            commandLoot.execute(player);
        }
        if (player != null && PhatLootsConfig.mobDroppedItem != null) {
            for (ItemStack itemStack : list) {
                object = PhatLootsConfig.mobDroppedItem.replace("<item>", PhatLootsUtil.getItemName(itemStack));
                int n = itemStack.getAmount();
                object = n > 1 ? ((String)object).replace("<amount>", String.valueOf(n)) : ((String)object).replace("x<amount>", "").replace("<amount>", String.valueOf(n));
                player.sendMessage((String)object);
            }
        }
        if (lootBundle.getExp() > 0 && player != null && PhatLootsConfig.mobDroppedExperience != null) {
            player.sendMessage(PhatLootsConfig.mobDroppedExperience.replace("<amount>", String.valueOf(lootBundle.getExp())));
        }
        return lootBundle.getExp();
    }

    public void rollForEquipment(LivingEntity livingEntity, double d) {
        Object object;
        PreMobEquipEvent preMobEquipEvent = new PreMobEquipEvent(livingEntity, d);
        Bukkit.getPluginManager().callEvent((Event)preMobEquipEvent);
        if (preMobEquipEvent.isCancelled()) {
            return;
        }
        List<ItemStack> list = this.rollForLoot(preMobEquipEvent.getLootingBonus()).getItemList();
        if (list.size() != 5 && list.size() != 6) {
            PhatLoots.logger.warning("Cannot add loot to " + livingEntity.getType().toString() + " because the amount of loot was not equal to 5 (or 6 if including a Potion)");
            return;
        }
        EntityEquipment entityEquipment = livingEntity.getEquipment();
        entityEquipment.clear();
        entityEquipment.setItemInMainHand(list.remove(0));
        entityEquipment.setHelmet(list.remove(0));
        entityEquipment.setChestplate(list.remove(0));
        entityEquipment.setLeggings(list.remove(0));
        entityEquipment.setBoots(list.remove(0));
        entityEquipment.setItemInMainHandDropChance(chanceOfDrop);
        entityEquipment.setHelmetDropChance(chanceOfDrop);
        entityEquipment.setChestplateDropChance(chanceOfDrop);
        entityEquipment.setLeggingsDropChance(chanceOfDrop);
        entityEquipment.setBootsDropChance(chanceOfDrop);
        PotionMeta potionMeta = null;
        if (list.size() > 0) {
            object = list.remove(0);
            if (object.getType() != Material.POTION) {
                PhatLoots.logger.warning("Extra Equipment for " + livingEntity.getType().toString() + " is not a Potion");
            } else {
                potionMeta = (PotionMeta)object.getItemMeta();
            }
        }
        object = new MobEquipEvent(livingEntity, potionMeta);
        Bukkit.getPluginManager().callEvent((Event)object);
        if (((PhatLootsEvent)((Object)object)).isCancelled()) {
            entityEquipment.clear();
        } else {
            potionMeta = ((MobEquipEvent)((Object)object)).getPotionMeta();
            if (potionMeta != null) {
                livingEntity.addPotionEffects((Collection)potionMeta.getCustomEffects());
            }
        }
    }

    public LootBundle rollForLoot() {
        return this.rollForLoot(0.0);
    }

    public LootBundle rollForLoot(double d) {
        return this.rollForLoot(new LootBundle(), d);
    }

    public LootBundle rollForLoot(LootBundle lootBundle, double d) {
        for (Loot loot : this.lootList) {
            if (!loot.rollForLoot(d)) continue;
            loot.getLoot(lootBundle, d);
        }
        return lootBundle;
    }

    private String getKey(Player player, PhatLootChest phatLootChest) {
        String string = this.getUser(player);
        return phatLootChest == null ? string : phatLootChest.toString() + "'" + string;
    }

    private String getUser(Player player) {
        return this.global || player == null ? "global" : player.getUniqueId().toString();
    }

    public Collection<PhatLootChest> getChests() {
        return this.chests;
    }

    public boolean containsChest(PhatLootChest phatLootChest) {
        return this.chests.contains(phatLootChest);
    }

    public void addChest(Block block) {
        this.addChest(PhatLootChest.getChest(block));
    }

    public void addChest(PhatLootChest phatLootChest) {
        this.chests.add(phatLootChest);
    }

    public void removeChest(Block block) {
        this.removeChest(PhatLootChest.getChest(block));
    }

    public void removeChest(PhatLootChest phatLootChest) {
        this.chests.remove(phatLootChest);
    }

    public void removeChests() {
        this.chests.clear();
    }

    public boolean addLoot(Loot loot) {
        for (Loot loot2 : this.lootList) {
            if (!loot2.equals(loot)) continue;
            return false;
        }
        this.lootList.add(loot);
        return true;
    }

    public boolean removeLoot(Loot loot) {
        Iterator<Loot> iterator = this.lootList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(loot)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public LootCollection findCollection(String string) {
        for (Loot loot : this.lootList) {
            LootCollection lootCollection;
            if (!(loot instanceof LootCollection) || (lootCollection = ((LootCollection)loot).findCollection(string)) == null) continue;
            return lootCollection;
        }
        return null;
    }

    public void reset(Block block) {
        if (block == null) {
            this.lootTimes.clear();
        } else {
            String string = PhatLootChest.getChest(block).toString();
            for (String string2 : this.lootTimes.stringPropertyNames()) {
                if (!string2.startsWith(string)) continue;
                this.lootTimes.remove(string2);
                break;
            }
        }
    }

    public void resetForWorld(World world) {
        this.removeLootTimes(world.getName());
    }

    public void resetForPlayer(Player player) {
        this.removeLootTimes(player.getUniqueId().toString());
    }

    private void removeLootTimes(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : this.lootTimes.stringPropertyNames()) {
            if (!string2.startsWith(string + "'")) continue;
            linkedList.add(string2);
        }
        for (String string2 : linkedList) {
            this.lootTimes.remove(string2);
        }
    }

    public void clean(Block block) {
        Set<String> set;
        if (this.days == 0 && this.hours == 0 && this.minutes == 0 && this.seconds == 0) {
            this.reset(block);
            return;
        }
        if (this.days < 0 || this.hours < 0 || this.minutes < 0 || this.seconds < 0) {
            return;
        }
        if (block == null) {
            set = this.lootTimes.stringPropertyNames();
        } else {
            set = new HashSet<String>();
            String string = PhatLootChest.getChest(block).toString();
            for (String object : this.lootTimes.stringPropertyNames()) {
                if (!object.startsWith(string)) continue;
                set.add(object);
            }
        }
        long l = System.currentTimeMillis() - (long)this.days * 86400000L - (long)this.hours * 3600000L - (long)this.minutes * 60000L - (long)this.seconds * 1000L;
        for (String string : set) {
            if (Long.parseLong(this.lootTimes.getProperty(string)) >= l) continue;
            this.lootTimes.remove(string);
        }
    }

    public void saveAll() {
        this.save();
        this.saveLootTimes();
        this.saveChests();
    }

    public void saveLootTimes() {
        if (this.lootTimes.isEmpty()) {
            return;
        }
        File file = new File(PhatLoots.dataFolder, "LootTimes" + File.separator + this.name + ".properties");
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.lootTimes.store(fileOutputStream, null);
        }
        catch (IOException iOException) {
            PhatLoots.logger.log(Level.SEVERE, "Save Failed!", iOException);
        }
    }

    public void loadLootTimes() {
        File file = new File(PhatLoots.dataFolder, "LootTimes" + File.separator + this.name + ".properties");
        if (!file.exists()) {
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.lootTimes.load(fileInputStream);
        }
        catch (IOException iOException) {
            PhatLoots.logger.log(Level.SEVERE, "Load Failed!", iOException);
        }
        this.clean(null);
    }

    public void saveChests() {
        File file = new File(PhatLoots.dataFolder, "Chests" + File.separator + this.name + ".txt");
        if (this.chests.isEmpty()) {
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        try (FileWriter fileWriter = new FileWriter(file);
             PrintWriter printWriter = new PrintWriter(fileWriter);){
            for (PhatLootChest phatLootChest : this.getChests()) {
                printWriter.println(phatLootChest.toString());
            }
        }
        catch (IOException iOException) {
            PhatLoots.logger.log(Level.SEVERE, "Save Failed!", iOException);
        }
    }

    public final void loadChests() {
        File file = new File(PhatLoots.dataFolder, "Chests" + File.separator + this.name + ".txt");
        if (!file.exists()) {
            return;
        }
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNextLine()) {
                String string = scanner.nextLine();
                String[] stringArray = string.split("'");
                if (stringArray.length == 4) {
                    this.chests.add(PhatLootChest.getChest(stringArray));
                    continue;
                }
                PhatLoots.logger.severe("Invalid chest data for PhatLoot: " + this.name);
                PhatLoots.logger.severe("Failed line of data: " + string);
            }
        }
        catch (IOException iOException) {
            PhatLoots.logger.log(Level.SEVERE, "Load Failed!", iOException);
        }
    }

    public void save() {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.set(this.name, (Object)this);
        File file = new File(PhatLoots.dataFolder, "LootTables" + File.separator + this.name + ".yml");
        String string = yamlConfiguration.saveToString();
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            outputStreamWriter.write(string, 0, string.length());
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            PhatLoots.logger.log(Level.SEVERE, "Could not save PhatLoot " + this.name, iOException);
        }
    }

    public Map<String, Object> serialize() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Name", this.name);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("Days", this.days);
        hashMap.put("Hours", this.hours);
        hashMap.put("Minutes", this.minutes);
        hashMap.put("Seconds", this.seconds);
        treeMap.put("Reset", hashMap);
        treeMap.put("Global", this.global);
        treeMap.put("RoundDownTime", this.round);
        treeMap.put("AutoLoot", this.autoLoot);
        treeMap.put("BreakAndRespawn", this.breakAndRespawn);
        treeMap.put("LootList", this.lootList);
        return treeMap;
    }

    public PhatLoot(Map<String, Object> map) {
        block7: {
            this.chests = new HashSet();
            this.lootTimes = new Properties();
            String string = null;
            try {
                int n;
                int n2;
                string = "Name";
                current = this.name = (String)map.get("Name");
                string = "Reset";
                Map map2 = (Map)map.get("Reset");
                string = "Days";
                this.days = (Integer)map2.get("Days");
                string = "Hours";
                this.hours = (Integer)map2.get("Hours");
                string = "Minutes";
                this.minutes = (Integer)map2.get("Minutes");
                string = "Seconds";
                this.seconds = (Integer)map2.get("Seconds");
                string = "Global";
                this.global = (Boolean)map.get("Global");
                string = "RoundDownTime";
                this.round = (Boolean)map.get("RoundDownTime");
                string = "AutoLoot";
                this.autoLoot = (Boolean)map.get("AutoLoot");
                if (map.containsKey("BreakAndRespawn")) {
                    string = "BreakAndRespawn";
                    this.breakAndRespawn = (Boolean)map.get("BreakAndRespawn");
                }
                string = "LootList";
                if (map.containsKey("LootList")) {
                    string = "LootList";
                    this.lootList = (ArrayList)map.get("LootList");
                } else {
                    PhatLoots.logger.warning("Your save files are outdated, please use version 3.1-3.2 to update them");
                }
                if (map.containsKey("Money")) {
                    string = "Money";
                    map2 = (Map)map.get("Money");
                    string = "Lower";
                    n2 = (Integer)map2.get("Lower");
                    string = "Upper";
                    n = (Integer)map2.get("Upper");
                    this.lootList.add(new Money(n2, n));
                }
                if (map.containsKey("Exp")) {
                    string = "Exp";
                    map2 = (Map)map.get("Exp");
                    string = "Lower";
                    n2 = (Integer)map2.get("Lower");
                    string = "Upper";
                    n = (Integer)map2.get("Upper");
                    this.lootList.add(new Experience(n2, n));
                }
            }
            catch (Exception exception) {
                PhatLoots.logger.severe("Failed to load line: " + string);
                PhatLoots.logger.severe("of PhatLoot: " + (current == null ? "unknown" : current));
                if (current != null) break block7;
                PhatLoots.logger.severe("Last successful load was...");
                PhatLoots.logger.severe("PhatLoot: " + (last == null ? "unknown" : last));
            }
        }
        last = current;
        current = null;
        this.loadChests();
        this.loadLootTimes();
    }
}

