/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerUpdateTask
extends BukkitRunnable {
    private static Map<UUID, Player> PLAYERS = new HashMap<UUID, Player>();
    private static List<Entity> PLAYERS_PENDING_ADD = new ArrayList<Entity>();
    private static List<Entity> PLAYERS_PENDING_REMOVE = new ArrayList<Entity>();
    private static Map<UUID, Entity> TICKERS = new HashMap<UUID, Entity>();
    private static List<Entity> TICKERS_PENDING_ADD = new ArrayList<Entity>();
    private static List<Entity> TICKERS_PENDING_REMOVE = new ArrayList<Entity>();

    public void cancel() {
        super.cancel();
        TICKERS.clear();
        TICKERS_PENDING_ADD.clear();
        TICKERS_PENDING_REMOVE.clear();
    }

    public void run() {
        int i;
        for (i = 0; i < TICKERS_PENDING_ADD.size(); ++i) {
            Entity ent = TICKERS_PENDING_ADD.get(i);
            TICKERS.put(ent.getUniqueId(), ent);
        }
        for (i = 0; i < TICKERS_PENDING_REMOVE.size(); ++i) {
            TICKERS.remove(TICKERS_PENDING_REMOVE.get(i).getUniqueId());
        }
        TICKERS_PENDING_ADD.clear();
        TICKERS_PENDING_REMOVE.clear();
        Iterator<Entity> itr = TICKERS.values().iterator();
        while (itr.hasNext()) {
            Entity entity = itr.next();
            if (!NMS.tick(entity)) continue;
            itr.remove();
        }
        for (Entity entity : PLAYERS_PENDING_REMOVE) {
            PLAYERS.remove(entity.getUniqueId());
        }
        for (Entity entity : PLAYERS_PENDING_ADD) {
            PLAYERS.put(entity.getUniqueId(), (Player)entity);
        }
        PLAYERS_PENDING_ADD.clear();
        PLAYERS_PENDING_REMOVE.clear();
        for (Player player : PLAYERS.values()) {
            if (!player.isValid()) continue;
            NMS.playerTick(player);
        }
    }

    public static void addOrRemove(Entity entity, boolean remove) {
        boolean contains = TICKERS.containsKey(entity.getUniqueId());
        if (!remove) {
            if (contains) {
                TICKERS_PENDING_REMOVE.add(entity);
            }
        } else if (!contains) {
            TICKERS_PENDING_ADD.add(entity);
        }
    }

    public static void deregisterPlayer(Entity entity) {
        PLAYERS_PENDING_ADD.remove(entity);
        PLAYERS_PENDING_REMOVE.add(entity);
    }

    public static void registerPlayer(Entity entity) {
        PLAYERS_PENDING_REMOVE.remove(entity);
        PLAYERS_PENDING_ADD.add(entity);
    }
}

