/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.SitTrait;
import net.citizensnpcs.trait.SleepTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scheduler.BukkitRunnable;

public enum PlayerAnimation {
    ARM_SWING,
    ARM_SWING_OFFHAND,
    CRIT,
    EAT_FOOD,
    HURT,
    LEAVE_BED,
    MAGIC_CRIT,
    SIT,
    SLEEP,
    SNEAK,
    START_ELYTRA,
    START_USE_MAINHAND_ITEM,
    START_USE_OFFHAND_ITEM,
    STOP_ELYTRA,
    STOP_SITTING,
    STOP_SLEEPING,
    STOP_SNEAKING,
    STOP_USE_ITEM;


    public void play(Player player) {
        this.play(player, 64);
    }

    public void play(final Player player, int radius) {
        if (this == SIT) {
            if (player instanceof NPCHolder) {
                ((NPCHolder)player).getNPC().getOrAddTrait(SitTrait.class).setSitting(player.getLocation());
                return;
            }
            player.setMetadata("citizens.sitting", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
            NPCRegistry registry = CitizensAPI.getNamedNPCRegistry("PlayerAnimationImpl");
            if (registry == null) {
                registry = CitizensAPI.createNamedNPCRegistry("PlayerAnimationImpl", new MemoryNPCDataStore());
            }
            final NPC holder = registry.createNPC(EntityType.ARMOR_STAND, "");
            holder.getOrAddTrait(ArmorStandTrait.class).setAsPointEntity();
            holder.spawn(player.getLocation());
            new BukkitRunnable(){

                public void cancel() {
                    super.cancel();
                    holder.destroy();
                }

                public void run() {
                    if (!(player.isValid() && player.hasMetadata("citizens.sitting") && ((MetadataValue)player.getMetadata("citizens.sitting").get(0)).asBoolean())) {
                        this.cancel();
                        return;
                    }
                    if (!NMS.getPassengers(holder.getEntity()).contains(player)) {
                        NMS.mount(holder.getEntity(), (Entity)player);
                    }
                }
            }.runTaskTimer(CitizensAPI.getPlugin(), 0L, 1L);
            return;
        }
        if (this == STOP_SITTING) {
            if (player instanceof NPCHolder) {
                ((NPCHolder)player).getNPC().getOrAddTrait(SitTrait.class).setSitting(null);
                return;
            }
            player.setMetadata("citizens.sitting", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)false));
            NMS.mount((Entity)player, null);
            return;
        }
        if (this == SLEEP) {
            if (player instanceof NPCHolder) {
                ((NPCHolder)player).getNPC().getOrAddTrait(SleepTrait.class).setSleeping(player.getLocation());
                return;
            }
            NMS.sleep(player, true);
        } else if (this == STOP_SLEEPING) {
            if (player instanceof NPCHolder) {
                ((NPCHolder)player).getNPC().getOrAddTrait(SleepTrait.class).setSleeping(null);
                return;
            }
            NMS.sleep(player, false);
        }
        NMS.playAnimation(this, player, radius);
    }
}

