/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.NMSBridge;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wither;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class NMS {
    private static Method ADD_OPENS;
    private static NMSBridge BRIDGE;
    private static Method GET_MODULE;
    private static MethodHandles.Lookup LOOKUP;
    private static Field MODIFIERS_FIELD;
    private static Object UNSAFE;
    private static MethodHandle UNSAFE_FIELD_OFFSET;
    private static MethodHandle UNSAFE_PUT_OBJECT;
    private static MethodHandle UNSAFE_STATIC_FIELD_OFFSET;

    private NMS() {
    }

    public static boolean addEntityToWorld(Entity entity, CreatureSpawnEvent.SpawnReason custom) {
        return BRIDGE.addEntityToWorld(entity, custom);
    }

    public static void addOrRemoveFromPlayerList(Entity entity, boolean remove) {
        BRIDGE.addOrRemoveFromPlayerList(entity, remove);
    }

    public static void attack(LivingEntity attacker, LivingEntity bukkitTarget) {
        BRIDGE.attack(attacker, bukkitTarget);
    }

    public static void cancelMoveDestination(Entity entity) {
        BRIDGE.cancelMoveDestination(entity);
    }

    public static GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) throws Throwable {
        return BRIDGE.fillProfileProperties(profile, requireSecure);
    }

    public static BlockBreaker getBlockBreaker(Entity entity, Block targetBlock, BlockBreaker.BlockBreakerConfiguration config) {
        return BRIDGE.getBlockBreaker(entity, targetBlock, config);
    }

    public static Object getBossBar(Entity entity) {
        return BRIDGE.getBossBar(entity);
    }

    public static BoundingBox getBoundingBox(Entity handle) {
        return BRIDGE.getBoundingBox(handle);
    }

    public static BoundingBox getCollisionBox(Block block) {
        if (block.getType() == Material.AIR) {
            return BoundingBox.EMPTY;
        }
        return BRIDGE.getCollisionBox(block).add(block.getX(), block.getY(), block.getZ());
    }

    public static Location getDestination(Entity entity) {
        return BRIDGE.getDestination(entity);
    }

    public static Field getField(Class<?> clazz, String field) {
        return NMS.getField(clazz, field, true);
    }

    public static Field getField(Class<?> clazz, String field, boolean log) {
        if (clazz == null) {
            return null;
        }
        Field f = null;
        try {
            f = clazz.getDeclaredField(field);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            if (log) {
                Messaging.logTr("citizens.nms-errors.getting-field", field, e.getLocalizedMessage());
            }
            return null;
        }
    }

    public static MethodHandle getFinalSetter(Class<?> clazz, String field) {
        return NMS.getFinalSetter(clazz, field, true);
    }

    public static MethodHandle getFinalSetter(Class<?> clazz, String fieldName, boolean log) {
        if (MODIFIERS_FIELD == null) {
            Field field;
            if (UNSAFE == null) {
                try {
                    UNSAFE = NMS.getField(Class.forName("sun.misc.Unsafe"), "theUnsafe").get(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (log) {
                        Messaging.logTr("citizens.nms-errors.getting-field", fieldName, e.getLocalizedMessage());
                    }
                    return null;
                }
                UNSAFE_STATIC_FIELD_OFFSET = NMS.getMethodHandle(UNSAFE.getClass(), "staticFieldOffset", true, Field.class).bindTo(UNSAFE);
                UNSAFE_FIELD_OFFSET = NMS.getMethodHandle(UNSAFE.getClass(), "objectFieldOffset", true, Field.class).bindTo(UNSAFE);
                UNSAFE_PUT_OBJECT = NMS.getMethodHandle(UNSAFE.getClass(), "putObject", true, Object.class, Long.TYPE, Object.class).bindTo(UNSAFE);
            }
            if ((field = NMS.getField(clazz, fieldName, log)) == null) {
                return null;
            }
            try {
                boolean isStatic = Modifier.isStatic(field.getModifiers());
                long offset = (Long)(isStatic ? UNSAFE_STATIC_FIELD_OFFSET.invoke(field) : UNSAFE_FIELD_OFFSET.invoke(field));
                return isStatic ? MethodHandles.insertArguments(UNSAFE_PUT_OBJECT, 0, clazz, offset) : MethodHandles.insertArguments(UNSAFE_PUT_OBJECT, 1, offset);
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (log) {
                    Messaging.logTr("citizens.nms-errors.getting-field", fieldName, t.getLocalizedMessage());
                }
                return null;
            }
        }
        Field field = NMS.getField(clazz, fieldName, log);
        if (field == null) {
            return null;
        }
        try {
            MODIFIERS_FIELD.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception e) {
            if (log) {
                Messaging.logTr("citizens.nms-errors.getting-field", fieldName, e.getLocalizedMessage());
            }
            return null;
        }
        try {
            return LOOKUP.unreflectSetter(field);
        }
        catch (Exception e) {
            if (log) {
                Messaging.logTr("citizens.nms-errors.getting-field", fieldName, e.getLocalizedMessage());
            }
            return null;
        }
    }

    private static Field getFirstFieldMatchingType(Class<?> clazz, Class<?> type, boolean allowStatic) {
        Field found = null;
        for (Field field : clazz.getDeclaredFields()) {
            if (allowStatic ^ Modifier.isStatic(field.getModifiers()) || field.getType() != type) continue;
            found = field;
            break;
        }
        if (found != null) {
            found.setAccessible(true);
        }
        return found;
    }

    public static MethodHandle getFirstGetter(Class<?> clazz, Class<?> type) {
        try {
            Field found = NMS.getFirstFieldMatchingType(clazz, type, false);
            if (found == null) {
                return null;
            }
            return LOOKUP.unreflectGetter(found);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.getting-field", type, e.getLocalizedMessage());
            return null;
        }
    }

    public static MethodHandle getFirstMethodHandle(Class<?> clazz, boolean log, Class<?> ... params) {
        return NMS.getFirstMethodHandleWithReturnType(clazz, log, null, params);
    }

    public static MethodHandle getFirstMethodHandleWithReturnType(Class<?> clazz, boolean log, Class<?> returnType, Class<?> ... params) {
        if (clazz == null) {
            return null;
        }
        try {
            Method first = null;
            for (Method method : clazz.getDeclaredMethods()) {
                Class<?>[] paramTypes;
                if (returnType != null && !returnType.equals(method.getReturnType()) || (paramTypes = method.getParameterTypes()).length != params.length) continue;
                first = method;
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (paramTypes[i] == params[i]) continue;
                    first = null;
                }
                if (first != null) break;
            }
            if (first == null) {
                return null;
            }
            first.setAccessible(true);
            return LOOKUP.unreflect(first);
        }
        catch (Exception e) {
            if (log) {
                Messaging.logTr("citizens.nms-errors.getting-method", e.getLocalizedMessage());
            }
            return null;
        }
    }

    public static MethodHandle getFirstSetter(Class<?> clazz, Class<?> type) {
        try {
            Field found = NMS.getFirstFieldMatchingType(clazz, type, false);
            if (found == null) {
                return null;
            }
            return LOOKUP.unreflectSetter(found);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.getting-field", type, e.getLocalizedMessage());
            return null;
        }
    }

    public static MethodHandle getFirstStaticGetter(Class<?> clazz, Class<?> type) {
        try {
            Field found = NMS.getFirstFieldMatchingType(clazz, type, true);
            if (found == null) {
                return null;
            }
            return LOOKUP.unreflectGetter(found);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.getting-field", type, e.getLocalizedMessage());
            return null;
        }
    }

    public static GameProfileRepository getGameProfileRepository() {
        return BRIDGE.getGameProfileRepository();
    }

    public static MethodHandle getGetter(Class<?> clazz, String name) {
        return NMS.getGetter(clazz, name, true);
    }

    public static MethodHandle getGetter(Class<?> clazz, String name, boolean log) {
        try {
            return LOOKUP.unreflectGetter(NMS.getField(clazz, name, log));
        }
        catch (Exception e) {
            if (log) {
                Messaging.logTr("citizens.nms-errors.getting-field", name, e.getLocalizedMessage());
            }
            return null;
        }
    }

    public static float getHeadYaw(Entity entity) {
        return BRIDGE.getHeadYaw(entity);
    }

    public static double getHeight(Entity entity) {
        return BRIDGE.getHeight(entity);
    }

    public static float getHorizontalMovement(Entity bukkitEntity) {
        return BRIDGE.getHorizontalMovement(bukkitEntity);
    }

    public static Method getMethod(Class<?> clazz, String method, boolean log, Class<?> ... params) {
        Method f;
        block3: {
            if (clazz == null) {
                return null;
            }
            f = null;
            try {
                f = clazz.getDeclaredMethod(method, params);
                f.setAccessible(true);
            }
            catch (Exception e) {
                if (!log) break block3;
                Messaging.logTr("citizens.nms-errors.getting-method", method, e.getLocalizedMessage());
            }
        }
        return f;
    }

    public static MethodHandle getMethodHandle(Class<?> clazz, String method, boolean log, Class<?> ... params) {
        if (clazz == null) {
            return null;
        }
        try {
            return LOOKUP.unreflect(NMS.getMethod(clazz, method, log, params));
        }
        catch (Exception e) {
            if (log) {
                Messaging.logTr("citizens.nms-errors.getting-method", method, e.getLocalizedMessage());
            }
            return null;
        }
    }

    public static NPC getNPC(Entity entity) {
        return BRIDGE.getNPC(entity);
    }

    public static List<Entity> getPassengers(Entity entity) {
        return BRIDGE.getPassengers(entity);
    }

    public static GameProfile getProfile(SkullMeta meta) {
        return BRIDGE.getProfile(meta);
    }

    public static MethodHandle getSetter(Class<?> clazz, String name) {
        return NMS.getSetter(clazz, name, true);
    }

    public static MethodHandle getSetter(Class<?> clazz, String name, boolean log) {
        try {
            return LOOKUP.unreflectSetter(NMS.getField(clazz, name, log));
        }
        catch (Exception e) {
            if (log) {
                Messaging.logTr("citizens.nms-errors.getting-field", name, e.getLocalizedMessage());
            }
            return null;
        }
    }

    public static String getSound(String flag) throws CommandException {
        return BRIDGE.getSound(flag);
    }

    public static float getSpeedFor(NPC npc) {
        return BRIDGE.getSpeedFor(npc);
    }

    public static float getStepHeight(Entity entity) {
        return BRIDGE.getStepHeight(entity);
    }

    public static MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Iterable<Vector> dest, NavigatorParameters params) {
        return BRIDGE.getTargetNavigator(entity, dest, params);
    }

    public static MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Location dest, NavigatorParameters params) {
        return BRIDGE.getTargetNavigator(entity, dest, params);
    }

    public static MCTargetStrategy.TargetNavigator getTargetNavigator(Entity entity, Entity target, NavigatorParameters parameters) {
        return BRIDGE.getTargetNavigator(entity, target, parameters);
    }

    public static Entity getVehicle(Entity entity) {
        return BRIDGE.getVehicle(entity);
    }

    public static float getVerticalMovement(Entity bukkitEntity) {
        return BRIDGE.getVerticalMovement(bukkitEntity);
    }

    public static double getWidth(Entity entity) {
        return BRIDGE.getWidth(entity);
    }

    public static float getYaw(Entity entity) {
        return BRIDGE.getYaw(entity);
    }

    public static void giveReflectiveAccess(Class<?> from, Class<?> to) {
        try {
            if (GET_MODULE == null) {
                Class<?> module = Class.forName("java.lang.Module");
                GET_MODULE = Class.class.getMethod("getModule", new Class[0]);
                ADD_OPENS = module.getMethod("addOpens", String.class, module);
            }
            ADD_OPENS.invoke(GET_MODULE.invoke(from, new Object[0]), from.getPackage().getName(), GET_MODULE.invoke(to, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isOnGround(Entity entity) {
        return BRIDGE.isOnGround(entity);
    }

    public static boolean isSolid(Block in) {
        return BRIDGE.isSolid(in);
    }

    public static boolean isValid(Entity entity) {
        return BRIDGE.isValid(entity);
    }

    public static void load(CommandManager commands) {
        BRIDGE.load(commands);
    }

    public static void loadBridge(String rev) throws Exception {
        Class<?> entity = null;
        try {
            entity = Class.forName("net.minecraft.server.v" + rev + ".Entity");
        }
        catch (ClassNotFoundException ex) {
            entity = Class.forName("net.minecraft.world.entity.Entity");
        }
        NMS.giveReflectiveAccess(entity, NMS.class);
        BRIDGE = (NMSBridge)Class.forName("net.citizensnpcs.nms.v" + rev + ".util.NMSImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static void loadPlugins() {
        BRIDGE.loadPlugins();
    }

    public static void look(Entity entity, float yaw, float pitch) {
        BRIDGE.look(entity, yaw, pitch);
    }

    public static void look(Entity entity, Location to, boolean headOnly, boolean immediate) {
        BRIDGE.look(entity, to, headOnly, immediate);
    }

    public static void look(Entity bhandle, Entity btarget) {
        BRIDGE.look(bhandle, btarget);
    }

    public static void mount(Entity entity, Entity passenger) {
        BRIDGE.mount(entity, passenger);
    }

    public static InventoryView openAnvilInventory(Player player, Inventory inventory, String title) {
        return BRIDGE.openAnvilInventory(player, inventory, title);
    }

    public static void openHorseScreen(Tameable horse, Player equipper) {
        BRIDGE.openHorseScreen(horse, equipper);
    }

    public static void playAnimation(PlayerAnimation animation, Player player, int radius) {
        BRIDGE.playAnimation(animation, player, radius);
    }

    public static void playerTick(Player entity) {
        BRIDGE.playerTick(entity);
    }

    public static void registerEntityClass(Class<?> clazz) {
        BRIDGE.registerEntityClass(clazz);
    }

    public static void remove(Entity entity) {
        BRIDGE.remove(entity);
    }

    public static void removeFromServerPlayerList(Player player) {
        BRIDGE.removeFromServerPlayerList(player);
    }

    public static void removeFromWorld(Entity entity) {
        BRIDGE.removeFromWorld(entity);
    }

    public static void removeHookIfNecessary(NPCRegistry npcRegistry, FishHook entity) {
        BRIDGE.removeHookIfNecessary(npcRegistry, entity);
    }

    public static void replaceTrackerEntry(Player player) {
        BRIDGE.replaceTrackerEntry(player);
    }

    public static void sendPositionUpdate(Player excluding, Entity from, Location storedLocation) {
        BRIDGE.sendPositionUpdate(excluding, from, storedLocation);
    }

    public static void sendTabListAdd(Player recipient, Player listPlayer) {
        BRIDGE.sendTabListAdd(recipient, listPlayer);
    }

    public static void sendTabListRemove(Player recipient, Collection<? extends SkinnableEntity> skinnableNPCs) {
        BRIDGE.sendTabListRemove(recipient, skinnableNPCs);
    }

    public static void sendTabListRemove(Player recipient, Player listPlayer) {
        BRIDGE.sendTabListRemove(recipient, listPlayer);
    }

    public static void sendTeamPacket(Player recipient, Team team, int mode) {
        BRIDGE.sendTeamPacket(recipient, team, mode);
    }

    public static void setAllayDancing(Entity entity, boolean dancing) {
        BRIDGE.setAllayDancing(entity, dancing);
    }

    public static void setBodyYaw(Entity entity, float yaw) {
        BRIDGE.setBodyYaw(entity, yaw);
    }

    public static void setDestination(Entity entity, double x, double y, double z, float speed) {
        BRIDGE.setDestination(entity, x, y, z, speed);
    }

    public static void setEndermanAngry(Enderman enderman, boolean angry) {
        BRIDGE.setEndermanAngry(enderman, angry);
    }

    public static void setHeadYaw(Entity entity, float yaw) {
        BRIDGE.setHeadYaw(entity, yaw);
    }

    public static void setKnockbackResistance(LivingEntity entity, double d) {
        BRIDGE.setKnockbackResistance(entity, d);
    }

    public static void setLyingDown(Entity cat, boolean lying) {
        BRIDGE.setLyingDown(cat, lying);
    }

    public static void setNavigationTarget(Entity handle, Entity target, float speed) {
        BRIDGE.setNavigationTarget(handle, target, speed);
    }

    public static void setNoGravity(Entity entity, boolean nogravity) {
        BRIDGE.setNoGravity(entity, nogravity);
    }

    public static void setPandaSitting(Entity entity, boolean sitting) {
        BRIDGE.setPandaSitting(entity, sitting);
    }

    public static void setPeekShulker(Entity entity, int peek) {
        if (!entity.getType().name().equals("SHULKER")) {
            throw new IllegalArgumentException("entity must be a shulker");
        }
        BRIDGE.setPeekShulker(entity, peek);
    }

    public static void setPiglinDancing(Entity entity, boolean dancing) {
        BRIDGE.setPiglinDancing(entity, dancing);
    }

    public static void setPitch(Entity entity, float pitch) {
        BRIDGE.setPitch(entity, pitch);
    }

    public static void setPolarBearRearing(Entity entity, boolean rearing) {
        BRIDGE.setPolarBearRearing(entity, rearing);
    }

    public static void setProfile(SkullMeta meta, GameProfile profile) {
        BRIDGE.setProfile(meta, profile);
    }

    public static void setShouldJump(Entity entity) {
        BRIDGE.setShouldJump(entity);
    }

    public static void setSitting(Ocelot ocelot, boolean sitting) {
        BRIDGE.setSitting(ocelot, sitting);
    }

    public static void setSitting(Tameable tameable, boolean sitting) {
        BRIDGE.setSitting(tameable, sitting);
    }

    public static void setSneaking(Entity entity, boolean sneaking) {
        BRIDGE.setSneaking(entity, sneaking);
    }

    public static void setStepHeight(Entity entity, float height) {
        BRIDGE.setStepHeight(entity, height);
    }

    public static void setTeamNameTagVisible(Team team, boolean visible) {
        BRIDGE.setTeamNameTagVisible(team, visible);
    }

    public static void setVerticalMovement(Entity bukkitEntity, double d) {
        BRIDGE.setVerticalMovement(bukkitEntity, d);
    }

    public static void setWitherInvulnerable(Wither wither, boolean charged) {
        BRIDGE.setWitherCharged(wither, charged);
    }

    public static boolean shouldJump(Entity entity) {
        return BRIDGE.shouldJump(entity);
    }

    public static void shutdown() {
        if (BRIDGE != null) {
            BRIDGE.shutdown();
            BRIDGE = null;
        }
    }

    public static void sleep(Player entity, boolean sleep) {
        BRIDGE.sleep(entity, sleep);
    }

    public static boolean tick(Entity next) {
        return BRIDGE.tick(next);
    }

    public static void trySwim(Entity entity) {
        BRIDGE.trySwim(entity);
    }

    public static void trySwim(Entity entity, float power) {
        BRIDGE.trySwim(entity, power);
    }

    public static void updateInventoryTitle(Player player, InventoryView view, String newTitle) {
        BRIDGE.updateInventoryTitle(player, view, newTitle);
    }

    public static void updateNavigationWorld(Entity entity, World world) {
        BRIDGE.updateNavigationWorld(entity, world);
    }

    public static void updatePathfindingRange(NPC npc, float pathfindingRange) {
        BRIDGE.updatePathfindingRange(npc, pathfindingRange);
    }

    static {
        LOOKUP = MethodHandles.lookup();
        NMS.giveReflectiveAccess(Field.class, NMS.class);
        MODIFIERS_FIELD = NMS.getField(Field.class, "modifiers", false);
    }
}

