/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class ChunkCoord {
    public final UUID worldUUID;
    public final int x;
    public final int z;
    private static boolean SUPPORTS_FORCE_LOADED = true;

    public ChunkCoord(Chunk chunk) {
        this(chunk.getWorld().getUID(), chunk.getX(), chunk.getZ());
    }

    public ChunkCoord(Location loc) {
        this(loc.getWorld().getUID(), loc.getBlockX() >> 4, loc.getBlockZ() >> 4);
    }

    public ChunkCoord(UUID worldUUID, int x, int z) {
        this.x = x;
        this.z = z;
        this.worldUUID = worldUUID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkCoord other = (ChunkCoord)obj;
        if (this.worldUUID == null ? other.worldUUID != null : !this.worldUUID.equals(other.worldUUID)) {
            return false;
        }
        return this.x == other.x && this.z == other.z;
    }

    public Chunk getChunk() {
        World world = Bukkit.getWorld((UUID)this.worldUUID);
        return world != null ? world.getChunkAt(this.x, this.z) : null;
    }

    public int hashCode() {
        int prime = 31;
        return 31 * (31 * (31 + (this.worldUUID == null ? 0 : this.worldUUID.hashCode())) + this.x) + this.z;
    }

    public void setForceLoaded(boolean b) {
        Chunk chunk = this.getChunk();
        if (chunk != null && SUPPORTS_FORCE_LOADED) {
            try {
                chunk.setForceLoaded(b);
            }
            catch (NoSuchMethodError e) {
                SUPPORTS_FORCE_LOADED = false;
            }
        }
    }

    public String toString() {
        return "[" + this.x + "," + this.z + "]";
    }
}

