/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import java.util.List;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;

public class TriggerRemovePrompt
extends StringPrompt {
    private final WaypointEditor editor;

    public TriggerRemovePrompt(WaypointEditor editor) {
        this.editor = editor;
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        if (input.equalsIgnoreCase("back")) {
            context.setSessionData((Object)"said", (Object)false);
            return (Prompt)context.getSessionData((Object)"previous");
        }
        if (this.editor.getCurrentWaypoint() == null) {
            Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.main.missing-waypoint", new Object[0]);
            return this;
        }
        int index = 0;
        try {
            index = Math.max(0, Integer.parseInt(input) - 1);
        }
        catch (NumberFormatException e) {
            Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.remove.not-a-number", new Object[0]);
            return this;
        }
        List<WaypointTrigger> triggers = this.editor.getCurrentWaypoint().getTriggers();
        if (index >= triggers.size()) {
            Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.remove.index-out-of-range", triggers.size());
        } else {
            triggers.remove(index);
            Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.remove.removed", index + 1);
        }
        return this;
    }

    public String getPromptText(ConversationContext context) {
        if (this.editor.getCurrentWaypoint() == null) {
            Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.main.missing-waypoint", new Object[0]);
            return "";
        }
        if (context.getSessionData((Object)"said") == Boolean.TRUE) {
            return "";
        }
        context.setSessionData((Object)"said", (Object)true);
        String root = "";
        int i = 1;
        for (WaypointTrigger trigger : this.editor.getCurrentWaypoint().getTriggers()) {
            root = root + String.format("<br>     [[%d]]. " + trigger.description(), i++);
        }
        Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.remove.prompt", root);
        return "";
    }
}

