/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.triggers.TriggerAddPrompt;
import net.citizensnpcs.trait.waypoint.triggers.TriggerRemovePrompt;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class TriggerEditPrompt
extends StringPrompt {
    private final WaypointEditor editor;

    public TriggerEditPrompt(WaypointEditor editor) {
        this.editor = editor;
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        if ((input = input.toLowerCase().trim()).contains("add")) {
            context.setSessionData((Object)"said", (Object)false);
            return new TriggerAddPrompt(this.editor);
        }
        if (input.contains("remove")) {
            context.setSessionData((Object)"said", (Object)false);
            return new TriggerRemovePrompt(this.editor);
        }
        return this;
    }

    public String getPromptText(ConversationContext context) {
        context.setSessionData((Object)"previous", (Object)this);
        if (context.getSessionData((Object)"said") == Boolean.TRUE) {
            return "";
        }
        context.setSessionData((Object)"said", (Object)true);
        String base = "";
        if (this.editor.getCurrentWaypoint() != null) {
            Waypoint waypoint = this.editor.getCurrentWaypoint();
            for (WaypointTrigger trigger : waypoint.getTriggers()) {
                base = base + "\n    - " + trigger.description();
            }
        }
        Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.main.prompt", base);
        return "";
    }

    public static Conversation start(Player player, WaypointEditor editor) {
        Conversation conversation = new ConversationFactory(CitizensAPI.getPlugin()).withLocalEcho(false).addConversationAbandonedListener(new ConversationAbandonedListener(){

            public void conversationAbandoned(ConversationAbandonedEvent event) {
                event.getContext().getForWhom().sendRawMessage(Messaging.tr("citizens.editors.waypoints.triggers.main.exit", new Object[0]));
            }
        }).withEscapeSequence("exit").withEscapeSequence("triggers").withEscapeSequence("/npc path").withModality(false).withFirstPrompt((Prompt)new TriggerEditPrompt(editor)).buildConversation((Conversable)player);
        conversation.begin();
        return conversation;
    }
}

