/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerRegistry;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;

public class TriggerAddPrompt
extends StringPrompt {
    private final WaypointEditor editor;

    public TriggerAddPrompt(WaypointEditor editor) {
        this.editor = editor;
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        WaypointTrigger returned;
        if ((input = input.toLowerCase().trim()).equalsIgnoreCase("back")) {
            context.setSessionData((Object)"said", (Object)false);
            return (Prompt)context.getSessionData((Object)"previous");
        }
        Object[] split = input.split(" ");
        input = split[0];
        split[0] = null;
        Prompt prompt = WaypointTriggerRegistry.getTriggerPromptFrom(input);
        String extraInput = Joiner.on((char)' ').skipNulls().join(split);
        if (prompt == null) {
            Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.add.invalid-trigger", input);
            context.setSessionData((Object)"said", (Object)false);
            return this;
        }
        if (extraInput.length() > 0 && (returned = ((WaypointTriggerPrompt)prompt).createFromShortInput(context, extraInput)) != null) {
            context.setSessionData((Object)"created-trigger", (Object)returned);
            return this;
        }
        return prompt;
    }

    public String getPromptText(ConversationContext context) {
        WaypointTrigger returned = (WaypointTrigger)context.getSessionData((Object)"created-trigger");
        if (returned != null) {
            if (this.editor.getCurrentWaypoint() != null) {
                this.editor.getCurrentWaypoint().addTrigger(returned);
                context.setSessionData((Object)"created-trigger", null);
                Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.add.added", returned.description());
                this.editor.getCurrentWaypoint().describeTriggers((CommandSender)context.getForWhom());
            } else {
                Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.main.missing-waypoint", new Object[0]);
            }
        }
        if (context.getSessionData((Object)"said") == Boolean.TRUE) {
            return "";
        }
        context.setSessionData((Object)"said", (Object)true);
        context.setSessionData((Object)"return-to", (Object)this);
        return Messaging.tr("citizens.editors.waypoints.triggers.add.prompt", WaypointTriggerRegistry.describeValidTriggerNames());
    }
}

