/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.SpeedTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.NumericPrompt;
import org.bukkit.conversations.Prompt;

public class SpeedTriggerPrompt
extends NumericPrompt
implements WaypointTriggerPrompt {
    protected Prompt acceptValidatedInput(ConversationContext context, Number input) {
        float speed = (float)Math.max(input.doubleValue(), 0.0);
        context.setSessionData((Object)"created-trigger", (Object)new SpeedTrigger(speed));
        return (Prompt)context.getSessionData((Object)"return-to");
    }

    @Override
    public WaypointTrigger createFromShortInput(ConversationContext context, String input) {
        try {
            float speed = (float)Math.max(Double.parseDouble(input), 0.0);
            return new SpeedTrigger(speed);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public String getPromptText(ConversationContext context) {
        return Messaging.tr("citizens.editors.waypoints.triggers.speed.prompt", new Object[0]);
    }
}

