/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.AnimationTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;

public class AnimationTriggerPrompt
extends StringPrompt
implements WaypointTriggerPrompt {
    private final List<PlayerAnimation> animations = Lists.newArrayList();

    public Prompt acceptInput(ConversationContext context, String input) {
        if (input.equalsIgnoreCase("back")) {
            return (Prompt)context.getSessionData((Object)"previous");
        }
        if (input.equalsIgnoreCase("finish")) {
            context.setSessionData((Object)"created-trigger", (Object)new AnimationTrigger(this.animations));
            return (Prompt)context.getSessionData((Object)"return-to");
        }
        PlayerAnimation animation = (PlayerAnimation)Util.matchEnum((Enum[])PlayerAnimation.values(), (String)input);
        if (animation == null) {
            Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.animation.invalid-animation", input, this.getValidAnimations());
        }
        this.animations.add(animation);
        Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.animation.added", input);
        return this;
    }

    @Override
    public WaypointTrigger createFromShortInput(ConversationContext context, String input) {
        return null;
    }

    public String getPromptText(ConversationContext context) {
        Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.animation.prompt", this.getValidAnimations());
        return "";
    }

    private String getValidAnimations() {
        return Joiner.on((String)", ").join((Object[])PlayerAnimation.values());
    }
}

