/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class AnimationTrigger
implements WaypointTrigger {
    @Persist(required=true)
    private List<PlayerAnimation> animations;

    public AnimationTrigger() {
    }

    public AnimationTrigger(Collection<PlayerAnimation> collection) {
        this.animations = Lists.newArrayList(collection);
    }

    @Override
    public String description() {
        return String.format("[[Animation]] animating %s", Joiner.on((String)", ").join(this.animations));
    }

    @Override
    public void onWaypointReached(NPC npc, Location waypoint) {
        if (npc.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)npc.getEntity();
        for (PlayerAnimation animation : this.animations) {
            animation.play(player);
        }
    }
}

