/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.Locatable;
import net.citizensnpcs.trait.waypoint.triggers.DelayTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class Waypoint
implements Locatable {
    @Persist(required=true)
    private Location location;
    @Persist
    private List<WaypointTrigger> triggers;

    public Waypoint() {
    }

    public Waypoint(Location at) {
        this.location = at;
    }

    public void addTrigger(WaypointTrigger trigger) {
        if (this.triggers == null) {
            this.triggers = Lists.newArrayList();
        }
        this.triggers.add(trigger);
    }

    public void describeTriggers(CommandSender sender) {
        String base = "";
        for (WaypointTrigger trigger : this.getTriggers()) {
            base = base + "\n    - " + trigger.description();
        }
        Messaging.sendTr(sender, "citizens.editors.waypoints.triggers.list", base);
    }

    public double distance(Waypoint dest) {
        return this.location.distance(dest.location);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Waypoint other = (Waypoint)obj;
        if (this.location == null ? other.location != null : !this.location.equals((Object)other.location)) {
            return false;
        }
        return !(this.triggers == null ? other.triggers != null : !this.triggers.equals(other.triggers));
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    public List<WaypointTrigger> getTriggers() {
        return this.triggers == null ? Collections.emptyList() : this.triggers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.location == null ? 0 : this.location.hashCode());
        return 31 * result + (this.triggers == null ? 0 : this.triggers.hashCode());
    }

    public void onReach(NPC npc) {
        if (this.triggers == null) {
            return;
        }
        this.runTriggers(npc, 0);
    }

    private void runTriggers(final NPC npc, int start) {
        for (int i = start; i < this.triggers.size(); ++i) {
            int delay;
            WaypointTrigger trigger = this.triggers.get(i);
            trigger.onWaypointReached(npc, this.location);
            if (!(trigger instanceof DelayTrigger) || (delay = ((DelayTrigger)trigger).getDelay()) <= 0) continue;
            final int newStart = i + 1;
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Waypoint.this.runTriggers(npc, newStart);
                }
            }, (long)delay);
            break;
        }
    }

    static {
        PersistenceLoader.registerPersistDelegate(WaypointTrigger.class, WaypointTriggerRegistry.class);
    }
}

