/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.EntityMarkers;
import net.citizensnpcs.trait.waypoint.LinearWaypointsCompleteEvent;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.triggers.TriggerEditPrompt;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class LinearWaypointProvider
implements WaypointProvider.EnumerableWaypointProvider {
    private final Map<SourceDestinationPair, Iterable<Vector>> cachedPaths = Maps.newHashMap();
    @Persist
    private boolean cachePaths = Settings.Setting.DEFAULT_CACHE_WAYPOINT_PATHS.asBoolean();
    private LinearWaypointGoal currentGoal;
    @Persist
    private boolean cycle = false;
    private NPC npc;
    private final List<Waypoint> waypoints = Lists.newArrayList();

    public LinearWaypointProvider() {
    }

    public LinearWaypointProvider(NPC npc) {
        this.npc = npc;
    }

    public void addWaypoint(Waypoint waypoint) {
        this.waypoints.add(waypoint);
        if (this.currentGoal != null) {
            this.currentGoal.onProviderChanged();
        }
    }

    @Override
    public WaypointEditor createEditor(CommandSender sender, CommandContext args) {
        if (args.hasFlag('h')) {
            try {
                if (args.getSenderLocation() != null) {
                    this.waypoints.add(new Waypoint(args.getSenderLocation()));
                }
            }
            catch (CommandException e) {
                Messaging.sendError(sender, e.getMessage());
            }
            return null;
        }
        if (args.hasValueFlag("at")) {
            try {
                Location location = CommandContext.parseLocation(args.getSenderLocation(), args.getFlag("at"));
                if (location != null) {
                    this.waypoints.add(new Waypoint(location));
                }
            }
            catch (CommandException e) {
                Messaging.sendError(sender, e.getMessage());
            }
            return null;
        }
        if (args.hasFlag('c')) {
            this.waypoints.clear();
            this.cachedPaths.clear();
            return null;
        }
        if (args.hasFlag('l')) {
            if (this.waypoints.size() > 0) {
                this.waypoints.remove(this.waypoints.size() - 1);
            }
            return null;
        }
        if (args.hasFlag('p')) {
            this.setPaused(!this.isPaused());
            return null;
        }
        if (args.hasFlag('k')) {
            this.cachePaths = !this.cachePaths;
            return null;
        }
        if (!(sender instanceof Player)) {
            Messaging.sendErrorTr(sender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
            return null;
        }
        return new LinearWaypointEditor((Player)sender);
    }

    public Waypoint getCurrentWaypoint() {
        if (this.currentGoal != null && this.currentGoal.currentDestination != null) {
            return this.currentGoal.currentDestination;
        }
        return null;
    }

    @Override
    public boolean isPaused() {
        return this.currentGoal == null ? false : this.currentGoal.isPaused();
    }

    @Override
    public void load(DataKey key) {
        for (DataKey root : key.getRelative("points").getIntegerSubKeys()) {
            Waypoint waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, root));
            if (waypoint == null) continue;
            this.waypoints.add(waypoint);
        }
    }

    @Override
    public void onRemove() {
        if (this.currentGoal != null) {
            this.npc.getDefaultGoalController().removeGoal(this.currentGoal);
            this.currentGoal = null;
        }
    }

    @Override
    public void onSpawn(NPC npc) {
        this.npc = npc;
        if (this.currentGoal == null) {
            this.currentGoal = new LinearWaypointGoal();
            npc.getDefaultGoalController().addGoal(this.currentGoal, 1);
        }
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("points");
        DataKey root = key.getRelative("points");
        for (int i = 0; i < this.waypoints.size(); ++i) {
            PersistenceLoader.save(this.waypoints.get(i), root.getRelative(i));
        }
    }

    @Override
    public void setPaused(boolean paused) {
        if (this.currentGoal != null) {
            this.currentGoal.setPaused(paused);
        }
    }

    @Override
    public Iterable<Waypoint> waypoints() {
        return new AbstractList<Waypoint>(){

            @Override
            public void add(int index, Waypoint waypoint) {
                LinearWaypointProvider.this.waypoints.add(index, waypoint);
                this.mod();
            }

            @Override
            public boolean add(Waypoint waypoint) {
                boolean val = LinearWaypointProvider.this.waypoints.add(waypoint);
                this.mod();
                return val;
            }

            @Override
            public void clear() {
                LinearWaypointProvider.this.waypoints.clear();
                this.mod();
            }

            @Override
            public Waypoint get(int index) {
                return (Waypoint)LinearWaypointProvider.this.waypoints.get(index);
            }

            private void mod() {
                if (LinearWaypointProvider.this.currentGoal != null) {
                    LinearWaypointProvider.this.currentGoal.onProviderChanged();
                }
            }

            @Override
            public Waypoint remove(int index) {
                Waypoint val = (Waypoint)LinearWaypointProvider.this.waypoints.remove(index);
                this.mod();
                return val;
            }

            @Override
            public boolean remove(Object waypoint) {
                boolean val = LinearWaypointProvider.this.waypoints.remove(waypoint);
                this.mod();
                return val;
            }

            @Override
            public Waypoint set(int index, Waypoint elem) {
                Waypoint val = LinearWaypointProvider.this.waypoints.set(index, elem);
                this.mod();
                return val;
            }

            @Override
            public int size() {
                return LinearWaypointProvider.this.waypoints.size();
            }
        };
    }

    private class LinearWaypointGoal
    implements Goal {
        private boolean ascending = true;
        private final Location cachedLocation = new Location(null, 0.0, 0.0, 0.0);
        private Waypoint currentDestination;
        private Iterator<Waypoint> itr;
        private boolean paused;
        private GoalSelector selector;

        private LinearWaypointGoal() {
        }

        private void ensureItr() {
            if (this.itr == null) {
                this.itr = this.getUnsafeIterator();
            } else if (!this.itr.hasNext()) {
                this.itr = this.getNewIterator();
            }
        }

        private Navigator getNavigator() {
            return LinearWaypointProvider.this.npc.getNavigator();
        }

        private Iterator<Waypoint> getNewIterator() {
            LinearWaypointsCompleteEvent event = new LinearWaypointsCompleteEvent(LinearWaypointProvider.this, this.getUnsafeIterator());
            Bukkit.getPluginManager().callEvent((Event)event);
            Iterator<Waypoint> next = event.getNextWaypoints();
            return next;
        }

        private Iterator<Waypoint> getUnsafeIterator() {
            if (LinearWaypointProvider.this.cycle && this.ascending) {
                this.ascending = false;
                return new Iterator<Waypoint>(){
                    int idx;
                    {
                        this.idx = LinearWaypointProvider.this.waypoints.size() - 1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.idx >= 0 && this.idx < LinearWaypointProvider.this.waypoints.size();
                    }

                    @Override
                    public Waypoint next() {
                        return (Waypoint)LinearWaypointProvider.this.waypoints.get(this.idx--);
                    }

                    @Override
                    public void remove() {
                        LinearWaypointProvider.this.waypoints.remove(Math.max(0, this.idx - 1));
                    }
                };
            }
            this.ascending = true;
            return new Iterator<Waypoint>(){
                int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < LinearWaypointProvider.this.waypoints.size();
                }

                @Override
                public Waypoint next() {
                    return (Waypoint)LinearWaypointProvider.this.waypoints.get(this.idx++);
                }

                @Override
                public void remove() {
                    LinearWaypointProvider.this.waypoints.remove(Math.max(0, this.idx - 1));
                }
            };
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void onProviderChanged() {
            this.itr = this.getUnsafeIterator();
            if (this.currentDestination != null) {
                if (this.selector != null) {
                    this.selector.finish();
                }
                if (LinearWaypointProvider.this.npc != null && LinearWaypointProvider.this.npc.getNavigator().isNavigating()) {
                    LinearWaypointProvider.this.npc.getNavigator().cancelNavigation();
                }
            }
        }

        @Override
        public void reset() {
            this.currentDestination = null;
            this.selector = null;
        }

        @Override
        public void run(GoalSelector selector) {
            if (!this.getNavigator().isNavigating()) {
                selector.finish();
            }
        }

        public void setPaused(boolean pause) {
            this.paused = pause;
            if (pause && this.currentDestination != null) {
                this.selector.finish();
                if (LinearWaypointProvider.this.npc != null && LinearWaypointProvider.this.npc.getNavigator().isNavigating()) {
                    LinearWaypointProvider.this.npc.getNavigator().cancelNavigation();
                }
            }
        }

        @Override
        public boolean shouldExecute(final GoalSelector selector) {
            if (this.paused || this.currentDestination != null || !LinearWaypointProvider.this.npc.isSpawned() || this.getNavigator().isNavigating()) {
                return false;
            }
            this.ensureItr();
            boolean shouldExecute = this.itr.hasNext();
            if (!shouldExecute) {
                return false;
            }
            this.selector = selector;
            Waypoint next = this.itr.next();
            final Location npcLoc = LinearWaypointProvider.this.npc.getEntity().getLocation(this.cachedLocation);
            if (npcLoc.getWorld() != next.getLocation().getWorld() || npcLoc.distance(next.getLocation()) < LinearWaypointProvider.this.npc.getNavigator().getLocalParameters().distanceMargin()) {
                return false;
            }
            this.currentDestination = next;
            if (LinearWaypointProvider.this.cachePaths) {
                SourceDestinationPair key = new SourceDestinationPair(npcLoc, this.currentDestination);
                Iterable cached = (Iterable)LinearWaypointProvider.this.cachedPaths.get(key);
                if (cached != null) {
                    if (Iterables.size((Iterable)cached) == 0 || !key.verify(npcLoc.getWorld(), cached)) {
                        LinearWaypointProvider.this.cachedPaths.remove(key);
                    } else {
                        this.getNavigator().setTarget(cached);
                    }
                }
            }
            if (!this.getNavigator().isNavigating()) {
                this.getNavigator().setTarget(this.currentDestination.getLocation());
            }
            this.getNavigator().getLocalParameters().addSingleUseCallback(new NavigatorCallback(){

                @Override
                public void onCompletion(@Nullable CancelReason cancelReason) {
                    if (LinearWaypointProvider.this.npc.isSpawned() && LinearWaypointGoal.this.currentDestination != null && Util.locationWithinRange(LinearWaypointProvider.this.npc.getStoredLocation(), LinearWaypointGoal.this.currentDestination.getLocation(), Settings.Setting.DEFAULT_DISTANCE_MARGIN.asDouble() + 1.0)) {
                        Iterable<Vector> path;
                        LinearWaypointGoal.this.currentDestination.onReach(LinearWaypointProvider.this.npc);
                        if (LinearWaypointProvider.this.cachePaths && cancelReason == null && Iterables.size(path = LinearWaypointGoal.this.getNavigator().getPathStrategy().getPath()) > 0) {
                            LinearWaypointProvider.this.cachedPaths.put(new SourceDestinationPair(npcLoc, LinearWaypointGoal.this.currentDestination), path);
                        }
                    }
                    selector.finish();
                }
            });
            return true;
        }
    }

    private final class LinearWaypointEditor
    extends WaypointEditor {
        Conversation conversation;
        boolean editing = true;
        EntityMarkers<Waypoint> markers;
        private final Player player;
        private Waypoint selectedWaypoint;
        private boolean showingMarkers = true;

        private LinearWaypointEditor(Player player) {
            this.player = player;
            this.markers = new EntityMarkers();
        }

        @Override
        public void begin() {
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.begin", new Object[0]);
            if (this.showingMarkers) {
                this.createWaypointMarkers();
            }
        }

        private void clearWaypoints() {
            LinearWaypointProvider.this.waypoints.clear();
            this.onWaypointsModified();
            this.markers.destroyMarkers();
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.waypoints-cleared", new Object[0]);
        }

        private void createWaypointMarkers() {
            for (int i = 0; i < LinearWaypointProvider.this.waypoints.size(); ++i) {
                this.markers.createMarker((Waypoint)LinearWaypointProvider.this.waypoints.get(i), ((Waypoint)LinearWaypointProvider.this.waypoints.get(i)).getLocation());
            }
        }

        @Override
        public void end() {
            if (!this.editing) {
                return;
            }
            this.editing = false;
            if (this.conversation != null) {
                this.conversation.abandon();
            }
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.end", new Object[0]);
            this.markers.destroyMarkers();
        }

        private String formatLoc(Location location) {
            return String.format("[[%d]], [[%d]], [[%d]]", location.getBlockX(), location.getBlockY(), location.getBlockZ());
        }

        @Override
        public Waypoint getCurrentWaypoint() {
            if (LinearWaypointProvider.this.waypoints.size() == 0 || !this.editing) {
                return null;
            }
            return this.selectedWaypoint == null ? (Waypoint)LinearWaypointProvider.this.waypoints.get(LinearWaypointProvider.this.waypoints.size() - 1) : this.selectedWaypoint;
        }

        private Location getLastWaypoint() {
            if (LinearWaypointProvider.this.waypoints.size() <= 1) {
                return null;
            }
            return ((Waypoint)LinearWaypointProvider.this.waypoints.get(LinearWaypointProvider.this.waypoints.size() - 1)).getLocation();
        }

        @EventHandler
        public void onNPCDespawn(NPCDespawnEvent event) {
            if (event.getNPC().equals(LinearWaypointProvider.this.npc)) {
                Editor.leave(this.player);
            }
        }

        @EventHandler
        public void onNPCRemove(NPCRemoveEvent event) {
            if (event.getNPC().equals(LinearWaypointProvider.this.npc)) {
                Editor.leave(this.player);
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerChat(final AsyncPlayerChatEvent event) {
            if (!event.getPlayer().equals(this.player)) {
                return;
            }
            String message = event.getMessage();
            if (message.equalsIgnoreCase("triggers")) {
                event.setCancelled(true);
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        LinearWaypointEditor.this.conversation = TriggerEditPrompt.start(LinearWaypointEditor.this.player, LinearWaypointEditor.this);
                        LinearWaypointEditor.this.conversation.addConversationAbandonedListener(new ConversationAbandonedListener(){

                            public void conversationAbandoned(ConversationAbandonedEvent event) {
                                LinearWaypointEditor.this.conversation = null;
                            }
                        });
                    }
                });
            } else if (message.equalsIgnoreCase("clear")) {
                event.setCancelled(true);
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        LinearWaypointEditor.this.clearWaypoints();
                    }
                });
            } else if (message.equalsIgnoreCase("toggle path") || message.equalsIgnoreCase("markers")) {
                event.setCancelled(true);
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        LinearWaypointEditor.this.togglePath();
                    }
                });
            } else if (message.equalsIgnoreCase("cycle")) {
                event.setCancelled(true);
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        LinearWaypointProvider.this.cycle = !LinearWaypointProvider.this.cycle;
                        Messaging.sendTr((CommandSender)event.getPlayer(), LinearWaypointProvider.this.cycle ? "citizens.editors.waypoints.linear.cycle-set" : "citizens.editors.waypoints.linear.cycle-unset", new Object[0]);
                    }
                });
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerInteract(PlayerInteractEvent event) {
            if (!event.getPlayer().equals(this.player) || event.getAction() == Action.PHYSICAL || !LinearWaypointProvider.this.npc.isSpawned() || event.getPlayer().getWorld() != LinearWaypointProvider.this.npc.getEntity().getWorld() || Util.isOffHand(event)) {
                return;
            }
            if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_AIR) {
                double maxDistance;
                double distance;
                if (event.getClickedBlock() == null) {
                    return;
                }
                event.setCancelled(true);
                Location at = event.getClickedBlock().getLocation().add(0.0, 1.0, 0.0);
                Location prev = this.getLastWaypoint();
                if (prev != null && prev.getWorld() == at.getWorld() && (distance = at.distance(prev)) > (maxDistance = (double)LinearWaypointProvider.this.npc.getNavigator().getDefaultParameters().range())) {
                    Messaging.sendErrorTr((CommandSender)this.player, "citizens.editors.waypoints.linear.range-exceeded", distance, maxDistance, ChatColor.RED);
                    return;
                }
                Waypoint element = new Waypoint(at);
                LinearWaypointProvider.this.waypoints.add(element);
                if (this.showingMarkers) {
                    this.markers.createMarker(element, element.getLocation().clone());
                }
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.added-waypoint", this.formatLoc(at), LinearWaypointProvider.this.waypoints.size());
            } else if (LinearWaypointProvider.this.waypoints.size() > 0 && !event.getPlayer().isSneaking()) {
                event.setCancelled(true);
                Waypoint waypoint = this.removeWaypoint(LinearWaypointProvider.this.waypoints.size() - 1);
                if (waypoint.equals(this.selectedWaypoint)) {
                    this.selectedWaypoint = null;
                }
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.removed-waypoint", LinearWaypointProvider.this.waypoints.size());
            }
            this.onWaypointsModified();
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
            if (!this.player.equals(event.getPlayer()) || !this.showingMarkers || Util.isOffHand(event)) {
                return;
            }
            int slot = -1;
            double minDistance = Double.MAX_VALUE;
            for (int i = 0; i < LinearWaypointProvider.this.waypoints.size(); ++i) {
                Waypoint waypoint = (Waypoint)LinearWaypointProvider.this.waypoints.get(i);
                double distance = waypoint.getLocation().distanceSquared(event.getRightClicked().getLocation().add(0.0, -1.0, 0.0));
                if (!(minDistance > distance)) continue;
                minDistance = distance;
                slot = i;
            }
            if (slot == -1) {
                return;
            }
            if (this.selectedWaypoint != null && LinearWaypointProvider.this.waypoints.get(slot) == this.selectedWaypoint) {
                this.removeWaypoint(slot);
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.removed-waypoint", LinearWaypointProvider.this.waypoints.size());
                return;
            }
            this.selectedWaypoint = (Waypoint)LinearWaypointProvider.this.waypoints.get(slot);
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.selected-waypoint", this.formatLoc(this.selectedWaypoint.getLocation()));
        }

        private void onWaypointsModified() {
            if (LinearWaypointProvider.this.currentGoal != null) {
                LinearWaypointProvider.this.currentGoal.onProviderChanged();
            }
            if (this.conversation != null && this.getCurrentWaypoint() != null) {
                this.getCurrentWaypoint().describeTriggers((CommandSender)this.player);
            }
        }

        private Waypoint removeWaypoint(int idx) {
            Waypoint waypoint = (Waypoint)LinearWaypointProvider.this.waypoints.remove(idx);
            if (this.showingMarkers) {
                this.markers.removeMarker(waypoint);
            }
            if (waypoint == this.selectedWaypoint) {
                this.selectedWaypoint = null;
            }
            return waypoint;
        }

        private void togglePath() {
            boolean bl = this.showingMarkers = !this.showingMarkers;
            if (this.showingMarkers) {
                this.createWaypointMarkers();
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.showing-markers", new Object[0]);
            } else {
                this.markers.destroyMarkers();
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.not-showing-markers", new Object[0]);
            }
        }
    }

    private static class SourceDestinationPair {
        private final Vector from;
        private final Vector to;

        public SourceDestinationPair(Location npcLoc, Waypoint to) {
            this(new Vector(npcLoc.getBlockX(), npcLoc.getBlockY(), npcLoc.getBlockZ()), to.getLocation().toVector());
        }

        public SourceDestinationPair(Vector from, Vector to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SourceDestinationPair other = (SourceDestinationPair)obj;
            if (this.from == null ? other.from != null : !this.from.equals((Object)other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals((Object)other.to));
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + (this.from == null ? 0 : this.from.hashCode());
            return 31 * result + (this.to == null ? 0 : this.to.hashCode());
        }

        public boolean verify(World world, Iterable<Vector> cached) {
            for (Vector vector : cached) {
                if (MinecraftBlockExaminer.canStandOn(world.getBlockAt(vector.getBlockX(), vector.getBlockY() - 1, vector.getBlockZ()))) continue;
                return false;
            }
            return true;
        }
    }
}

