/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import clib.phtree.PhDistance;
import clib.phtree.PhDistanceL;
import clib.phtree.PhFilter;
import clib.phtree.PhFilterDistance;
import clib.phtree.PhTree;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.waypoint.EntityMarkers;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class GuidedWaypointProvider
implements WaypointProvider.EnumerableWaypointProvider {
    private final List<Waypoint> available = Lists.newArrayList();
    private GuidedAIGoal currentGoal;
    private final List<Waypoint> helpers = Lists.newArrayList();
    private NPC npc;
    private boolean paused;
    private PhTree<Waypoint> tree = PhTree.create((int)3);
    private static final AStarMachine<GuidedNode, GuidedPlan> ASTAR = AStarMachine.createWithDefaultStorage();

    public void addHelperWaypoint(Waypoint helper) {
        this.helpers.add(helper);
        this.rebuildTree();
    }

    public void addHelperWaypoints(Collection<Waypoint> helper) {
        this.helpers.addAll(helper);
        this.rebuildTree();
    }

    public void addWaypoint(Waypoint waypoint) {
        this.available.add(waypoint);
        this.rebuildTree();
    }

    public void addWaypoints(Collection<Waypoint> waypoint) {
        this.available.addAll(waypoint);
        this.rebuildTree();
    }

    @Override
    public WaypointEditor createEditor(CommandSender sender, CommandContext args) {
        if (!(sender instanceof Player)) {
            Messaging.sendErrorTr(sender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
            return null;
        }
        final Player player = (Player)sender;
        return new WaypointEditor(){
            private final EntityMarkers<Waypoint> markers = new EntityMarkers();
            private boolean showPath;

            @Override
            public void begin() {
                if (this.showPath) {
                    this.createWaypointMarkers();
                }
                Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.begin", new Object[0]);
            }

            private void createWaypointMarkers() {
                for (Waypoint waypoint : GuidedWaypointProvider.this.waypoints()) {
                    this.createWaypointMarkerWithData(waypoint);
                }
            }

            private void createWaypointMarkerWithData(Waypoint element) {
                Entity entity = this.markers.createMarker(element, element.getLocation().clone().add(0.0, 1.0, 0.0));
                if (entity == null) {
                    return;
                }
                ((NPCHolder)entity).getNPC().data().setPersistent("waypointhashcode", (Object)element.hashCode());
            }

            @Override
            public void end() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.end", new Object[0]);
                this.markers.destroyMarkers();
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerChat(AsyncPlayerChatEvent event) {
                if (event.getMessage().contains("toggle path")) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            this.togglePath();
                        }
                    });
                } else if (event.getMessage().contains("clear")) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            GuidedWaypointProvider.this.available.clear();
                            GuidedWaypointProvider.this.helpers.clear();
                            if (showPath) {
                                markers.destroyMarkers();
                            }
                        }
                    });
                }
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteract(PlayerInteractEvent event) {
                if (!event.getPlayer().equals(player) || event.getAction() == Action.PHYSICAL || event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null || Util.isOffHand(event)) {
                    return;
                }
                if (event.getPlayer().getWorld() != GuidedWaypointProvider.this.npc.getEntity().getWorld()) {
                    return;
                }
                event.setCancelled(true);
                Location at = event.getClickedBlock().getLocation();
                for (Waypoint waypoint : GuidedWaypointProvider.this.waypoints()) {
                    if (!waypoint.getLocation().equals((Object)at)) continue;
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.already-taken", new Object[0]);
                    return;
                }
                Waypoint element = new Waypoint(at);
                if (player.isSneaking()) {
                    GuidedWaypointProvider.this.available.add(element);
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.added-available", new Object[0]);
                } else {
                    GuidedWaypointProvider.this.helpers.add(element);
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.added-guide", new Object[0]);
                }
                if (this.showPath) {
                    this.createWaypointMarkerWithData(element);
                }
                GuidedWaypointProvider.this.rebuildTree();
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
                NPC clicked = CitizensAPI.getNPCRegistry().getNPC(event.getRightClicked());
                if (clicked == null || Util.isOffHand(event)) {
                    return;
                }
                Integer hashcode = (Integer)clicked.data().get("waypointhashcode");
                if (hashcode == null) {
                    return;
                }
                Iterator itr = Iterables.concat((Iterable)GuidedWaypointProvider.this.available, (Iterable)GuidedWaypointProvider.this.helpers).iterator();
                while (itr.hasNext()) {
                    Waypoint point = (Waypoint)itr.next();
                    if (point.hashCode() != hashcode.intValue()) continue;
                    this.markers.removeMarker(point);
                    itr.remove();
                    break;
                }
            }

            private void togglePath() {
                boolean bl = this.showPath = !this.showPath;
                if (this.showPath) {
                    this.createWaypointMarkers();
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.linear.showing-markers", new Object[0]);
                } else {
                    this.markers.destroyMarkers();
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.linear.not-showing-markers", new Object[0]);
                }
            }
        };
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void load(DataKey key) {
        Waypoint waypoint;
        for (DataKey root : key.getRelative("availablewaypoints").getIntegerSubKeys()) {
            waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, root));
            if (waypoint == null) continue;
            this.available.add(waypoint);
        }
        for (DataKey root : key.getRelative("helperwaypoints").getIntegerSubKeys()) {
            waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, root));
            if (waypoint == null) continue;
            this.helpers.add(waypoint);
        }
        this.rebuildTree();
    }

    @Override
    public void onRemove() {
        this.npc.getDefaultGoalController().removeGoal(this.currentGoal);
    }

    @Override
    public void onSpawn(NPC npc) {
        this.npc = npc;
        if (this.currentGoal == null) {
            this.currentGoal = new GuidedAIGoal();
            npc.getDefaultGoalController().addGoal(this.currentGoal, 1);
        }
    }

    private void rebuildTree() {
        this.tree = PhTree.create((int)3);
        for (Waypoint waypoint : this.waypoints()) {
            this.tree.put(new long[]{waypoint.getLocation().getBlockX(), waypoint.getLocation().getBlockY(), waypoint.getLocation().getBlockZ()}, (Object)waypoint);
        }
        if (this.currentGoal != null) {
            this.currentGoal.onProviderChanged();
        }
    }

    @Override
    public void save(DataKey key) {
        int i;
        key.removeKey("availablewaypoints");
        DataKey root = key.getRelative("availablewaypoints");
        for (i = 0; i < this.available.size(); ++i) {
            PersistenceLoader.save(this.available.get(i), root.getRelative(i));
        }
        key.removeKey("helperwaypoints");
        root = key.getRelative("helperwaypoints");
        for (i = 0; i < this.helpers.size(); ++i) {
            PersistenceLoader.save(this.helpers.get(i), root.getRelative(i));
        }
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
        if (this.currentGoal != null) {
            this.currentGoal.onProviderChanged();
        }
    }

    @Override
    public Iterable<Waypoint> waypoints() {
        return Iterables.concat(this.available, this.helpers);
    }

    private class GuidedAIGoal
    implements Goal {
        private GuidedPlan plan;

        private GuidedAIGoal() {
        }

        public void onProviderChanged() {
            if (this.plan != null) {
                this.reset();
                if (GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                    GuidedWaypointProvider.this.npc.getNavigator().cancelNavigation();
                }
            }
        }

        @Override
        public void reset() {
            this.plan = null;
        }

        @Override
        public void run(GoalSelector selector) {
            if (this.plan == null || this.plan.isComplete()) {
                selector.finish();
                return;
            }
            if (GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                return;
            }
            Waypoint current = this.plan.getCurrentWaypoint();
            GuidedWaypointProvider.this.npc.getNavigator().setTarget(current.getLocation());
            GuidedWaypointProvider.this.npc.getNavigator().getLocalParameters().addSingleUseCallback(new NavigatorCallback(){

                @Override
                public void onCompletion(CancelReason cancelReason) {
                    if (GuidedAIGoal.this.plan != null) {
                        GuidedAIGoal.this.plan.update(GuidedWaypointProvider.this.npc);
                    }
                }
            });
        }

        @Override
        public boolean shouldExecute(GoalSelector selector) {
            if (GuidedWaypointProvider.this.paused || GuidedWaypointProvider.this.available.size() == 0 || !GuidedWaypointProvider.this.npc.isSpawned() || GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                return false;
            }
            Waypoint target = (Waypoint)GuidedWaypointProvider.this.available.get(Util.getFastRandom().nextInt(GuidedWaypointProvider.this.available.size()));
            this.plan = (GuidedPlan)ASTAR.runFully(new GuidedGoal(target), new GuidedNode(null, new Waypoint(GuidedWaypointProvider.this.npc.getStoredLocation())));
            return this.plan != null;
        }
    }

    private static class GuidedPlan
    implements Plan {
        private int index = 0;
        private final Waypoint[] path;

        public GuidedPlan(Iterable<GuidedNode> path) {
            this.path = (Waypoint[])Iterables.toArray((Iterable)Iterables.transform(path, (Function)new Function<GuidedNode, Waypoint>(){

                public Waypoint apply(GuidedNode to) {
                    return to.waypoint;
                }
            }), Waypoint.class);
        }

        public Waypoint getCurrentWaypoint() {
            return this.path[this.index];
        }

        @Override
        public boolean isComplete() {
            return this.index >= this.path.length;
        }

        @Override
        public void update(Agent agent) {
            ++this.index;
        }
    }

    private class GuidedNode
    extends AStarNode {
        private final Waypoint waypoint;

        public GuidedNode(GuidedNode parent, Waypoint waypoint) {
            super(parent);
            this.waypoint = waypoint;
        }

        @Override
        public Plan buildPlan() {
            return new GuidedPlan(this.getParents());
        }

        public double distance(Waypoint dest) {
            return this.waypoint.distance(dest);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GuidedNode other = (GuidedNode)obj;
            return !(this.waypoint == null ? other.waypoint != null : !this.waypoint.equals(other.waypoint));
        }

        @Override
        public Iterable<AStarNode> getNeighbours() {
            PhFilterDistance filter = new PhFilterDistance();
            filter.set(new long[]{this.waypoint.getLocation().getBlockX(), this.waypoint.getLocation().getBlockY(), this.waypoint.getLocation().getBlockZ()}, (PhDistance)PhDistanceL.THIS, 10.0);
            PhTree.PhKnnQuery res = GuidedWaypointProvider.this.tree.nearestNeighbour(100, (PhDistance)PhDistanceL.THIS, (PhFilter)filter, new long[]{this.waypoint.getLocation().getBlockX(), this.waypoint.getLocation().getBlockY(), this.waypoint.getLocation().getBlockZ()});
            final ArrayList resList = Lists.newArrayList();
            res.forEachRemaining((Consumer)new Consumer<Waypoint>(){

                @Override
                public void accept(Waypoint n) {
                    resList.add(new GuidedNode(null, n));
                }
            });
            return resList;
        }

        @Override
        public int hashCode() {
            return 31 + (this.waypoint == null ? 0 : this.waypoint.hashCode());
        }
    }

    private static class GuidedGoal
    implements AStarGoal<GuidedNode> {
        private final Waypoint dest;

        public GuidedGoal(Waypoint dest) {
            this.dest = dest;
        }

        @Override
        public float g(GuidedNode from, GuidedNode to) {
            return (float)from.distance(to.waypoint);
        }

        @Override
        public float getInitialCost(GuidedNode node) {
            return this.h(node);
        }

        @Override
        public float h(GuidedNode from) {
            return (float)from.distance(this.dest);
        }

        @Override
        public boolean isFinished(GuidedNode node) {
            return node.waypoint.equals(this.dest);
        }
    }
}

