/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.npc.ai.NPCHolder;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class EntityMarkers<T> {
    private final Map<T, Entity> markers = Maps.newHashMap();
    private final NPCRegistry registry = CitizensAPI.createCitizensBackedNPCRegistry(new MemoryNPCDataStore());
    private EntityType type;
    private static EntityType DEFAULT_ENTITY_TYPE = EntityType.ENDER_SIGNAL;

    public EntityMarkers() {
        this(DEFAULT_ENTITY_TYPE);
    }

    public EntityMarkers(EntityType type) {
        this.type = type;
    }

    public Entity createMarker(T marker, Location at) {
        Entity entity = this.spawnMarker(at.getWorld(), at);
        if (entity == null) {
            return null;
        }
        this.markers.put(marker, entity);
        return entity;
    }

    public void destroyMarkers() {
        this.registry.deregisterAll();
        this.markers.clear();
    }

    public void removeMarker(T marker) {
        Entity entity = this.markers.remove(marker);
        if (entity != null) {
            ((NPCHolder)entity).getNPC().destroy();
        }
    }

    public Entity spawnMarker(World world, Location at) {
        NPC npc = this.registry.createNPC(this.type, "");
        npc.spawn(at.clone().add(0.5, 0.0, 0.5), SpawnReason.CREATE);
        return npc.getEntity();
    }

    static {
        try {
            DEFAULT_ENTITY_TYPE = EntityType.valueOf((String)"SHULKER_BULLET");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

