/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Panda;

@TraitName(value="pandatrait")
public class PandaTrait
extends Trait {
    @Persist
    private Panda.Gene hiddenGene;
    @Persist
    private Panda.Gene mainGene = Panda.Gene.NORMAL;
    @Persist
    private boolean sitting;

    public PandaTrait() {
        super("pandatrait");
    }

    public Panda.Gene getHiddenGene() {
        return this.hiddenGene;
    }

    public Panda.Gene getMainGene() {
        return this.mainGene;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Panda) {
            Panda panda = (Panda)this.npc.getEntity();
            panda.setMainGene(this.mainGene);
            NMS.setPandaSitting(this.npc.getEntity(), this.sitting);
            if (this.hiddenGene != null) {
                panda.setHiddenGene(this.hiddenGene);
            }
        }
    }

    public void setHiddenGene(Panda.Gene gene) {
        this.hiddenGene = gene;
    }

    public void setMainGene(Panda.Gene gene) {
        this.mainGene = gene;
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
    }

    public boolean toggleSitting() {
        this.sitting = !this.sitting;
        return this.sitting;
    }

    @Command(aliases={"npc"}, usage="panda --gene (main gene) --hiddengene (hidden gene) -s(itting)", desc="Sets panda modifiers", modifiers={"panda"}, flags="s", min=1, max=1, permission="citizens.npc.panda")
    @Requirements(selected=true, ownership=true, types={EntityType.PANDA})
    public static void panda(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"gene"}) Panda.Gene gene, @Flag(value={"hiddengene"}) Panda.Gene hiddengene) throws CommandException {
        PandaTrait trait = npc.getOrAddTrait(PandaTrait.class);
        String output = "";
        if (args.hasValueFlag("gene")) {
            if (gene == null) {
                throw new CommandUsageException("citizens.commands.npc.panda.invalid-gene", Util.listValuesPretty(Panda.Gene.values()));
            }
            trait.setMainGene(gene);
            output = output + ' ' + Messaging.tr("citizens.commands.npc.panda.main-gene-set", args.getFlag("gene"));
        }
        if (args.hasValueFlag("hiddengene")) {
            if (hiddengene == null) {
                throw new CommandUsageException("citizens.commands.npc.panda.invalid-gene", Util.listValuesPretty(Panda.Gene.values()));
            }
            trait.setHiddenGene(hiddengene);
            output = output + ' ' + Messaging.tr("citizens.commands.npc.panda.hidden-gene-set", hiddengene);
        }
        if (args.hasFlag('s')) {
            boolean isSitting = trait.toggleSitting();
            output = output + ' ' + Messaging.tr(isSitting ? "citizens.commands.npc.panda.sitting" : "citizens.commands.npc.panda.stopped-sitting", new Object[0]);
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output.trim());
    }
}

