/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.MushroomCow;

@TraitName(value="mushroomcowtrait")
public class MushroomCowTrait
extends Trait {
    @Persist(value="variant")
    private MushroomCow.Variant variant;

    public MushroomCowTrait() {
        super("mushroomcowtrait");
    }

    public MushroomCow.Variant getVariant() {
        return this.variant;
    }

    @Override
    public void onSpawn() {
        this.setVariant(this.variant);
    }

    @Override
    public void run() {
        if (this.variant != null && this.npc.getEntity() instanceof MushroomCow) {
            ((MushroomCow)this.npc.getEntity()).setVariant(this.variant);
        }
    }

    public void setVariant(MushroomCow.Variant variant) {
        this.variant = variant;
    }

    @Command(aliases={"npc"}, usage="mcow (--variant [variant])", desc="Sets mushroom cow modifiers.", modifiers={"mcow", "mushroomcow"}, min=1, max=1, permission="citizens.npc.mushroomcow")
    @Requirements(selected=true, ownership=true, types={EntityType.MUSHROOM_COW})
    public static void mushroomcow(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"variant"}) MushroomCow.Variant variant) throws CommandException {
        MushroomCowTrait trait = npc.getOrAddTrait(MushroomCowTrait.class);
        boolean hasArg = false;
        if (args.hasValueFlag("variant")) {
            if (variant == null) {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.mushroomcow.invalid-variant", Util.listValuesPretty(MushroomCow.Variant.values()));
                return;
            }
            trait.setVariant(variant);
            Messaging.sendTr(sender, "citizens.commands.npc.mushroomcow.variant-set", npc.getName(), variant);
            hasArg = true;
        }
        if (!hasArg) {
            throw new CommandUsageException();
        }
    }
}

