/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Goat;

@TraitName(value="goattrait")
public class GoatTrait
extends Trait {
    @Persist
    private boolean leftHorn = true;
    @Persist
    private boolean rightHorn = true;
    private static boolean SUPPORTS_HORNS = true;

    public GoatTrait() {
        super("goattrait");
    }

    public boolean isLeftHorn() {
        return this.leftHorn;
    }

    public boolean isRightHorn() {
        return this.rightHorn;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Goat) {
            Goat goat = (Goat)this.npc.getEntity();
            if (SUPPORTS_HORNS) {
                try {
                    goat.setRightHorn(this.rightHorn);
                    goat.setLeftHorn(this.leftHorn);
                }
                catch (Throwable t) {
                    SUPPORTS_HORNS = false;
                }
            }
        }
    }

    public void setLeftHorn(boolean horn) {
        this.leftHorn = horn;
    }

    public void setRightHorn(boolean horn) {
        this.rightHorn = horn;
    }

    @Command(aliases={"npc"}, usage="goat -l(eft) -r(ight) -n(either) -b(oth) horn", desc="Sets goat modifiers", modifiers={"goat"}, flags="lrnb", min=1, max=1, permission="citizens.npc.goat")
    @Requirements(selected=true, ownership=true, types={EntityType.GOAT})
    public static void goat(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        GoatTrait trait = npc.getOrAddTrait(GoatTrait.class);
        boolean left = trait.isLeftHorn();
        boolean right = trait.isRightHorn();
        if (args.hasFlag('l')) {
            boolean bl = left = !left;
        }
        if (args.hasFlag('r')) {
            boolean bl = right = !right;
        }
        if (args.hasFlag('b')) {
            right = true;
            left = true;
        }
        if (args.hasFlag('n')) {
            right = false;
            left = false;
        }
        trait.setLeftHorn(left);
        trait.setRightHorn(right);
        String output = Messaging.tr("citizens.commands.npc.goat.horns-set", npc.getName(), left, right);
        if (!output.isEmpty()) {
            Messaging.send(sender, output);
        }
    }
}

