/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@TraitName(value="bossbar")
public class BossBarTrait
extends Trait {
    private BossBar barCache;
    @Persist(value="color")
    private BarColor color = BarColor.PURPLE;
    @Persist(value="flags")
    private List<BarFlag> flags = Lists.newArrayList();
    @Persist(value="style")
    private BarStyle style = BarStyle.SOLID;
    @Persist(value="title")
    private String title = "";
    @Persist(value="track")
    private String track;
    @Persist(value="visible")
    private boolean visible = true;
    private static boolean SUPPORT_ATTRIBUTES = true;

    public BossBarTrait() {
        super("bossbar");
    }

    private BossBar getBar() {
        if (this.npc.isSpawned() && this.isBoss(this.npc.getEntity())) {
            return (BossBar)NMS.getBossBar(this.npc.getEntity());
        }
        if (this.barCache == null) {
            this.barCache = Bukkit.getServer().createBossBar(this.npc.getFullName(), this.color, this.style, this.flags.toArray(new BarFlag[this.flags.size()]));
        }
        return this.barCache;
    }

    public BarColor getColor() {
        return this.color;
    }

    public List<BarFlag> getFlags() {
        return this.flags;
    }

    public BarStyle getStyle() {
        return this.style;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTrackingVariable() {
        return this.track;
    }

    private boolean isBoss(Entity entity) {
        boolean isBoss;
        boolean bl = isBoss = entity.getType() == EntityType.ENDER_DRAGON || entity.getType() == EntityType.WITHER || entity.getType() == EntityType.GUARDIAN;
        if (isBoss) {
            this.barCache = null;
        }
        return isBoss;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void onDespawn() {
        if (this.barCache != null) {
            this.barCache.removeAll();
            this.barCache.hide();
            this.barCache = null;
        }
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        BossBar bar = this.getBar();
        if (bar == null) {
            return;
        }
        if (this.track != null && !this.track.isEmpty() && this.npc.getEntity() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)this.npc.getEntity();
            if (this.track.equalsIgnoreCase("health")) {
                double maxHealth = entity.getMaxHealth();
                if (SUPPORT_ATTRIBUTES) {
                    try {
                        maxHealth = entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
                    }
                    catch (Throwable t) {
                        SUPPORT_ATTRIBUTES = false;
                    }
                }
                bar.setProgress(entity.getHealth() / maxHealth);
            } else {
                String replaced = Placeholders.replace(this.track, this.npc.getEntity() instanceof Player ? (Player)this.npc.getEntity() : null);
                if (!this.track.equals(replaced)) {
                    try {
                        bar.setProgress(Double.parseDouble(replaced));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        bar.setTitle(this.title);
        bar.setVisible(this.visible);
        if (this.style != null) {
            bar.setStyle(this.style);
        }
        if (this.color != null) {
            bar.setColor(this.color);
        }
        for (BarFlag flag : BarFlag.values()) {
            bar.removeFlag(flag);
        }
        for (BarFlag flag : this.flags) {
            bar.addFlag(flag);
        }
        if (this.barCache != null) {
            this.barCache.removeAll();
            for (Entity entity : this.npc.getEntity().getNearbyEntities((double)(Settings.Setting.BOSSBAR_RANGE.asInt() / 2), (double)(Settings.Setting.BOSSBAR_RANGE.asInt() / 2), (double)(Settings.Setting.BOSSBAR_RANGE.asInt() / 2))) {
                if (!(entity instanceof Player)) continue;
                this.barCache.addPlayer((Player)entity);
            }
        }
    }

    public void setColor(BarColor color) {
        this.color = color;
    }

    public void setFlags(Collection<BarFlag> flags) {
        this.flags = Lists.newArrayList(flags);
    }

    public void setFlags(List<BarFlag> flags) {
        this.flags = flags;
    }

    public void setStyle(BarStyle style) {
        this.style = style;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTrackVariable(String variable) {
        this.track = variable;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Command(aliases={"npc"}, usage="bossbar --style [style] --color [color] --title [title] --visible [visible] --flags [flags] --track [health | placeholder]", desc="Edit bossbar properties", modifiers={"bossbar"}, min=1, max=1)
    @Requirements(selected=true, ownership=true)
    public static void bossbar(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"style"}) BarStyle style, @Flag(value={"track"}) String track, @Flag(value={"color"}) BarColor color, @Flag(value={"visible"}) Boolean visible, @Flag(value={"title"}) String title, @Flag(value={"flags"}) String flags) throws CommandException {
        BossBarTrait trait = npc.getOrAddTrait(BossBarTrait.class);
        if (style != null) {
            trait.setStyle(style);
        }
        if (color != null) {
            trait.setColor(color);
        }
        if (track != null) {
            trait.setTrackVariable(track);
        }
        if (title != null) {
            trait.setTitle(Colorizer.parseColors(title));
        }
        if (visible != null) {
            trait.setVisible(visible);
        }
        if (flags != null) {
            ArrayList parsed = Lists.newArrayList();
            for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)flags)) {
                BarFlag flag = (BarFlag)Util.matchEnum((Enum[])BarFlag.values(), (String)s);
                if (flag == null) continue;
                parsed.add(flag);
            }
            trait.setFlags(parsed);
        }
    }
}

